/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.spirits;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.spirits.GhostSpirit;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/syntaxdevteam/gravediggerx/spirits/GhostManager;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "activeGhosts", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lpl/syntaxdevteam/gravediggerx/spirits/GhostSpirit;", "createGhost", "graveOwnerId", "graveLocation", "Lorg/bukkit/Location;", "ownerName", "", "createGhostAndGetId", "removeGhost", "", "removeAllGhosts", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGhostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GhostManager.kt\npl/syntaxdevteam/gravediggerx/spirits/GhostManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1869#2,2:38\n*S KotlinDebug\n*F\n+ 1 GhostManager.kt\npl/syntaxdevteam/gravediggerx/spirits/GhostManager\n*L\n34#1:38,2\n*E\n"})
public final class GhostManager {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final ConcurrentHashMap<UUID, GhostSpirit> activeGhosts;

    public GhostManager(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.activeGhosts = new ConcurrentHashMap();
    }

    @Nullable
    public final GhostSpirit createGhost(@NotNull UUID graveOwnerId, @NotNull Location graveLocation, @NotNull String ownerName) {
        Intrinsics.checkNotNullParameter(graveOwnerId, "graveOwnerId");
        Intrinsics.checkNotNullParameter(graveLocation, "graveLocation");
        Intrinsics.checkNotNullParameter(ownerName, "ownerName");
        boolean enabled = this.plugin.getConfig().getBoolean("spirits.enabled", true);
        if (!enabled) {
            return null;
        }
        GhostSpirit ghost = new GhostSpirit(this.plugin, graveOwnerId, graveLocation);
        ghost.spawn();
        ((Map)this.activeGhosts).put(graveOwnerId, ghost);
        return ghost;
    }

    @Nullable
    public final UUID createGhostAndGetId(@NotNull UUID graveOwnerId, @NotNull Location graveLocation, @NotNull String ownerName) {
        Intrinsics.checkNotNullParameter(graveOwnerId, "graveOwnerId");
        Intrinsics.checkNotNullParameter(graveLocation, "graveLocation");
        Intrinsics.checkNotNullParameter(ownerName, "ownerName");
        GhostSpirit ghost = this.createGhost(graveOwnerId, graveLocation, ownerName);
        GhostSpirit ghostSpirit = ghost;
        return ghostSpirit != null && (ghostSpirit = ghostSpirit.getEntity()) != null ? ghostSpirit.getUniqueId() : null;
    }

    public final void removeGhost(@NotNull UUID graveOwnerId) {
        Intrinsics.checkNotNullParameter(graveOwnerId, "graveOwnerId");
        GhostSpirit ghostSpirit = this.activeGhosts.get(graveOwnerId);
        if (ghostSpirit != null) {
            ghostSpirit.despawn();
        }
        this.activeGhosts.remove(graveOwnerId);
    }

    public final void removeAllGhosts() {
        Collection<GhostSpirit> collection = this.activeGhosts.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GhostSpirit it = (GhostSpirit)element$iv;
            boolean bl = false;
            it.despawn();
        }
        this.activeGhosts.clear();
    }
}

