/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveExpirationAction;
import pl.syntaxdevteam.gravediggerx.graves.TimeGraveRemove;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "scheduledTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lorg/bukkit/scheduler/BukkitTask;", "scheduleRemoval", "", "grave", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "cancelRemoval", "cancelAll", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nTimeGraveRemove.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeGraveRemove.kt\npl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1869#2,2:97\n*S KotlinDebug\n*F\n+ 1 TimeGraveRemove.kt\npl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove\n*L\n92#1:97,2\n*E\n"})
public final class TimeGraveRemove {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final ConcurrentHashMap<UUID, BukkitTask> scheduledTasks;

    public TimeGraveRemove(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.scheduledTasks = new ConcurrentHashMap();
    }

    public final void scheduleRemoval(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        int totalSeconds = this.plugin.getConfig().getInt("graves.grave-despawn", 60);
        BukkitTask bukkitTask = this.scheduledTasks.get(grave.getOwnerId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        BukkitTask bukkitTask2 = new BukkitRunnable(totalSeconds, grave, this){
            private int secondsLeft;
            final /* synthetic */ Grave $grave;
            final /* synthetic */ TimeGraveRemove this$0;
            {
                this.$grave = $grave;
                this.this$0 = $receiver;
                this.secondsLeft = $totalSeconds;
            }

            public final int getSecondsLeft() {
                return this.secondsLeft;
            }

            public final void setSecondsLeft(int n) {
                this.secondsLeft = n;
            }

            public void run() {
                Player player = Bukkit.getPlayer((UUID)this.$grave.getOwnerId());
                if (TimeGraveRemove.access$getPlugin$p(this.this$0).getGraveManager().getGraveAt(this.$grave.getLocation()) == null) {
                    TimeGraveRemove.access$getScheduledTasks$p(this.this$0).remove(this.$grave.getOwnerId());
                    this.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)TimeGraveRemove.access$getPlugin$p(this.this$0), () -> scheduleRemoval.task.1.run$lambda$0(this.$grave, this.this$0, this, player));
                if (this.secondsLeft <= 0) {
                    Bukkit.getScheduler().runTask((Plugin)TimeGraveRemove.access$getPlugin$p(this.this$0), () -> scheduleRemoval.task.1.run$lambda$1(this.this$0, this.$grave));
                    TimeGraveRemove.access$getScheduledTasks$p(this.this$0).remove(this.$grave.getOwnerId());
                    this.cancel();
                    return;
                }
                int n = this.secondsLeft;
                this.secondsLeft = n + -1;
            }

            private static final void run$lambda$0(Grave $grave, TimeGraveRemove this$0, scheduleRemoval.task.1 this$1, Player $player) {
                if ($grave.getLocation().getBlock().getType() != Material.PLAYER_HEAD) {
                    TimeGraveRemove.access$getPlugin$p(this$0).getGraveManager().removeGrave($grave);
                    TimeGraveRemove.access$getScheduledTasks$p(this$0).remove($grave.getOwnerId());
                    this$1.cancel();
                    return;
                }
                if ($player != null && $player.isOnline()) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to("time", String.valueOf(this$1.secondsLeft)), TuplesKt.to("x", String.valueOf($grave.getLocation().getBlockX())), TuplesKt.to("y", String.valueOf($grave.getLocation().getBlockY())), TuplesKt.to("z", String.valueOf($grave.getLocation().getBlockZ()))};
                    Component msg = TimeGraveRemove.access$getPlugin$p(this$0).getMessageHandler().stringMessageToComponent("graves", "removal-countdown", MapsKt.mapOf(pairArray));
                    $player.sendActionBar(msg);
                }
            }

            private static final void run$lambda$1(TimeGraveRemove this$0, Grave $grave) {
                String string = TimeGraveRemove.access$getPlugin$p(this$0).getConfig().getString("graves.expiration-action", "DISAPPEAR");
                Intrinsics.checkNotNull(string);
                GraveExpirationAction expirationAction = GraveExpirationAction.Companion.fromString(string);
                TimeGraveRemove.access$getPlugin$p(this$0).getGhostManager().removeGhost($grave.getOwnerId());
                switch (scheduleRemoval.task.WhenMappings.$EnumSwitchMapping$0[expirationAction.ordinal()]) {
                    case 1: {
                        TimeGraveRemove.access$getPlugin$p(this$0).getGraveManager().dropGraveItems($grave);
                        TimeGraveRemove.access$getPlugin$p(this$0).getGraveManager().removeGrave($grave);
                        break;
                    }
                    case 2: {
                        TimeGraveRemove.access$getPlugin$p(this$0).getGraveManager().makeGravePublic($grave);
                        break;
                    }
                    case 3: {
                        TimeGraveRemove.access$getPlugin$p(this$0).getGraveManager().removeGrave($grave);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask2, "runTaskTimerAsynchronously(...)");
        BukkitTask task2 = bukkitTask2;
        ((Map)this.scheduledTasks).put(grave.getOwnerId(), task2);
    }

    public final void cancelRemoval(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        BukkitTask bukkitTask = this.scheduledTasks.get(grave.getOwnerId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.scheduledTasks.remove(grave.getOwnerId());
    }

    public final void cancelAll() {
        Collection<BukkitTask> collection = this.scheduledTasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BukkitTask it = (BukkitTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.scheduledTasks.clear();
    }

    public static final /* synthetic */ GraveDiggerX access$getPlugin$p(TimeGraveRemove $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getScheduledTasks$p(TimeGraveRemove $this) {
        return $this.scheduledTasks;
    }
}

