/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.graves.Grave;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u001c\u0010\u001f\u001a\u00020\u00162\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0012\u0010#\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u001e\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0%2\b\u0010&\u001a\u0004\u0018\u00010\tH\u0002J\u001e\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u0016H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006."}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveSerializer;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "encodeGraves", "Lcom/google/gson/JsonArray;", "graves", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "encodeGraveToString", "", "grave", "decodeGravesFromString", "", "content", "decodeGraveFromString", "payload", "encodeGrave", "Lcom/google/gson/JsonObject;", "encodeLocation", "location", "Lorg/bukkit/Location;", "encodeItems", "items", "", "", "Lorg/bukkit/inventory/ItemStack;", "encodeArmor", "armorContents", "decodeGrave", "obj", "decodeLocation", "decodeItems", "", "array", "decodeArmor", "serializeItemStack", "itemStack", "deserializeItemFromJson", "json", "deserializeItemLegacyBase64", "data", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveSerializer.kt\npl/syntaxdevteam/gravediggerx/graves/GraveSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,207:1\n1869#2,2:208\n1617#2,9:210\n1869#2:219\n1870#2:222\n1626#2:223\n1869#2,2:228\n1869#2,2:230\n1#3:220\n1#3:221\n216#4,2:224\n216#4,2:226\n*S KotlinDebug\n*F\n+ 1 GraveSerializer.kt\npl/syntaxdevteam/gravediggerx/graves/GraveSerializer\n*L\n27#1:208,2\n37#1:210,9\n37#1:219\n37#1:222\n37#1:223\n145#1:228,2\n163#1:230,2\n37#1:221\n85#1:224,2\n96#1:226,2\n*E\n"})
public final class GraveSerializer {
    @NotNull
    public static final GraveSerializer INSTANCE = new GraveSerializer();
    @NotNull
    private static final Gson gson;

    private GraveSerializer() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final JsonArray encodeGraves(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        JsonArray array = new JsonArray();
        Iterable $this$forEach$iv = graves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Grave it = (Grave)element$iv;
            boolean bl = false;
            array.add((JsonElement)INSTANCE.encodeGrave(it));
        }
        return array;
    }

    @NotNull
    public final String encodeGraveToString(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        String string = gson.toJson((JsonElement)this.encodeGrave(grave));
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Grave> decodeGravesFromString(@NotNull String content) {
        List list;
        Intrinsics.checkNotNullParameter(content, "content");
        if (StringsKt.isBlank(content)) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapNotNullTo$iv$iv;
            JsonArray json = JsonParser.parseString((String)content).getAsJsonArray();
            Intrinsics.checkNotNull(json);
            Iterable $this$mapNotNull$iv = (Iterable)json;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Grave it$iv$iv;
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                JsonElement element = (JsonElement)element$iv$iv;
                boolean bl2 = false;
                Object object2 = INSTANCE;
                try {
                    GraveSerializer $this$decodeGravesFromString_u24lambda_u240_u240 = object2;
                    boolean bl3 = false;
                    JsonObject jsonObject = element.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
                    object = Result.constructor-impl($this$decodeGravesFromString_u24lambda_u240_u240.decodeGrave(jsonObject));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object2 = object;
                if ((Grave)(Result.isFailure-impl(object2) ? null : object2) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception exception) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final Grave decodeGraveFromString(@NotNull String payload) {
        Grave grave;
        Intrinsics.checkNotNullParameter(payload, "payload");
        if (StringsKt.isBlank(payload)) {
            return null;
        }
        try {
            JsonObject obj = JsonParser.parseString((String)payload).getAsJsonObject();
            Intrinsics.checkNotNull(obj);
            grave = this.decodeGrave(obj);
        }
        catch (Exception exception) {
            grave = null;
        }
        return grave;
    }

    private final JsonObject encodeGrave(Grave grave) {
        JsonObject graveJson = new JsonObject();
        graveJson.addProperty("ownerId", grave.getOwnerId().toString());
        graveJson.addProperty("ownerName", grave.getOwnerName());
        graveJson.add("location", (JsonElement)this.encodeLocation(grave.getLocation()));
        graveJson.add("items", (JsonElement)this.encodeItems(grave.getItems()));
        graveJson.add("armorContents", (JsonElement)this.encodeArmor(grave.getArmorContents()));
        graveJson.addProperty("originalBlockData", grave.getOriginalBlockData().getAsString());
        graveJson.addProperty("storedXp", (Number)grave.getStoredXp());
        graveJson.addProperty("createdAt", (Number)grave.getCreatedAt());
        UUID uUID = grave.getGhostEntityId();
        graveJson.addProperty("ghostEntityId", uUID != null ? uUID.toString() : null);
        graveJson.addProperty("ghostActive", Boolean.valueOf(grave.getGhostActive()));
        UUID uUID2 = grave.getLastAttackerId();
        graveJson.addProperty("lastAttackerId", uUID2 != null ? uUID2.toString() : null);
        graveJson.addProperty("itemsStolen", (Number)grave.getItemsStolen());
        return graveJson;
    }

    private final JsonObject encodeLocation(Location location) {
        JsonObject locationJson = new JsonObject();
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "world";
        }
        locationJson.addProperty("world", (String)object);
        locationJson.addProperty("x", (Number)location.getX());
        locationJson.addProperty("y", (Number)location.getY());
        locationJson.addProperty("z", (Number)location.getZ());
        locationJson.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
        locationJson.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
        return locationJson;
    }

    private final JsonArray encodeItems(Map<Integer, ? extends ItemStack> items) {
        JsonArray itemsArray = new JsonArray();
        Map<Integer, ? extends ItemStack> $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, ? extends ItemStack>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, ? extends ItemStack> element$iv;
            Map.Entry<Integer, ? extends ItemStack> entry = element$iv = iterator2.next();
            boolean bl = false;
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack itemStack = entry.getValue();
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("slot", (Number)slot);
            itemJson.add("item", (JsonElement)INSTANCE.serializeItemStack(itemStack));
            itemsArray.add((JsonElement)itemJson);
        }
        return itemsArray;
    }

    private final JsonObject encodeArmor(Map<String, ? extends ItemStack> armorContents) {
        JsonObject armor = new JsonObject();
        Map<String, ? extends ItemStack> $this$forEach$iv = armorContents;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends ItemStack>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends ItemStack> element$iv;
            Map.Entry<String, ? extends ItemStack> entry = element$iv = iterator2.next();
            boolean bl = false;
            String slot = entry.getKey();
            ItemStack itemStack = entry.getValue();
            armor.add(slot, (JsonElement)INSTANCE.serializeItemStack(itemStack));
        }
        return armor;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Grave decodeGrave(JsonObject obj) {
        location = this.decodeLocation(obj.getAsJsonObject("location"));
        items = this.decodeItems(obj.getAsJsonArray("items"));
        armorContents = this.decodeArmor(obj.getAsJsonObject("armorContents"));
        try {
            var7_5 = Bukkit.createBlockData((String)obj.get("originalBlockData").getAsString());
        }
        catch (Exception <unused var>) {
            var7_5 = Bukkit.createBlockData((Material)Material.STONE);
        }
        var6_8 = var7_5;
        Intrinsics.checkNotNull(var6_8);
        blockData = var6_8;
        v0 = UUID.fromString(obj.get("ownerId").getAsString());
        v1 = v0;
        Intrinsics.checkNotNullExpressionValue(v0, "fromString(...)");
        v2 /* !! */  = obj.get("ownerName");
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getAsString()) == null) {
            v2 /* !! */  = "Unknown";
        }
        v3 = location;
        v4 = items;
        v5 = armorContents;
        v6 = CollectionsKt.emptyList();
        v7 = blockData;
        v8 = obj.get("storedXp");
        v9 = v8 != null ? v8.getAsInt() : 0;
        v10 = obj.get("createdAt");
        v11 = v10 != null ? v10.getAsLong() : System.currentTimeMillis();
        v12 /* !! */  = obj.get("ghostEntityId");
        if (v12 /* !! */  == null) ** GOTO lbl-1000
        var9_10 = var8_7 = v12 /* !! */ ;
        var20_11 = v11;
        var19_12 = v9;
        var18_13 = v7;
        var17_14 = v6;
        var16_15 = v5;
        var15_16 = v4;
        var14_17 = v3;
        var13_18 /* !! */  = v2 /* !! */ ;
        var12_19 = v1;
        $i$a$-takeIf-GraveSerializer$decodeGrave$1 = false;
        var22_24 = it.isJsonNull() == false;
        v1 = var12_19;
        v2 /* !! */  = var13_18 /* !! */ ;
        v3 = var14_17;
        v4 = var15_16;
        v5 = var16_15;
        v6 = var17_14;
        v7 = var18_13;
        v9 = var19_12;
        v11 = var20_11;
        v12 /* !! */  = var22_24 != false ? var8_7 : null;
        if (v12 /* !! */  != null && (v12 /* !! */  = v12 /* !! */ .getAsString()) != null) {
            $i$a$-takeIf-GraveSerializer$decodeGrave$1 /* !! */  = v12 /* !! */ ;
            var20_11 = v11;
            var19_12 = v9;
            var18_13 = v7;
            var17_14 = v6;
            var16_15 = v5;
            var15_16 = v4;
            var14_17 = v3;
            var13_18 /* !! */  = v2 /* !! */ ;
            var12_19 = v1;
            $i$a$-let-GraveSerializer$decodeGrave$2 = false;
            var22_25 = UUID.fromString((String)p0);
            v1 = var12_19;
            v2 /* !! */  = var13_18 /* !! */ ;
            v3 = var14_17;
            v4 = var15_16;
            v5 = var16_15;
            v6 = var17_14;
            v7 = var18_13;
            v9 = var19_12;
            v11 = var20_11;
            v13 = var22_25;
        } else lbl-1000:
        // 2 sources

        {
            v13 = null;
        }
        v14 = obj.get("ghostActive");
        v15 = v14 != null ? v14.getAsBoolean() : false;
        v16 /* !! */  = obj.get("lastAttackerId");
        if (v16 /* !! */  == null) ** GOTO lbl-1000
        it = var8_7 = v16 /* !! */ ;
        var23_28 = v15;
        var22_26 = v13;
        var20_11 = v11;
        var19_12 = v9;
        var18_13 = v7;
        var17_14 = v6;
        var16_15 = v5;
        var15_16 = v4;
        var14_17 = v3;
        var13_18 /* !! */  = v2 /* !! */ ;
        var12_19 = v1;
        $i$a$-takeIf-GraveSerializer$decodeGrave$3 = false;
        var24_29 = it.isJsonNull() == false;
        v1 = var12_19;
        v2 /* !! */  = var13_18 /* !! */ ;
        v3 = var14_17;
        v4 = var15_16;
        v5 = var16_15;
        v6 = var17_14;
        v7 = var18_13;
        v9 = var19_12;
        v11 = var20_11;
        v13 = var22_26;
        v15 = var23_28;
        v16 /* !! */  = var24_29 != false ? var8_7 : null;
        if (v16 /* !! */  != null && (v16 /* !! */  = v16 /* !! */ .getAsString()) != null) {
            $i$a$-takeIf-GraveSerializer$decodeGrave$3 /* !! */  = v16 /* !! */ ;
            var23_28 = v15;
            var22_26 = v13;
            var20_11 = v11;
            var19_12 = v9;
            var18_13 = v7;
            var17_14 = v6;
            var16_15 = v5;
            var15_16 = v4;
            var14_17 = v3;
            var13_18 /* !! */  = v2 /* !! */ ;
            var12_19 = v1;
            $i$a$-let-GraveSerializer$decodeGrave$4 = false;
            var24_30 = UUID.fromString((String)p0);
            v1 = var12_19;
            v2 /* !! */  = var13_18 /* !! */ ;
            v3 = var14_17;
            v4 = var15_16;
            v5 = var16_15;
            v6 = var17_14;
            v7 = var18_13;
            v9 = var19_12;
            v11 = var20_11;
            v13 = var22_26;
            v15 = var23_28;
            v17 = var24_30;
        } else lbl-1000:
        // 2 sources

        {
            v17 = null;
        }
        v18 = obj.get("itemsStolen");
        var25_31 = v18 != null ? v18.getAsInt() : 0;
        var26_32 = v17;
        var27_33 = v15;
        var28_34 = v13;
        var29_35 = v11;
        var31_36 = v9;
        var32_37 = v7;
        var33_38 = v6;
        var34_39 = v5;
        var35_40 = v4;
        var36_41 = v3;
        var37_42 /* !! */  = v2 /* !! */ ;
        var38_43 = v1;
        return new Grave(var38_43, (String)var37_42 /* !! */ , var36_41, var35_40, var34_39, var33_38, var32_37, var31_36, var29_35, var28_34, var27_33, var26_32, var25_31);
    }

    /*
     * Unable to fully structure code
     */
    private final Location decodeLocation(JsonObject obj) {
        if (obj == null || (var3_2 = obj.get("world")) == null || (var4_4 = var3_2.getAsString()) == null) ** GOTO lbl-1000
        it = var4_4;
        $i$a$-let-GraveSerializer$decodeLocation$world$1 = false;
        var5_8 = Bukkit.getWorld((String)it);
        if (var5_8 != null) {
            v0 = var5_8;
        } else lbl-1000:
        // 2 sources

        {
            v1 = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(v1, "getWorlds(...)");
            v0 = (World)CollectionsKt.firstOrNull(v1);
            if (v0 == null) {
                v0 = Bukkit.getWorld((String)"world");
            }
        }
        world = v0;
        v2 = obj;
        x = v2 != null && (v2 = v2.get("x")) != null ? v2.getAsDouble() : 0.0;
        v3 = obj;
        y = v3 != null && (v3 = v3.get("y")) != null ? v3.getAsDouble() : 0.0;
        v4 = obj;
        z = v4 != null && (v4 = v4.get("z")) != null ? v4.getAsDouble() : 0.0;
        v5 = obj;
        yaw = v5 != null && (v5 = v5.get("yaw")) != null ? v5.getAsFloat() : 0.0f;
        v6 = obj;
        pitch = v6 != null && (v6 = v6.get("pitch")) != null ? v6.getAsFloat() : 0.0f;
        return new Location(world, x, y, z, yaw, pitch);
    }

    private final Map<Integer, ItemStack> decodeItems(JsonArray array) {
        if (array == null) {
            return new LinkedHashMap();
        }
        Map items = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)array;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack itemStack;
            JsonElement element = (JsonElement)element$iv;
            boolean bl = false;
            JsonObject itemObj = element.getAsJsonObject();
            int slot = itemObj.get("slot").getAsInt();
            if (itemObj.has("item") && itemObj.get("item").isJsonObject()) {
                JsonObject jsonObject = itemObj.getAsJsonObject("item");
                Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
                itemStack = INSTANCE.deserializeItemFromJson(jsonObject);
            } else if (itemObj.has("data") && itemObj.get("data").isJsonPrimitive()) {
                String string = itemObj.get("data").getAsString();
                Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                itemStack = INSTANCE.deserializeItemLegacyBase64(string);
            } else {
                itemStack = new ItemStack(Material.AIR);
            }
            ItemStack itemStack2 = itemStack;
            items.put(slot, itemStack2);
        }
        return items;
    }

    private final Map<String, ItemStack> decodeArmor(JsonObject obj) {
        if (obj == null) {
            return MapsKt.emptyMap();
        }
        Map map = new LinkedHashMap();
        Set set = obj.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "entrySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(entry);
            String slot = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            Object object2 = INSTANCE;
            try {
                GraveSerializer $this$decodeArmor_u24lambda_u240_u240 = object2;
                boolean bl2 = false;
                JsonObject jsonObject = element.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
                object = Result.constructor-impl($this$decodeArmor_u24lambda_u240_u240.deserializeItemFromJson(jsonObject));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object2 = object;
            object = new ItemStack(Material.AIR);
            ItemStack stack = (ItemStack)(Result.isFailure-impl(object2) ? object : object2);
            map.put(slot, stack);
        }
        return map;
    }

    private final JsonObject serializeItemStack(ItemStack itemStack) {
        JsonObject jsonObject;
        try {
            Map map = itemStack.serialize();
            Intrinsics.checkNotNullExpressionValue(map, "serialize(...)");
            Map map2 = map;
            jsonObject = gson.toJsonTree((Object)map2).getAsJsonObject();
            Intrinsics.checkNotNull(jsonObject);
        }
        catch (Exception exception) {
            jsonObject = new JsonObject();
        }
        return jsonObject;
    }

    private final ItemStack deserializeItemFromJson(JsonObject json) {
        ItemStack itemStack;
        try {
            Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            Object object = gson.fromJson((JsonElement)json, type2);
            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
            Map map = (Map)object;
            itemStack = ItemStack.deserialize((Map)map);
            Intrinsics.checkNotNull(itemStack);
        }
        catch (Exception exception) {
            itemStack = new ItemStack(Material.AIR);
        }
        return itemStack;
    }

    private final ItemStack deserializeItemLegacyBase64(String data) {
        ItemStack itemStack;
        try {
            if (((CharSequence)data).length() == 0) {
                return new ItemStack(Material.AIR);
            }
            byte[] decoded = Base64.getDecoder().decode(data);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
            Class<?> cls = Class.forName("org.bukkit.util.io.BukkitObjectInputStream");
            Class[] classArray = new Class[]{InputStream.class};
            Constructor<?> ctor = cls.getConstructor(classArray);
            Object object = new Object[]{inputStream};
            Object obj = ctor.newInstance(object);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type java.io.ObjectInputStream");
            ObjectInputStream dataInput = (ObjectInputStream)obj;
            object = dataInput.readObject();
            ItemStack itemStack2 = object instanceof ItemStack ? (ItemStack)object : null;
            dataInput.close();
            ItemStack itemStack3 = itemStack2;
            if (itemStack3 == null) {
                itemStack3 = new ItemStack(Material.AIR);
            }
            itemStack = itemStack3;
        }
        catch (Exception exception) {
            itemStack = new ItemStack(Material.AIR);
        }
        return itemStack;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        GraveSerializer.gson = gson;
    }
}

