/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.SafeGravePlacer;
import pl.syntaxdevteam.gravediggerx.graves.TimeGraveRemove;
import pl.syntaxdevteam.gravediggerx.spirits.GhostManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u000eH\u0002J.\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u000eJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0019J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 2\u0006\u0010!\u001a\u00020\u000bJ&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020$J\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020$J\u0010\u0010,\u001a\u00020\b2\u0006\u0010#\u001a\u00020$H\u0002J\"\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u00100\u001a\u0004\u0018\u0001012\u0006\u0010!\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveManager;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "activeGraves", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "graveRemoveListeners", "Ljava/util/UUID;", "", "Lkotlin/Function0;", "", "notifyGraveRemoved", "grave", "loadGravesFromStorage", "saveGravesToStorage", "performSaveAsync", "createGraveAndGetIt", "player", "Lorg/bukkit/entity/Player;", "items", "", "", "Lorg/bukkit/inventory/ItemStack;", "xp", "removeAllGraves", "updateHologramWithTime", "time", "getGravesFor", "", "ownerId", "createHologram", "location", "Lorg/bukkit/Location;", "ownerName", "getGraveAt", "dropGraveItems", "makeGravePublic", "removeGrave", "removeGraveAt", "", "getKey", "applyPlayerProfile", "skull", "Lorg/bukkit/block/Skull;", "resolvePlayerProfile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "hasNearbyGrave", "target", "minDistanceBlocks", "ModernProfileSupport", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1869#2,2:401\n1788#2,4:403\n1869#2,2:408\n1869#2:410\n1869#2,2:411\n1870#2:413\n1869#2,2:414\n774#2:416\n865#2,2:417\n1869#2,2:419\n1869#2,2:421\n1869#2,2:423\n1761#2,3:425\n1869#2,2:428\n1#3:407\n*S KotlinDebug\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager\n*L\n21#1:401,2\n121#1:403,4\n190#1:408,2\n193#1:410\n202#1:411,2\n193#1:413\n217#1:414,2\n231#1:416\n231#1:417,2\n268#1:419,2\n293#1:421,2\n310#1:423,2\n390#1:425,3\n94#1:428,2\n*E\n"})
public final class GraveManager {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final ConcurrentHashMap<String, Grave> activeGraves;
    @NotNull
    private final ConcurrentHashMap<UUID, List<Function0<Unit>>> graveRemoveListeners;

    public GraveManager(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.activeGraves = new ConcurrentHashMap();
        this.graveRemoveListeners = new ConcurrentHashMap();
    }

    private final void notifyGraveRemoved(Grave grave) {
        List<Function0<Unit>> list = this.graveRemoveListeners.get(grave.getOwnerId());
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
        this.graveRemoveListeners.remove(grave.getOwnerId());
    }

    public final void loadGravesFromStorage() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof TextDisplay && ((TextDisplay)entity).getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "grave_hologram"), PersistentDataType.STRING)) {
                    ((TextDisplay)entity).remove();
                }
                if (!entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "grave_ghost"), PersistentDataType.STRING)) continue;
                entity.remove();
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0(this));
    }

    public final void saveGravesToStorage() {
        this.performSaveAsync();
    }

    private final void performSaveAsync() {
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List snapshot = CollectionsKt.toList((Iterable)collection);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> GraveManager.performSaveAsync$lambda$0(this, snapshot));
    }

    @Nullable
    public final Grave createGraveAndGetIt(@NotNull Player player, @NotNull Map<Integer, ? extends ItemStack> items, int xp) {
        Skull skull;
        Pair[] $this$createGraveAndGetIt_u24lambda_u242_u240;
        int maxVert;
        int radius;
        int playerGraves;
        Grave it;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(items, "items");
        int maxGraves = this.plugin.getConfig().getInt("graves.max-per-player", 3);
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv2 : $this$count$iv) {
                it = (Grave)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getOwnerId(), player.getUniqueId()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = playerGraves = count$iv;
        }
        if (playerGraves >= maxGraves) {
            Component message = this.plugin.getMessageHandler().stringMessageToComponent("graves", "reached-max-graves", MapsKt.mapOf(TuplesKt.to("limit", String.valueOf(maxGraves))));
            player.sendMessage(message);
            return null;
        }
        Object location = null;
        Location location2 = player.getLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "toBlockLocation(...)");
        location = location2;
        boolean safeEnabled = this.plugin.getConfig().getBoolean("graves.safe-placement.enabled", true);
        if (safeEnabled && (element$iv2 = SafeGravePlacer.INSTANCE.findSafeLocationNear((Location)location, radius = this.plugin.getConfig().getInt("graves.safe-placement.radius", 8), maxVert = this.plugin.getConfig().getInt("graves.safe-placement.max-vertical-scan", 3), (arg_0, arg_1) -> GraveManager.createGraveAndGetIt$lambda$1(this, arg_0, arg_1))) != null) {
            Object safeLoc = element$iv2;
            boolean bl = false;
            if (!Intrinsics.areEqual(safeLoc, location)) {
                GraveManager graveManager = this;
                try {
                    $this$createGraveAndGetIt_u24lambda_u242_u240 = graveManager;
                    boolean bl2 = false;
                    $this$createGraveAndGetIt_u24lambda_u242_u240.plugin.getLogger().debug("Relocating grave from " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + " to " + safeLoc.getBlockX() + "," + safeLoc.getBlockY() + "," + safeLoc.getBlockZ());
                    $this$createGraveAndGetIt_u24lambda_u242_u240 = Result.constructor-impl(Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $this$createGraveAndGetIt_u24lambda_u242_u240 = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                location = safeLoc;
            }
        }
        Block block = location.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        element$iv2 = block2.getType() != Material.AIR ? block2.getBlockData().clone() : Bukkit.createBlockData((Material)Material.AIR);
        Intrinsics.checkNotNull(element$iv2);
        Object originalBlockData = element$iv2;
        block2.setType(Material.PLAYER_HEAD);
        it = block2.getState();
        Skull skull2 = skull = it instanceof Skull ? (Skull)it : null;
        if (skull2 != null) {
            Grave $this$createGraveAndGetIt_u24lambda_u243 = it = skull2;
            boolean bl = false;
            $this$createGraveAndGetIt_u24lambda_u243.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "grave"), PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.applyPlayerProfile((Skull)$this$createGraveAndGetIt_u24lambda_u243, uUID, player.getName());
            $this$createGraveAndGetIt_u24lambda_u243.update(true, false);
        }
        int totalSeconds = this.plugin.getConfig().getInt("graves.grave-despawn", 60);
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        List<UUID> hologramIds = this.createHologram((Location)location, string, totalSeconds);
        GhostManager ghostManager = this.plugin.getGhostManager();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string2 = player.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        UUID ghostEntityId = ghostManager.createGhostAndGetId(uUID, (Location)location, string2);
        $this$createGraveAndGetIt_u24lambda_u242_u240 = new Pair[5];
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        $this$createGraveAndGetIt_u24lambda_u242_u240[0] = TuplesKt.to("helmet", itemStack.clone());
        ItemStack itemStack2 = player.getInventory().getChestplate();
        if (itemStack2 == null) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        $this$createGraveAndGetIt_u24lambda_u242_u240[1] = TuplesKt.to("chestplate", itemStack2.clone());
        ItemStack itemStack3 = player.getInventory().getLeggings();
        if (itemStack3 == null) {
            itemStack3 = new ItemStack(Material.AIR);
        }
        $this$createGraveAndGetIt_u24lambda_u242_u240[2] = TuplesKt.to("leggings", itemStack3.clone());
        ItemStack itemStack4 = player.getInventory().getBoots();
        if (itemStack4 == null) {
            itemStack4 = new ItemStack(Material.AIR);
        }
        $this$createGraveAndGetIt_u24lambda_u242_u240[3] = TuplesKt.to("boots", itemStack4.clone());
        $this$createGraveAndGetIt_u24lambda_u242_u240[4] = TuplesKt.to("offhand", player.getInventory().getItemInOffHand().clone());
        Map armorContents = MapsKt.mapOf($this$createGraveAndGetIt_u24lambda_u242_u240);
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID uUID3 = uUID2;
        String string3 = player.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        String string4 = string3;
        Object object = location;
        Map<Integer, ? extends ItemStack> map = MapsKt.toMutableMap(items);
        long l = System.currentTimeMillis();
        boolean bl = ghostEntityId != null;
        Grave grave = new Grave(uUID3, string4, (Location)object, map, armorContents, hologramIds, (BlockData)originalBlockData, xp, l, ghostEntityId, bl, null, 0);
        ((Map)this.activeGraves).put(this.getKey((Location)location), grave);
        this.plugin.getTimeGraveRemove().scheduleRemoval(grave);
        this.saveGravesToStorage();
        return grave;
    }

    public static /* synthetic */ Grave createGraveAndGetIt$default(GraveManager graveManager, Player player, Map map, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return graveManager.createGraveAndGetIt(player, map, n);
    }

    public final void removeAllGraves() {
        Grave grave;
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            grave = (Grave)element$iv;
            boolean bl = false;
            TimeGraveRemove timeGraveRemove = this.plugin.getTimeGraveRemove();
            Intrinsics.checkNotNull(grave);
            timeGraveRemove.cancelRemoval(grave);
        }
        Collection<Grave> collection2 = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block;
            Location location;
            grave = (Grave)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(grave.getLocation().toBlockLocation(), "toBlockLocation(...)");
            Intrinsics.checkNotNullExpressionValue(location.getBlock(), "getBlock(...)");
            if (block.getState() instanceof Skull) {
                BlockState blockState = block.getState();
                Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Skull");
                Skull state = (Skull)blockState;
                state.getPersistentDataContainer().remove(new NamespacedKey((Plugin)this.plugin, "grave"));
                state.update(true, false);
            }
            block.setBlockData(grave.getOriginalBlockData());
            Iterable $this$forEach$iv2 = grave.getHologramIds();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UUID id = (UUID)element$iv2;
                boolean bl2 = false;
                Entity entity = Bukkit.getEntity((UUID)id);
                if (entity == null) continue;
                entity.remove();
            }
            if (grave.getGhostEntityId() != null) {
                UUID id;
                boolean bl3 = false;
                Entity entity = Bukkit.getEntity((UUID)id);
                if (entity != null) {
                    entity.remove();
                }
            }
            this.plugin.getGhostManager().removeGhost(grave.getOwnerId());
            Intrinsics.checkNotNull(grave);
            this.notifyGraveRemoved(grave);
        }
        this.activeGraves.clear();
        this.plugin.getDatabaseHandler().writeGravesToJsonIfConfigured(CollectionsKt.emptyList());
    }

    public final void updateHologramWithTime(@NotNull Grave grave, int time) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        Iterable $this$forEach$iv = grave.getHologramIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID id = (UUID)element$iv;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)id);
            if (!(entity instanceof TextDisplay)) continue;
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", grave.getOwnerName()), TuplesKt.to("time", String.valueOf(time))};
            Component text = this.plugin.getMessageHandler().stringMessageToComponentNoPrefix("graveh", "hologram", MapsKt.mapOf(pairArray));
            ((TextDisplay)entity).text(text);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Grave> getGravesFor(@NotNull UUID ownerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ownerId, "ownerId");
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Grave it = (Grave)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwnerId(), ownerId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<UUID> createHologram(Location location, String ownerName, int time) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("player", ownerName), TuplesKt.to("time", String.valueOf(time))};
        Component text = this.plugin.getMessageHandler().stringMessageToComponentNoPrefix("graveh", "hologram", MapsKt.mapOf(pairArray));
        Location location2 = location.clone().add(0.5, 1.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        Location hologramLocation = location2;
        World world = hologramLocation.getWorld();
        if (world == null) {
            return CollectionsKt.emptyList();
        }
        World world2 = world;
        Entity entity = world2.spawn(hologramLocation, TextDisplay.class, arg_0 -> GraveManager.createHologram$lambda$1(arg_0 -> GraveManager.createHologram$lambda$0(text, this, ownerName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(entity, "spawn(...)");
        TextDisplay textDisplay = (TextDisplay)entity;
        return CollectionsKt.listOf(textDisplay.getUniqueId());
    }

    @Nullable
    public final Grave getGraveAt(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.activeGraves.get(this.getKey(location));
    }

    public final void dropGraveItems(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        Location location = grave.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        Iterable $this$forEach$iv = CollectionsKt.plus(grave.getItems().values(), (Iterable)grave.getArmorContents().values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack item = (ItemStack)element$iv;
            boolean bl = false;
            if (item.getType() == Material.AIR) continue;
            world2.dropItemNaturally(location, item);
        }
    }

    public final void makeGravePublic(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        this.plugin.getTimeGraveRemove().cancelRemoval(grave);
        this.activeGraves.remove(this.getKey(grave.getLocation()));
        this.saveGravesToStorage();
    }

    public final void removeGrave(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        this.plugin.getTimeGraveRemove().cancelRemoval(grave);
        Location location = grave.getLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location location2 = location;
        Block block = location2.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (block2.getState() instanceof Skull) {
            BlockState blockState = block2.getState();
            Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Skull");
            Skull state = (Skull)blockState;
            state.getPersistentDataContainer().remove(new NamespacedKey((Plugin)this.plugin, "grave"));
            state.update(true, false);
        }
        block2.setBlockData(grave.getOriginalBlockData());
        Iterable $this$forEach$iv = grave.getHologramIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)it);
            if (entity == null) continue;
            entity.remove();
        }
        UUID uUID = grave.getGhostEntityId();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)it);
            if (entity != null) {
                entity.remove();
            }
        }
        this.plugin.getGhostManager().removeGhost(grave.getOwnerId());
        this.activeGraves.remove(this.getKey(location2));
        this.notifyGraveRemoved(grave);
        this.saveGravesToStorage();
    }

    public final boolean removeGraveAt(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        Grave grave = this.getGraveAt(location);
        if (grave != null) {
            this.removeGrave(grave);
            return true;
        }
        Block block = location.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (block2.getType() == Material.PLAYER_HEAD) {
            Collection collection = location.getWorld().getNearbyEntities(location.clone().add(0.5, 1.5, 0.5), 1.0, 1.0, 1.0);
            Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                if (!(entity instanceof TextDisplay) || !((TextDisplay)entity).getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "grave_hologram"), PersistentDataType.STRING)) continue;
                ((TextDisplay)entity).remove();
            }
            block2.setType(Material.AIR);
            this.saveGravesToStorage();
            return true;
        }
        return false;
    }

    private final String getKey(Location location) {
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        Object worldName = object;
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return (String)worldName + ":" + x + ":" + y + ":" + z;
    }

    private final void applyPlayerProfile(Skull skull, UUID ownerId, String ownerName) {
        PlayerProfile playerProfile = this.resolvePlayerProfile(ownerId, ownerName);
        if (playerProfile == null) {
            return;
        }
        PlayerProfile profile = playerProfile;
        if (ModernProfileSupport.INSTANCE.trySetProfile(skull, profile)) {
            return;
        }
        skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)ownerId));
    }

    private final PlayerProfile resolvePlayerProfile(UUID ownerId, String ownerName) {
        PlayerProfile playerProfile;
        try {
            PlayerProfile $this$resolvePlayerProfile_u24lambda_u240 = playerProfile = Bukkit.createProfile((UUID)ownerId, (String)ownerName);
            boolean bl = false;
            $this$resolvePlayerProfile_u24lambda_u240.complete();
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Failed to resolve player profile for grave owner " + ownerName + ": " + ex.getMessage());
            playerProfile = null;
        }
        return playerProfile;
    }

    private final boolean hasNearbyGrave(Location target, int minDistanceBlocks) {
        boolean bl;
        block4: {
            Object object = target.getWorld();
            if (object == null || (object = object.getName()) == null) {
                return false;
            }
            Object worldName = object;
            int tx = target.getBlockX();
            int ty = target.getBlockY();
            int tz = target.getBlockZ();
            double minDistSq = minDistanceBlocks * minDistanceBlocks;
            Collection<Grave> collection = this.activeGraves.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    double dz;
                    double dy;
                    double dx;
                    Grave g = (Grave)element$iv;
                    boolean bl2 = false;
                    Location loc = g.getLocation();
                    World world = loc.getWorld();
                    if (!(!Intrinsics.areEqual(world != null ? world.getName() : null, worldName) ? false : (dx = (double)(loc.getBlockX() - tx)) * dx + (dy = (double)(loc.getBlockY() - ty)) * dy + (dz = (double)(loc.getBlockZ() - tz)) * dz < minDistSq)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void loadGravesFromStorage$lambda$0(GraveManager this$0) {
        List<Grave> loadedGraves = this$0.plugin.getDatabaseHandler().loadAllGraves();
        if (loadedGraves.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0(loadedGraves, this$0));
    }

    private static final void loadGravesFromStorage$lambda$0$0(List $loadedGraves, GraveManager this$0) {
        for (Grave grave : $loadedGraves) {
            World world;
            Location loc = grave.getLocation();
            if (loc.getWorld() == null) continue;
            world.getChunkAtAsync(loc).thenAccept(arg_0 -> GraveManager.loadGravesFromStorage$lambda$0$0$1(arg_0 -> GraveManager.loadGravesFromStorage$lambda$0$0$0(this$0, loc, grave, arg_0), arg_0));
        }
    }

    private static final Unit loadGravesFromStorage$lambda$0$0$0(GraveManager this$0, Location $loc, Grave $grave, Chunk it) {
        Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0$0$0($loc, this$0, $grave));
        return Unit.INSTANCE;
    }

    private static final void loadGravesFromStorage$lambda$0$0$0$0(Location $loc, GraveManager this$0, Grave $grave) {
        Skull skull;
        Block block = $loc.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        block2.setType(Material.PLAYER_HEAD);
        BlockState blockState = block2.getState();
        Skull skull2 = skull = blockState instanceof Skull ? (Skull)blockState : null;
        if (skull2 != null) {
            BlockState $this$loadGravesFromStorage_u24lambda_u240_u240_u240_u240_u240 = blockState = skull2;
            boolean bl = false;
            $this$loadGravesFromStorage_u24lambda_u240_u240_u240_u240_u240.getPersistentDataContainer().set(new NamespacedKey((Plugin)this$0.plugin, "grave"), PersistentDataType.STRING, (Object)$grave.getOwnerId().toString());
            this$0.applyPlayerProfile((Skull)$this$loadGravesFromStorage_u24lambda_u240_u240_u240_u240_u240, $grave.getOwnerId(), $grave.getOwnerName());
            $this$loadGravesFromStorage_u24lambda_u240_u240_u240_u240_u240.update(true, false);
        }
        int totalSeconds = this$0.plugin.getConfig().getInt("graves.grave-despawn", 60);
        List<UUID> hologramIds = this$0.createHologram($loc, $grave.getOwnerName(), totalSeconds);
        UUID ghostId = null;
        if ($grave.getGhostActive()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0$0$0$1(this$0, $grave, $loc), 40L);
        }
        Grave updated = Grave.copy$default($grave, null, null, null, null, null, hologramIds, null, 0, 0L, ghostId, $grave.getGhostActive(), null, 0, 6623, null);
        Iterable $this$forEach$iv = $grave.getHologramIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID oldId = (UUID)element$iv;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)oldId);
            if (entity == null) continue;
            entity.remove();
        }
        Location location = $loc.toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location blockLoc = location;
        ((Map)this$0.activeGraves).put(this$0.getKey(blockLoc), updated);
        this$0.plugin.getTimeGraveRemove().scheduleRemoval(updated);
    }

    private static final void loadGravesFromStorage$lambda$0$0$0$0$1(GraveManager this$0, Grave $grave, Location $loc) {
        Grave active;
        UUID newGhostId = this$0.plugin.getGhostManager().createGhostAndGetId($grave.getOwnerId(), $loc, $grave.getOwnerName());
        if (newGhostId != null && (active = this$0.activeGraves.get(this$0.getKey($loc))) != null) {
            Grave updated = Grave.copy$default(active, null, null, null, null, null, null, null, 0, 0L, newGhostId, true, null, 0, 6655, null);
            ((Map)this$0.activeGraves).put(this$0.getKey($loc), updated);
        }
    }

    private static final void loadGravesFromStorage$lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void performSaveAsync$lambda$0(GraveManager this$0, List $snapshot) {
        this$0.plugin.getDatabaseHandler().writeGravesToJsonIfConfigured($snapshot);
    }

    private static final boolean createGraveAndGetIt$lambda$1(GraveManager this$0, Location target, int minDistance) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this$0.hasNearbyGrave(target, minDistance);
    }

    private static final Unit createHologram$lambda$0(Component $text, GraveManager this$0, String $ownerName, TextDisplay display) {
        display.text($text);
        display.setBillboard(Display.Billboard.CENTER);
        display.setShadowed(false);
        display.setTextOpacity((byte)-1);
        display.setBackgroundColor(Color.fromARGB((int)120, (int)10, (int)10, (int)10));
        display.setBrightness(new Display.Brightness(15, 15));
        display.setSeeThrough(true);
        Transformation transformation = display.getTransformation();
        Intrinsics.checkNotNullExpressionValue(transformation, "getTransformation(...)");
        Transformation transform = transformation;
        transform.getScale().set((Vector3fc)new Vector3f(1.25f, 1.25f, 1.25f));
        display.setTransformation(transform);
        display.getPersistentDataContainer().set(new NamespacedKey((Plugin)this$0.plugin, "grave_hologram"), PersistentDataType.STRING, (Object)$ownerName);
        return Unit.INSTANCE;
    }

    private static final void createHologram$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveManager$ModernProfileSupport;", "", "<init>", "()V", "resolvableProfileClass", "Ljava/lang/Class;", "resolvableProfileFactory", "Ljava/lang/reflect/Method;", "skullSetProfileMethod", "trySetProfile", "", "skull", "Lorg/bukkit/block/Skull;", "profile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "GraveDiggerX"})
    @SourceDebugExtension(value={"SMAP\nGraveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager$ModernProfileSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
    private static final class ModernProfileSupport {
        @NotNull
        public static final ModernProfileSupport INSTANCE;
        @Nullable
        private static final Class<?> resolvableProfileClass;
        @Nullable
        private static final Method resolvableProfileFactory;
        @Nullable
        private static final Method skullSetProfileMethod;

        private ModernProfileSupport() {
        }

        public final boolean trySetProfile(@NotNull Skull skull, @NotNull PlayerProfile profile) {
            boolean bl;
            Intrinsics.checkNotNullParameter(skull, "skull");
            Intrinsics.checkNotNullParameter(profile, "profile");
            Method method = resolvableProfileFactory;
            if (method == null) {
                return false;
            }
            Method factory = method;
            Method method2 = skullSetProfileMethod;
            if (method2 == null) {
                return false;
            }
            Method setter = method2;
            try {
                Object[] objectArray = new Object[]{profile};
                Object resolvable = factory.invoke(null, objectArray);
                objectArray = new Object[]{resolvable};
                setter.invoke((Object)skull, objectArray);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        static {
            Method method;
            Method method2;
            Class[] classArray;
            Object object;
            Class<?> it;
            Class<?> clazz;
            INSTANCE = new ModernProfileSupport();
            try {
                clazz = Class.forName("io.papermc.paper.datacomponent.item.ResolvableProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            resolvableProfileClass = clazz;
            Class<?> clazz2 = resolvableProfileClass;
            if (clazz2 != null) {
                Object $this$resolvableProfileFactory_u24lambda_u240_u240;
                it = clazz2;
                boolean bl = false;
                object = INSTANCE;
                try {
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = object;
                    boolean bl2 = false;
                    classArray = new Class[]{PlayerProfile.class};
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = Result.constructor-impl(it.getMethod("resolvableProfile", classArray));
                }
                catch (Throwable bl2) {
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object = $this$resolvableProfileFactory_u24lambda_u240_u240;
                method2 = (Method)(Result.isFailure-impl(object) ? null : object);
            } else {
                method2 = null;
            }
            resolvableProfileFactory = method2;
            Class<?> clazz3 = resolvableProfileClass;
            if (clazz3 != null) {
                Object object2;
                it = clazz3;
                boolean bl = false;
                object = INSTANCE;
                try {
                    Object $this$skullSetProfileMethod_u24lambda_u240_u240 = object;
                    boolean bl3 = false;
                    classArray = new Class[]{it};
                    object2 = Result.constructor-impl(Skull.class.getMethod("setProfile", classArray));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object = object2;
                method = (Method)(Result.isFailure-impl(object) ? null : object);
            } else {
                method = null;
            }
            skullSetProfileMethod = method;
        }
    }
}

