/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b26\u0010\n\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bJP\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b26\u0010\n\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bJ*\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J*\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\bH\u0002\u00a8\u0006\u001e"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/SafeGravePlacer;", "", "<init>", "()V", "findSafeLocationNear", "Lorg/bukkit/Location;", "base", "radius", "", "maxVerticalScan", "hasNearbyGrave", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "target", "minDistanceBlocks", "", "findSafeLocationNether", "isSafeSpotNether", "adjustYToGround", "loc", "isPlaceableOn", "isSafeSpot", "isReplaceable", "type", "Lorg/bukkit/Material;", "isSolidGround", "isLavaOrLiquid", "hasSteepDrop", "maxDrop", "GraveDiggerX"})
public final class SafeGravePlacer {
    @NotNull
    public static final SafeGravePlacer INSTANCE = new SafeGravePlacer();

    private SafeGravePlacer() {
    }

    @Nullable
    public final Location findSafeLocationNear(@NotNull Location base, int radius, int maxVerticalScan, @NotNull Function2<? super Location, ? super Integer, Boolean> hasNearbyGrave) {
        int r;
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(hasNearbyGrave, "hasNearbyGrave");
        World world = base.getWorld();
        if (world == null) {
            return null;
        }
        World world2 = world;
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        Location location = this.adjustYToGround(new Location(world2, (double)baseX, (double)baseY, (double)baseZ), maxVerticalScan);
        if (location != null) {
            Location cand = location;
            boolean bl = false;
            if (INSTANCE.isSafeSpot(cand, hasNearbyGrave)) {
                return cand;
            }
        }
        if ((r = 1) <= radius) {
            while (true) {
                int z;
                int x;
                int n;
                int dz;
                Location cand;
                int z2;
                int dx;
                if ((dx = -r) <= r) {
                    while (true) {
                        int x2;
                        if (this.adjustYToGround(new Location(world2, (double)(x2 = baseX + dx) + 0.0, (double)baseY + 0.0, (double)(z2 = baseZ - r) + 0.0), maxVerticalScan) != null) {
                            boolean bl = false;
                            if (INSTANCE.isSafeSpot(cand, hasNearbyGrave)) {
                                return cand;
                            }
                        }
                        if (dx == r) break;
                        ++dx;
                    }
                }
                if ((dz = -r + 1) <= r) {
                    while (true) {
                        int x3;
                        if (this.adjustYToGround(new Location(world2, (double)(x3 = baseX + r) + 0.0, (double)baseY + 0.0, (double)(z2 = baseZ + dz) + 0.0), maxVerticalScan) != null) {
                            boolean bl = false;
                            if (INSTANCE.isSafeSpot(cand, hasNearbyGrave)) {
                                return cand;
                            }
                        }
                        if (dz == r) break;
                        ++dz;
                    }
                }
                if ((n = -r) <= (dx = r - 1)) {
                    while (true) {
                        if (this.adjustYToGround(new Location(world2, (double)(x = baseX + dx) + 0.0, (double)baseY + 0.0, (double)(z = baseZ + r) + 0.0), maxVerticalScan) != null) {
                            Location cand2;
                            boolean bl = false;
                            if (INSTANCE.isSafeSpot(cand2, hasNearbyGrave)) {
                                return cand2;
                            }
                        }
                        if (dx == n) break;
                        --dx;
                    }
                }
                if ((n = -r + 1) <= (dz = r - 1)) {
                    while (true) {
                        if (this.adjustYToGround(new Location(world2, (double)(x = baseX - r) + 0.0, (double)baseY + 0.0, (double)(z = baseZ + dz) + 0.0), maxVerticalScan) != null) {
                            Location cand3;
                            boolean bl = false;
                            if (INSTANCE.isSafeSpot(cand3, hasNearbyGrave)) {
                                return cand3;
                            }
                        }
                        if (dz == n) break;
                        --dz;
                    }
                }
                if (r == radius) break;
                ++r;
            }
        }
        return null;
    }

    @Nullable
    public final Location findSafeLocationNether(@NotNull Location base, int radius, @NotNull Function2<? super Location, ? super Integer, Boolean> hasNearbyGrave) {
        Location loc;
        Intrinsics.checkNotNullParameter(base, "base");
        Intrinsics.checkNotNullParameter(hasNearbyGrave, "hasNearbyGrave");
        World world = base.getWorld();
        if (world == null) {
            return null;
        }
        World world2 = world;
        int baseX = base.getBlockX();
        int baseY = base.getBlockY();
        int baseZ = base.getBlockZ();
        int y = baseY;
        int n = world2.getMinHeight();
        if (n <= y) {
            while (true) {
                if (this.isSafeSpotNether(loc = new Location(world2, (double)baseX, (double)y, (double)baseZ), hasNearbyGrave)) {
                    return loc;
                }
                if (y == n) break;
                --y;
            }
        }
        n = world2.getMaxHeight();
        for (y = baseY + 1; y < n; ++y) {
            loc = new Location(world2, (double)baseX, (double)y, (double)baseZ);
            if (!this.isSafeSpotNether(loc, hasNearbyGrave)) continue;
            return loc;
        }
        int r = 1;
        if (r <= radius) {
            while (true) {
                int dx;
                if ((dx = -r) <= r) {
                    while (true) {
                        int dz;
                        if ((dz = -r) <= r) {
                            while (true) {
                                if (dx == r || dx == -r || dz == r || dz == -r) {
                                    Location loc2;
                                    int x = baseX + dx;
                                    int z = baseZ + dz;
                                    int y2 = baseY;
                                    int n2 = world2.getMinHeight();
                                    if (n2 <= y2) {
                                        while (true) {
                                            if (this.isSafeSpotNether(loc2 = new Location(world2, (double)x, (double)y2, (double)z), hasNearbyGrave)) {
                                                return loc2;
                                            }
                                            if (y2 == n2) break;
                                            --y2;
                                        }
                                    }
                                    n2 = world2.getMaxHeight();
                                    for (y2 = baseY + 1; y2 < n2; ++y2) {
                                        loc2 = new Location(world2, (double)x, (double)y2, (double)z);
                                        if (!this.isSafeSpotNether(loc2, hasNearbyGrave)) continue;
                                        return loc2;
                                    }
                                }
                                if (dz == r) break;
                                ++dz;
                            }
                        }
                        if (dx == r) break;
                        ++dx;
                    }
                }
                if (r == radius) break;
                ++r;
            }
        }
        return null;
    }

    private final boolean isSafeSpotNether(Location target, Function2<? super Location, ? super Integer, Boolean> hasNearbyGrave) {
        Block block;
        block12: {
            block11: {
                Block below;
                block10: {
                    block9: {
                        World world = target.getWorld();
                        if (world == null) {
                            return false;
                        }
                        World world2 = world;
                        Block block2 = world2.getBlockAt(target);
                        Intrinsics.checkNotNullExpressionValue(block2, "getBlockAt(...)");
                        block = block2;
                        Block block3 = block.getRelative(0, -1, 0);
                        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
                        below = block3;
                        Block block4 = block.getRelative(0, 1, 0);
                        Intrinsics.checkNotNullExpressionValue(block4, "getRelative(...)");
                        Block above = block4;
                        Material material = block.getType();
                        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                        if (!this.isReplaceable(material)) break block9;
                        Material material2 = above.getType();
                        Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
                        if (this.isReplaceable(material2)) break block10;
                    }
                    return false;
                }
                Material material = below.getType();
                Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                if (!this.isSolidGround(material)) {
                    return false;
                }
                Material material3 = block.getType();
                Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
                if (this.isLavaOrLiquid(material3)) break block11;
                Material material4 = below.getType();
                Intrinsics.checkNotNullExpressionValue(material4, "getType(...)");
                if (!this.isLavaOrLiquid(material4)) break block12;
            }
            return false;
        }
        if (hasNearbyGrave.invoke((Location)target, (Integer)2).booleanValue()) {
            return false;
        }
        Block block5 = block.getRelative(0, -2, 0);
        Intrinsics.checkNotNullExpressionValue(block5, "getRelative(...)");
        Block below2 = block5;
        Material material = below2.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        return !this.isLavaOrLiquid(material);
    }

    private final Location adjustYToGround(Location loc, int maxVerticalScan) {
        Location candidate;
        int cy;
        World world = loc.getWorld();
        if (world == null) {
            return null;
        }
        World world2 = world;
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        int dy = 0;
        if (dy <= maxVerticalScan) {
            while ((cy = y - dy) >= world2.getMinHeight()) {
                candidate = new Location(world2, (double)x + 0.0, (double)cy + 0.0, (double)z + 0.0);
                if (this.isPlaceableOn(candidate)) {
                    return candidate;
                }
                if (dy == maxVerticalScan) break;
                ++dy;
            }
        }
        if ((dy = 1) <= maxVerticalScan) {
            while ((cy = y + dy) <= world2.getMaxHeight() - 1) {
                candidate = new Location(world2, (double)x + 0.0, (double)cy + 0.0, (double)z + 0.0);
                if (this.isPlaceableOn(candidate)) {
                    return candidate;
                }
                if (dy == maxVerticalScan) break;
                ++dy;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPlaceableOn(Location target) {
        World world = target.getWorld();
        if (world == null) {
            return false;
        }
        World world2 = world;
        Block block = world2.getBlockAt(target);
        Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
        Block block2 = block;
        Block block3 = block2.getRelative(0, -1, 0);
        Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
        Block below = block3;
        Material material = block2.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (!this.isReplaceable(material)) return false;
        Material material2 = below.getType();
        Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
        if (!this.isSolidGround(material2)) return false;
        Material material3 = block2.getType();
        Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
        if (this.isLavaOrLiquid(material3)) return false;
        Material material4 = below.getType();
        Intrinsics.checkNotNullExpressionValue(material4, "getType(...)");
        if (this.isLavaOrLiquid(material4)) return false;
        return true;
    }

    private final boolean isSafeSpot(Location target, Function2<? super Location, ? super Integer, Boolean> hasNearbyGrave) {
        block8: {
            block7: {
                World world = target.getWorld();
                if (world == null) {
                    return false;
                }
                World world2 = world;
                Block block = world2.getBlockAt(target);
                Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
                Block block2 = block;
                Block block3 = block2.getRelative(0, -1, 0);
                Intrinsics.checkNotNullExpressionValue(block3, "getRelative(...)");
                Block below = block3;
                Material material = block2.getType();
                Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                if (!this.isReplaceable(material)) {
                    return false;
                }
                Material material2 = below.getType();
                Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
                if (!this.isSolidGround(material2)) {
                    return false;
                }
                Material material3 = block2.getType();
                Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
                if (this.isLavaOrLiquid(material3)) break block7;
                Material material4 = below.getType();
                Intrinsics.checkNotNullExpressionValue(material4, "getType(...)");
                if (!this.isLavaOrLiquid(material4)) break block8;
            }
            return false;
        }
        if (this.hasSteepDrop(target, 2)) {
            return false;
        }
        return hasNearbyGrave.invoke((Location)target, (Integer)2) == false;
    }

    private final boolean isReplaceable(Material type2) {
        return type2.isAir() || !type2.isSolid() && type2 != Material.WATER && type2 != Material.LAVA;
    }

    private final boolean isSolidGround(Material type2) {
        if (type2.isAir()) {
            return false;
        }
        if (type2 == Material.LAVA || type2 == Material.WATER) {
            return false;
        }
        return type2.isSolid();
    }

    private final boolean isLavaOrLiquid(Material type2) {
        return type2 == Material.LAVA || type2 == Material.WATER;
    }

    private final boolean hasSteepDrop(Location target, int maxDrop) {
        World world = target.getWorld();
        if (world == null) {
            return true;
        }
        World world2 = world;
        int x = target.getBlockX();
        int z = target.getBlockZ();
        int depth = 0;
        int i = 1;
        int n = maxDrop + 1;
        if (i <= n) {
            int by;
            while ((by = target.getBlockY() - i) >= world2.getMinHeight()) {
                Block b;
                Intrinsics.checkNotNullExpressionValue(world2.getBlockAt(x, by, z), "getBlockAt(...)");
                if (b.getType().isSolid()) break;
                ++depth;
                if (i == n) break;
                ++i;
            }
        }
        return depth > maxDrop;
    }
}

