/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveDataStore;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "dataFile", "Ljava/io/File;", "saveAllGraves", "", "graves", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "loadAllGraves", "", "GraveDiggerX"})
public final class GraveDataStore {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final File dataFile;

    public GraveDataStore(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.dataFile = new File(this.plugin.getDataFolder(), "data.json");
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAllGraves(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        try {
            CopyOption[] copyOptionArray;
            JsonArray jsonArray = GraveSerializer.INSTANCE.encodeGraves(graves);
            String jsonText = GraveSerializer.INSTANCE.getGson().toJson((JsonElement)jsonArray);
            File tmpFile = new File(this.dataFile.getParentFile(), this.dataFile.getName() + ".tmp");
            Object object = tmpFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                writer.write(jsonText);
                writer.flush();
                copyOptionArray = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            try {
                Path source = tmpFile.toPath();
                Path target = this.dataFile.toPath();
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
                object = Files.move(source, target, copyOptionArray);
            }
            catch (Exception exception) {
                if (this.dataFile.exists()) {
                    this.dataFile.delete();
                }
                object = tmpFile.renameTo(this.dataFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final List<Grave> loadAllGraves() {
        List<Grave> list;
        try {
            if (!this.dataFile.exists()) {
                return CollectionsKt.emptyList();
            }
            String content = FilesKt.readText$default(this.dataFile, null, 1, null);
            if (((CharSequence)content).length() == 0) {
                return CollectionsKt.emptyList();
            }
            list = GraveSerializer.INSTANCE.decodeGravesFromString(content);
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

