/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.database;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.core.database.Column;
import pl.syntaxdevteam.core.database.DatabaseConfig;
import pl.syntaxdevteam.core.database.DatabaseManager;
import pl.syntaxdevteam.core.database.DatabaseType;
import pl.syntaxdevteam.core.database.TableSchema;
import pl.syntaxdevteam.core.logging.Logger;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.database.GraveRecord;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveDataStore;
import pl.syntaxdevteam.gravediggerx.graves.GraveSerializer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001DB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0014\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fJ\u0014\u0010 \u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0006\u0010!\u001a\u00020\"J\u0012\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0012\u0010'\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bH\u0002J\"\u0010.\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001f2\u0006\u0010/\u001a\u00020\u00132\b\b\u0002\u00100\u001a\u00020\"H\u0002J\u0014\u00101\u001a\u00020\"2\n\u00102\u001a\u000603j\u0002`4H\u0002J\u0010\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u000bH\u0002J\b\u00109\u001a\u00020\u000bH\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u000f2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010&\u001a\u00020\u000fH\u0002J\u0018\u0010=\u001a\u00020<2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020<H\u0002J\u0010\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020AH\u0002J\f\u0010B\u001a\u00020C*\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lpl/syntaxdevteam/gravediggerx/database/DatabaseHandler;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "logger", "Lpl/syntaxdevteam/core/logging/Logger;", "fileStore", "Lpl/syntaxdevteam/gravediggerx/graves/GraveDataStore;", "configuredType", "", "storageBackend", "Lpl/syntaxdevteam/gravediggerx/database/DatabaseHandler$StorageBackend;", "dbType", "Lpl/syntaxdevteam/core/database/DatabaseType;", "dbConfig", "Lpl/syntaxdevteam/core/database/DatabaseConfig;", "dbManager", "Lpl/syntaxdevteam/core/database/DatabaseManager;", "sqlOperational", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connect", "", "close", "ensureSchema", "replaceAllGraves", "graves", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "loadAllGraves", "", "writeGravesToJsonIfConfigured", "isJsonBackend", "", "ensureSqlReady", "logFailure", "resolveBackend", "type", "resolveDatabaseName", "configuredName", "resolveDatabaseFilePath", "baseName", "resolveH2DatabasePath", "name", "resolveSqliteDatabasePath", "loadAllGravesFromSql", "manager", "attemptRecovery", "isMissingTable", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createDirectoryIfMissing", "path", "Ljava/nio/file/Path;", "idDefinition", "payloadColumnType", "parseDatabaseType", "defaultPort", "", "resolvePort", "configuredPort", "locationKey", "location", "Lorg/bukkit/Location;", "toRecord", "Lpl/syntaxdevteam/gravediggerx/database/GraveRecord;", "StorageBackend", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nDatabaseHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/gravediggerx/database/DatabaseHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n1#2:382\n1#2:398\n1869#3,2:383\n1761#3,3:385\n1617#3,9:388\n1869#3:397\n1870#3:399\n1626#3:400\n*S KotlinDebug\n*F\n+ 1 DatabaseHandler.kt\npl/syntaxdevteam/gravediggerx/database/DatabaseHandler\n*L\n278#1:398\n128#1:383,2\n217#1:385,3\n278#1:388,9\n278#1:397\n278#1:399\n278#1:400\n*E\n"})
public final class DatabaseHandler {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final Logger logger;
    @NotNull
    private final GraveDataStore fileStore;
    @NotNull
    private final String configuredType;
    @NotNull
    private final StorageBackend storageBackend;
    @Nullable
    private final DatabaseType dbType;
    @Nullable
    private final DatabaseConfig dbConfig;
    @Nullable
    private final DatabaseManager dbManager;
    @NotNull
    private final AtomicBoolean sqlOperational;

    public DatabaseHandler(@NotNull GraveDiggerX plugin) {
        DatabaseManager databaseManager;
        DatabaseConfig databaseConfig;
        DatabaseConfig it;
        DatabaseHandler databaseHandler;
        String string;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
                this.plugin = plugin;
                this.logger = this.plugin.getLogger();
                this.fileStore = new GraveDataStore(this.plugin);
                string = this.plugin.getConfig().getString("database.type");
                if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) break block12;
                String string2 = string;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                string = string3;
                if (string3 != null) break block13;
            }
            string = "yaml";
        }
        this.configuredType = string;
        this.storageBackend = this.resolveBackend(this.configuredType);
        this.dbType = this.parseDatabaseType(this.configuredType);
        DatabaseHandler databaseHandler2 = this;
        if (this.storageBackend == StorageBackend.SQL) {
            DatabaseType databaseType = this.dbType;
            if (databaseType != null) {
                String string4;
                DatabaseType databaseType2 = databaseType;
                databaseHandler = databaseHandler2;
                boolean bl = false;
                String databaseName = this.resolveDatabaseName(this.plugin.getConfig().getString("database.sql.dbname"));
                String string5 = this.plugin.getConfig().getString("database.sql.host");
                if (string5 == null) {
                    string5 = "localhost";
                }
                int n = this.resolvePort((DatabaseType)it, this.plugin.getConfig().getInt("database.sql.port"));
                String string6 = this.plugin.getConfig().getString("database.sql.username");
                if (string6 == null) {
                    string6 = "root";
                }
                if ((string4 = this.plugin.getConfig().getString("database.sql.password")) == null) {
                    string4 = "";
                }
                databaseConfig = new DatabaseConfig((DatabaseType)it, string5, n, databaseName, string6, string4, this.resolveDatabaseFilePath((DatabaseType)it, databaseName));
                databaseHandler2 = databaseHandler;
            } else {
                databaseConfig = null;
            }
        } else {
            databaseConfig = null;
        }
        databaseHandler2.dbConfig = databaseConfig;
        DatabaseHandler databaseHandler3 = this;
        DatabaseConfig databaseConfig2 = this.dbConfig;
        if (databaseConfig2 != null) {
            it = databaseConfig2;
            databaseHandler = databaseHandler3;
            boolean bl = false;
            databaseManager = new DatabaseManager(it, this.logger);
            databaseHandler3 = databaseHandler;
        } else {
            databaseManager = null;
        }
        databaseHandler3.dbManager = databaseManager;
        this.sqlOperational = new AtomicBoolean(false);
    }

    public final void connect() {
        if (this.storageBackend != StorageBackend.SQL) {
            this.logger.debug("Using file-based storage backend (" + this.configuredType + "), SQL connection skipped.");
            return;
        }
        if (this.ensureSqlReady(false)) {
            String string;
            Object object = this.dbType;
            if (object != null && (object = object.name()) != null) {
                Object object2 = object;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                String string2 = ((String)object2).toLowerCase(locale);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string = null;
            }
            this.logger.debug("Using " + string + " database backend.");
        } else {
            this.logger.err("Failed to connect to database, continuing with file storage.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.storageBackend != StorageBackend.SQL) {
            this.sqlOperational.set(false);
            return;
        }
        try {
            DatabaseManager databaseManager = this.dbManager;
            if (databaseManager != null) {
                databaseManager.close();
            }
        }
        catch (Exception e) {
            this.logger.warning("Failed to close database connection: " + e.getMessage());
        }
        finally {
            this.sqlOperational.set(false);
        }
    }

    public final void ensureSchema() {
        if (this.storageBackend != StorageBackend.SQL) {
            return;
        }
        DatabaseManager databaseManager = this.dbManager;
        if (databaseManager == null) {
            return;
        }
        DatabaseManager manager = databaseManager;
        if (!DatabaseHandler.ensureSqlReady$default(this, false, 1, null)) {
            return;
        }
        Column[] columnArray = new Column[]{new Column("id", this.idDefinition()), new Column("graveKey", "VARCHAR(128) UNIQUE"), new Column("ownerId", "VARCHAR(36)"), new Column("ownerName", "VARCHAR(64)"), new Column("world", "VARCHAR(64)"), new Column("x", "DOUBLE"), new Column("y", "DOUBLE"), new Column("z", "DOUBLE"), new Column("yaw", "FLOAT"), new Column("pitch", "FLOAT"), new Column("createdAt", "BIGINT"), new Column("storedXp", "INT"), new Column("payload", this.payloadColumnType())};
        TableSchema schema = new TableSchema("graves", CollectionsKt.listOf(columnArray));
        try {
            manager.createTable(schema);
        }
        catch (Exception e) {
            this.sqlOperational.set(false);
            this.logger.err("Failed to create graves table, falling back to file storage. " + e.getMessage());
        }
    }

    public final void replaceAllGraves(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        if (this.storageBackend != StorageBackend.SQL) {
            this.fileStore.saveAllGraves(graves);
            return;
        }
        DatabaseManager databaseManager = this.dbManager;
        if (databaseManager == null) {
            return;
        }
        DatabaseManager manager = databaseManager;
        if (!DatabaseHandler.ensureSqlReady$default(this, false, 1, null)) {
            this.fileStore.saveAllGraves(graves);
            return;
        }
        try {
            manager.execute("DELETE FROM graves", new Object[0]);
            Iterable $this$forEach$iv = graves;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Grave grave = (Grave)element$iv;
                boolean bl = false;
                GraveRecord record = this.toRecord(grave);
                Object[] objectArray = new Object[]{record.getGraveKey(), record.getOwnerId(), record.getOwnerName(), record.getWorld(), record.getX(), record.getY(), record.getZ(), Float.valueOf(record.getYaw()), Float.valueOf(record.getPitch()), record.getCreatedAt(), record.getStoredXp(), record.getPayload()};
                manager.execute("INSERT INTO graves (\n    graveKey, ownerId, ownerName, world, x, y, z, yaw, pitch, createdAt, storedXp, payload\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", objectArray);
            }
        }
        catch (Exception e) {
            this.sqlOperational.set(false);
            this.logger.err("Failed to save graves in database, switching to file storage. " + e.getMessage());
            this.fileStore.saveAllGraves(graves);
        }
    }

    @NotNull
    public final List<Grave> loadAllGraves() {
        if (this.storageBackend != StorageBackend.SQL) {
            return this.fileStore.loadAllGraves();
        }
        DatabaseManager databaseManager = this.dbManager;
        if (databaseManager == null) {
            return this.fileStore.loadAllGraves();
        }
        DatabaseManager manager = databaseManager;
        if (!DatabaseHandler.ensureSqlReady$default(this, false, 1, null)) {
            return this.fileStore.loadAllGraves();
        }
        List<Grave> list = DatabaseHandler.loadAllGravesFromSql$default(this, manager, false, 2, null);
        if (list == null) {
            list = this.fileStore.loadAllGraves();
        }
        return list;
    }

    public final void writeGravesToJsonIfConfigured(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        if (this.isJsonBackend()) {
            this.fileStore.saveAllGraves(graves);
        } else {
            this.replaceAllGraves(graves);
        }
    }

    public final boolean isJsonBackend() {
        return Intrinsics.areEqual(this.configuredType, "json");
    }

    private final boolean ensureSqlReady(boolean logFailure) {
        boolean bl;
        if (this.storageBackend != StorageBackend.SQL) {
            return false;
        }
        DatabaseManager databaseManager = this.dbManager;
        if (databaseManager == null) {
            return false;
        }
        DatabaseManager manager = databaseManager;
        if (this.sqlOperational.get()) {
            return true;
        }
        try {
            manager.connect();
            this.sqlOperational.set(true);
            bl = true;
        }
        catch (Exception e) {
            if (logFailure) {
                this.logger.debug("Database connection attempt failed: " + e.getMessage());
            }
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean ensureSqlReady$default(DatabaseHandler databaseHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return databaseHandler.ensureSqlReady(bl);
    }

    /*
     * Unable to fully structure code
     */
    private final StorageBackend resolveBackend(String type) {
        block13: {
            var3_2 = type;
            v0 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue(v0, "ROOT");
            v1 = var3_2.toLowerCase(v0);
            Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
            var2_3 = v1;
            switch (var2_3.hashCode()) {
                case 839186932: {
                    if (!var2_3.equals("mariadb")) {
                        break;
                    }
                    ** GOTO lbl30
                }
                case -2105481388: {
                    if (!var2_3.equals("postgresql")) {
                        break;
                    }
                    ** GOTO lbl30
                }
                case -894935028: {
                    if (!var2_3.equals("sqlite")) {
                        break;
                    }
                    ** GOTO lbl30
                }
                case 104382626: {
                    if (!var2_3.equals("mysql")) {
                        break;
                    }
                    ** GOTO lbl30
                }
                case 3274: {
                    if (!var2_3.equals("h2")) {
                        break;
                    }
                    ** GOTO lbl30
                }
                case 757584761: {
                    if (!var2_3.equals("postgres")) break;
lbl30:
                    // 6 sources

                    v2 = StorageBackend.SQL;
                    break block13;
                }
            }
            v2 = StorageBackend.FILE;
        }
        return v2;
    }

    private final String resolveDatabaseName(String configuredName) {
        String string;
        block3: {
            block2: {
                String string2;
                string = configuredName;
                if (string == null) break block2;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank(it) ? string2 : null;
                if (string != null) break block3;
            }
            String string3 = this.plugin.getName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        }
        return string;
    }

    private final String resolveDatabaseFilePath(DatabaseType type2, String baseName) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> this.resolveSqliteDatabasePath(baseName);
            case 2 -> this.resolveH2DatabasePath(baseName);
            default -> null;
        };
    }

    private final String resolveH2DatabasePath(String name) {
        Path resolvedPath;
        block9: {
            Path path;
            Path $i$f$any2;
            boolean bl;
            String normalized;
            String trimmed;
            block8: {
                trimmed = ((Object)StringsKt.trim((CharSequence)name)).toString();
                normalized = StringsKt.replace$default(trimmed, "\\", "/", false, 4, null);
                String[] stringArray = new String[]{"mem:", "file:", "zip:", "ssl:", "tcp:"};
                List<String> specialPrefixes = CollectionsKt.listOf(stringArray);
                Iterable $this$any$iv = specialPrefixes;
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith(normalized, it, true)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return trimmed;
            }
            if (StringsKt.startsWith$default(normalized, "~/", false, 2, null) || StringsKt.startsWith$default(normalized, "./", false, 2, null) || StringsKt.startsWith$default(normalized, "/", false, 2, null)) {
                return trimmed;
            }
            try {
                $i$f$any2 = Path.of(trimmed, new String[0]);
            }
            catch (Exception exception) {
                $i$f$any2 = null;
            }
            Path path2 = path = $i$f$any2;
            boolean bl3 = path2 != null ? path2.isAbsolute() : false;
            if (bl3) {
                return ((Object)path).toString();
            }
            Path dataFolderPath = this.plugin.getDataFolder().toPath();
            Intrinsics.checkNotNull(dataFolderPath);
            this.createDirectoryIfMissing(dataFolderPath);
            Path databaseRoot = dataFolderPath.resolve("database");
            Intrinsics.checkNotNull(databaseRoot);
            this.createDirectoryIfMissing(databaseRoot);
            resolvedPath = databaseRoot.resolve(trimmed);
            Path path3 = resolvedPath.getParent();
            if (path3 == null) break block9;
            Path it = path3;
            boolean bl4 = false;
            this.createDirectoryIfMissing(it);
        }
        return ((Object)resolvedPath.toAbsolutePath()).toString();
    }

    private final String resolveSqliteDatabasePath(String name) {
        Path resolvedPath;
        block0: {
            String trimmed = StringsKt.removeSuffix(((Object)StringsKt.trim((CharSequence)name)).toString(), (CharSequence)".db");
            Path dataFolderPath = this.plugin.getDataFolder().toPath();
            Intrinsics.checkNotNull(dataFolderPath);
            this.createDirectoryIfMissing(dataFolderPath);
            Path databaseRoot = dataFolderPath.resolve("database");
            Intrinsics.checkNotNull(databaseRoot);
            this.createDirectoryIfMissing(databaseRoot);
            resolvedPath = databaseRoot.resolve(trimmed + ".db");
            Path path = resolvedPath.getParent();
            if (path == null) break block0;
            Path it = path;
            boolean bl = false;
            this.createDirectoryIfMissing(it);
        }
        return ((Object)resolvedPath.toAbsolutePath()).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Grave> loadAllGravesFromSql(DatabaseManager manager, boolean attemptRecovery) {
        List list;
        try {
            void $this$mapNotNullTo$iv$iv;
            List records = manager.query("SELECT * FROM graves ORDER BY createdAt ASC", new Object[0], DatabaseHandler::loadAllGravesFromSql$lambda$0);
            Iterable $this$mapNotNull$iv = records;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Grave it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                GraveRecord it = (GraveRecord)element$iv$iv;
                boolean bl2 = false;
                if (GraveSerializer.INSTANCE.decodeGraveFromString(it.getPayload()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            if (attemptRecovery && this.isMissingTable(e)) {
                this.logger.warning("Graves table missing, attempting to create schema before retrying load.");
                this.ensureSchema();
                return this.sqlOperational.get() ? this.loadAllGravesFromSql(manager, false) : null;
            }
            this.sqlOperational.set(false);
            this.logger.err("Failed to load graves from database, switching to file storage. " + e.getMessage());
            list = null;
        }
        return list;
    }

    static /* synthetic */ List loadAllGravesFromSql$default(DatabaseHandler databaseHandler, DatabaseManager databaseManager, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return databaseHandler.loadAllGravesFromSql(databaseManager, bl);
    }

    private final boolean isMissingTable(Exception exception) {
        String string;
        block8: {
            block7: {
                String sqlState;
                if (!(exception instanceof SQLException)) {
                    return false;
                }
                int errorCode = ((SQLException)exception).getErrorCode();
                String string2 = ((SQLException)exception).getSQLState();
                if (string2 != null) {
                    String string3 = string2;
                    Locale locale = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                    String string4 = string3.toUpperCase(locale);
                    v3 = string4;
                    Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                } else {
                    v3 = sqlState = null;
                }
                if (errorCode == 42104 || Intrinsics.areEqual(sqlState, "42S02")) {
                    return true;
                }
                string = exception.getMessage();
                if (string == null) break block7;
                String string5 = string;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
                String string6 = string5.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
                string = string6;
                if (string6 != null) break block8;
            }
            return false;
        }
        String message = string;
        return StringsKt.contains$default((CharSequence)message, "table \"graves\" not found", false, 2, null) || StringsKt.contains$default((CharSequence)message, "table 'graves' not found", false, 2, null);
    }

    private final void createDirectoryIfMissing(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException ignored) {
            this.logger.warning("Failed to create directory " + path.toAbsolutePath() + ": " + ignored.getMessage());
        }
    }

    private final String idDefinition() {
        DatabaseType databaseType = this.dbType;
        return switch (databaseType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()]) {
            case 1 -> "INTEGER PRIMARY KEY AUTOINCREMENT";
            case 3 -> "SERIAL PRIMARY KEY";
            case 4 -> "INT IDENTITY(1,1) PRIMARY KEY";
            case 2 -> "INT AUTO_INCREMENT PRIMARY KEY";
            default -> "INT AUTO_INCREMENT PRIMARY KEY";
        };
    }

    private final String payloadColumnType() {
        DatabaseType databaseType = this.dbType;
        return switch (databaseType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[databaseType.ordinal()]) {
            case 5, 6 -> "LONGTEXT";
            case 4 -> "NVARCHAR(MAX)";
            default -> "TEXT";
        };
    }

    private final DatabaseType parseDatabaseType(String type2) {
        String string = type2;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return switch (string2) {
            case "mysql" -> DatabaseType.MYSQL;
            case "mariadb" -> DatabaseType.MARIADB;
            case "postgresql", "postgres" -> DatabaseType.POSTGRESQL;
            case "sqlite" -> DatabaseType.SQLITE;
            case "h2" -> DatabaseType.H2;
            default -> null;
        };
    }

    private final int defaultPort(DatabaseType type2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 3 -> 5432;
            case 5, 6 -> 3306;
            case 4 -> 1433;
            default -> 0;
        };
    }

    private final int resolvePort(DatabaseType type2, int configuredPort) {
        Integer port;
        Integer n = configuredPort;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = port = it > 0 ? n : null;
        if (n2 != null) {
            return n2;
        }
        return this.defaultPort(type2);
    }

    private final String locationKey(Location location) {
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        Object worldName = object;
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return (String)worldName + ":" + x + ":" + y + ":" + z;
    }

    private final GraveRecord toRecord(Grave $this$toRecord) {
        Location location = $this$toRecord.getLocation();
        String string = this.locationKey(location);
        String string2 = $this$toRecord.getOwnerId().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String string3 = $this$toRecord.getOwnerName();
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "world";
        }
        return new GraveRecord(null, string, string2, string3, (String)object, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), $this$toRecord.getCreatedAt(), $this$toRecord.getStoredXp(), GraveSerializer.INSTANCE.encodeGraveToString($this$toRecord), 1, null);
    }

    private static final GraveRecord loadAllGravesFromSql$lambda$0(ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        Integer n = rs.getInt("id");
        String string = rs.getString("graveKey");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("ownerId");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = rs.getString("ownerName");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        String string4 = rs.getString("world");
        Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
        double d = rs.getDouble("x");
        double d2 = rs.getDouble("y");
        double d3 = rs.getDouble("z");
        float f = rs.getFloat("yaw");
        float f2 = rs.getFloat("pitch");
        long l = rs.getLong("createdAt");
        int n2 = rs.getInt("storedXp");
        String string5 = rs.getString("payload");
        Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
        return new GraveRecord(n, string, string2, string3, string4, d, d2, d3, f, f2, l, n2, string5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lpl/syntaxdevteam/gravediggerx/database/DatabaseHandler$StorageBackend;", "", "<init>", "(Ljava/lang/String;I)V", "FILE", "SQL", "GraveDiggerX"})
    private static final class StorageBackend
    extends Enum<StorageBackend> {
        public static final /* enum */ StorageBackend FILE = new StorageBackend();
        public static final /* enum */ StorageBackend SQL = new StorageBackend();
        private static final /* synthetic */ StorageBackend[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StorageBackend[] values() {
            return (StorageBackend[])$VALUES.clone();
        }

        public static StorageBackend valueOf(String value) {
            return Enum.valueOf(StorageBackend.class, value);
        }

        @NotNull
        public static EnumEntries<StorageBackend> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = storageBackendArray = new StorageBackend[]{StorageBackend.FILE, StorageBackend.SQL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.SQLITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.H2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.POSTGRESQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MSSQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MYSQL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MARIADB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

