/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.commands.admin;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveManager;
import pl.syntaxdevteam.gravediggerx.permissions.PermissionChecker;
import pl.syntaxdevteam.message.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/syntaxdevteam/gravediggerx/commands/admin/AdminRemoveCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nAdminRemoveCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminRemoveCommand.kt\npl/syntaxdevteam/gravediggerx/commands/admin/AdminRemoveCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1563#2:72\n1634#2,3:73\n774#2:76\n865#2,2:77\n1563#2:79\n1634#2,3:80\n774#2:83\n865#2,2:84\n*S KotlinDebug\n*F\n+ 1 AdminRemoveCommand.kt\npl/syntaxdevteam/gravediggerx/commands/admin/AdminRemoveCommand\n*L\n60#1:72\n60#1:73,3\n61#1:76\n61#1:77,2\n66#1:79\n66#1:80,3\n67#1:83\n67#1:84,2\n*E\n"})
public final class AdminRemoveCommand
implements BasicCommand {
    @NotNull
    private final GraveDiggerX plugin;

    public AdminRemoveCommand(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!PermissionChecker.INSTANCE.has(sender, PermissionChecker.PermissionKey.CMD_ADMIN)) {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-permission", null, (int)4, null);
            sender.sendMessage(message);
            return;
        }
        if (args.length < 4) {
            Component msg = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"unknown-command", null, (int)4, null);
            sender.sendMessage(msg);
            return;
        }
        String playerName = args[2];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        GraveManager graveManager = this.plugin.getGraveManager();
        UUID uUID = offlinePlayer2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Grave> graves = graveManager.getGravesFor(uUID);
        if (graves.isEmpty()) {
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("admin", "no-graves-for-player", MapsKt.mapOf(TuplesKt.to("player", playerName)));
            sender.sendMessage(msg);
            return;
        }
        String idArg = args[3];
        Integer index = StringsKt.toIntOrNull(idArg);
        if (index == null || index < 1 || index > graves.size()) {
            Component msg = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"invalid-id", null, (int)4, null);
            sender.sendMessage(msg);
            return;
        }
        Grave grave = graves.get(index - 1);
        boolean removed = this.plugin.getGraveManager().removeGraveAt(grave.getLocation());
        if (removed) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("id", String.valueOf(index))};
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("admin", "removed-grave", MapsKt.mapOf(pairArray));
            sender.sendMessage(msg);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to("player", playerName), TuplesKt.to("id", String.valueOf(index))};
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("admin", "could-not-remove-grave", MapsKt.mapOf(pairArray));
            sender.sendMessage(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 3) {
            void $this$filterTo$iv$iv;
            String it;
            Iterable $this$mapTo$iv$iv;
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[2], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (args.length == 4) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[2]);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            OfflinePlayer player = offlinePlayer;
            GraveManager graveManager = this.plugin.getGraveManager();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int size = graveManager.getGravesFor(uUID).size();
            Iterable $this$map$iv = new IntRange(1, size);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf((int)it));
            }
            List indices = (List)destination$iv$iv;
            Iterable $this$filter$iv = indices;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[3], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }
}

