/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.commands.admin.AdminRemoveCommand;
import pl.syntaxdevteam.gravediggerx.common.ReloadPlugin;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveManager;
import pl.syntaxdevteam.gravediggerx.permissions.PermissionChecker;
import pl.syntaxdevteam.message.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\b\b\u0001\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J#\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ#\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/gravediggerx/commands/GraveDiggerXCommands;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "sendHelpDesk", "sendReload", "sendList", "sendAdmin", "sendAdminList", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveDiggerXCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveDiggerXCommands.kt\npl/syntaxdevteam/gravediggerx/commands/GraveDiggerXCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n774#2:202\n865#2,2:203\n1563#2:205\n1634#2,3:206\n774#2:209\n865#2,2:210\n1563#2:212\n1634#2,3:213\n774#2:216\n865#2,2:217\n1563#2:219\n1634#2,3:220\n774#2:223\n865#2,2:224\n1869#2,2:226\n1878#2,3:228\n1878#2,3:231\n*S KotlinDebug\n*F\n+ 1 GraveDiggerXCommands.kt\npl/syntaxdevteam/gravediggerx/commands/GraveDiggerXCommands\n*L\n46#1:199\n46#1:200,2\n51#1:202\n51#1:203,2\n56#1:205\n56#1:206,3\n57#1:209\n57#1:210,2\n58#1:212\n58#1:213,3\n59#1:216\n59#1:217,2\n67#1:219\n67#1:220,3\n68#1:223\n68#1:224,2\n84#1:226,2\n128#1:228,3\n183#1:231,3\n*E\n"})
public final class GraveDiggerXCommands
implements BasicCommand {
    @NotNull
    private final GraveDiggerX plugin;

    public GraveDiggerXCommands(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (args.length == 0) {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"unknown-command", null, (int)4, null);
            sender.sendMessage(message);
            return;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "help": {
                this.sendHelpDesk(stack);
                break;
            }
            case "reload": {
                this.sendReload(stack);
                break;
            }
            case "list": {
                this.sendList(stack);
                break;
            }
            case "admin": {
                this.sendAdmin(stack, args);
                break;
            }
            default: {
                Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"unknown-command", null, (int)4, null);
                sender.sendMessage(message);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 0 || StringsKt.isBlank(args[0])) {
            String[] stringArray = new String[]{"help", "reload", "list", "admin"};
            return CollectionsKt.listOf(stringArray);
        }
        if (args.length == 1) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"help", "reload", "list", "admin"};
            Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[0], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (args.length == 2 && StringsKt.equals(args[0], "admin", true)) {
            void $this$filterTo$iv$iv;
            String[] $i$f$filter = new String[]{"list", "remove"};
            List<String> subcommands = CollectionsKt.listOf($i$f$filter);
            Iterable $this$filter$iv = subcommands;
            boolean $i$f$filter2 = false;
            Iterable destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[1], true)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            return (List)destination$iv$iv2;
        }
        if (args.length == 3 && StringsKt.equals(args[0], "admin", true)) {
            List list;
            if (StringsKt.equals(args[1], "list", true)) {
                void $this$filterTo$iv$iv;
                String it;
                Iterable $this$mapTo$iv$iv;
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable $i$f$filter2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Player element$iv$iv = (Player)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getName());
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith(it, args[2], true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else if (StringsKt.equals(args[1], "remove", true)) {
                Object it;
                Iterable $this$mapTo$iv$iv;
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable $this$filterTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Player)item$iv$iv;
                    Collection collection3 = destination$iv$iv;
                    boolean bl = false;
                    collection3.add(it.getName());
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)it, args[2], true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        if (args.length == 4 && StringsKt.equals(args[0], "admin", true) && StringsKt.equals(args[1], "remove", true)) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[2]);
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            OfflinePlayer player = offlinePlayer;
            GraveManager graveManager = this.plugin.getGraveManager();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int size = graveManager.getGravesFor(uUID).size();
            Iterable $this$map$iv = new IntRange(1, size);
            boolean $i$f$map = false;
            Iterable $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf((int)it));
            }
            List indices = (List)destination$iv$iv;
            Iterable $this$filter$iv = indices;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[3], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final void sendHelpDesk(CommandSourceStack stack) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!PermissionChecker.INSTANCE.has(sender, PermissionChecker.PermissionKey.CMD_HELP)) {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-permission", null, (int)4, null);
            sender.sendMessage(message);
            return;
        }
        List helpLines = this.plugin.getMessageHandler().getSmartMessage("help", "info", MapsKt.emptyMap());
        Iterable $this$forEach$iv = helpLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            sender.sendMessage(it);
        }
    }

    private final void sendReload(CommandSourceStack stack) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!PermissionChecker.INSTANCE.has(sender, PermissionChecker.PermissionKey.CMD_RELOAD)) {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-permission", null, (int)4, null);
            sender.sendMessage(message);
            return;
        }
        this.plugin.reloadConfig();
        new ReloadPlugin(this.plugin).reloadAll();
        this.plugin.getMessageHandler().reloadMessages();
        Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"reload", (String)"success", null, (int)4, null);
        sender.sendMessage(message);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendList(CommandSourceStack stack) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!(sender instanceof Player)) {
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("graves", "only-player", MapsKt.emptyMap());
            sender.sendMessage(msg);
            return;
        }
        if (!PermissionChecker.INSTANCE.has(sender, PermissionChecker.PermissionKey.CMD_LIST)) {
            Component msg = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-permission", null, (int)4, null);
            sender.sendMessage(msg);
            return;
        }
        GraveManager graveManager = this.plugin.getGraveManager();
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Grave> graves = graveManager.getGravesFor(uUID);
        if (graves.isEmpty()) {
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("graves", "no-graves", MapsKt.emptyMap());
            sender.sendMessage(msg);
            return;
        }
        Component header = this.plugin.getMessageHandler().stringMessageToComponent("graves", "locate-header", MapsKt.emptyMap());
        sender.sendMessage(header);
        Iterable $this$forEachIndexed$iv = graves;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void grave;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grave grave2 = (Grave)item$iv;
            int index = n;
            boolean bl = false;
            Location loc = grave.getLocation();
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to("index", String.valueOf(index + 1));
            Object object = loc.getWorld();
            if (object == null || (object = object.getName()) == null) {
                object = "unknown";
            }
            pairArray[1] = TuplesKt.to("world", object);
            pairArray[2] = TuplesKt.to("x", String.valueOf(loc.getBlockX()));
            pairArray[3] = TuplesKt.to("y", String.valueOf(loc.getBlockY()));
            pairArray[4] = TuplesKt.to("z", String.valueOf(loc.getBlockZ()));
            Map placeholders = MapsKt.mapOf(pairArray);
            Component line = this.plugin.getMessageHandler().stringMessageToComponent("graves", "locate-entry", placeholders);
            sender.sendMessage(line);
        }
    }

    private final void sendAdmin(CommandSourceStack stack, String[] args) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!PermissionChecker.INSTANCE.has(sender, PermissionChecker.PermissionKey.CMD_ADMIN)) {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-permission", null, (int)4, null);
            sender.sendMessage(message);
            return;
        }
        if (args.length < 3) {
            Component msg = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"unknown-command", null, (int)4, null);
            sender.sendMessage(msg);
            return;
        }
        String string = args[1].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual(string2, "list")) {
            this.sendAdminList(stack, args);
        } else if (Intrinsics.areEqual(string2, "remove")) {
            new AdminRemoveCommand(this.plugin).execute(stack, args);
        } else {
            Component message = MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"unknown-command", null, (int)4, null);
            sender.sendMessage(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendAdminList(CommandSourceStack stack, String[] args) {
        CommandSender commandSender = stack.getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String playerName = args[2];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer offlinePlayer2 = offlinePlayer;
        GraveManager graveManager = this.plugin.getGraveManager();
        UUID uUID = offlinePlayer2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Grave> graves = graveManager.getGravesFor(uUID);
        if (graves.isEmpty()) {
            Component msg = this.plugin.getMessageHandler().stringMessageToComponent("admin", "no-graves-for-player", MapsKt.mapOf(TuplesKt.to("player", playerName)));
            sender.sendMessage(msg);
            return;
        }
        Component header = this.plugin.getMessageHandler().stringMessageToComponent("admin", "list-header", MapsKt.mapOf(TuplesKt.to("player", playerName)));
        sender.sendMessage(header);
        Iterable $this$forEachIndexed$iv = graves;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void grave;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Grave grave2 = (Grave)item$iv;
            int index = n;
            boolean bl = false;
            Location loc = grave.getLocation();
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to("index", String.valueOf(index + 1));
            Object object = loc.getWorld();
            if (object == null || (object = object.getName()) == null) {
                object = "unknown";
            }
            pairArray[1] = TuplesKt.to("world", object);
            pairArray[2] = TuplesKt.to("x", String.valueOf(loc.getBlockX()));
            pairArray[3] = TuplesKt.to("y", String.valueOf(loc.getBlockY()));
            pairArray[4] = TuplesKt.to("z", String.valueOf(loc.getBlockZ()));
            Map placeholders = MapsKt.mapOf(pairArray);
            Component line = this.plugin.getMessageHandler().stringMessageToComponent("admin", "list-entry", placeholders);
            sender.sendMessage(line);
        }
    }
}

