/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "scheduledTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lorg/bukkit/scheduler/BukkitTask;", "scheduleRemoval", "", "grave", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "cancelRemoval", "cancelAll", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nTimeGraveRemove.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeGraveRemove.kt\npl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 TimeGraveRemove.kt\npl/syntaxdevteam/gravediggerx/graves/TimeGraveRemove\n*L\n75#1:80,2\n*E\n"})
public final class TimeGraveRemove {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final ConcurrentHashMap<UUID, BukkitTask> scheduledTasks;

    public TimeGraveRemove(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.scheduledTasks = new ConcurrentHashMap();
    }

    public final void scheduleRemoval(@NotNull Grave grave) {
        BukkitTask bukkitTask;
        Intrinsics.checkNotNullParameter(grave, "grave");
        int totalSeconds = this.plugin.getConfig().getInt("graves.grave-despawn", 60);
        Ref.IntRef secondsLeft = new Ref.IntRef();
        secondsLeft.element = totalSeconds;
        BukkitTask bukkitTask2 = this.scheduledTasks.get(grave.getOwnerId());
        if (bukkitTask2 != null) {
            bukkitTask2.cancel();
        }
        Ref.ObjectRef task = new Ref.ObjectRef();
        BukkitTask bukkitTask3 = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> TimeGraveRemove.scheduleRemoval$lambda$0(grave, this, task, secondsLeft), 0L, 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask3, "runTaskTimerAsynchronously(...)");
        task.element = bukkitTask3;
        Map map = this.scheduledTasks;
        UUID uUID = grave.getOwnerId();
        if (task.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("task");
            bukkitTask = null;
        } else {
            bukkitTask = (BukkitTask)task.element;
        }
        map.put(uUID, bukkitTask);
    }

    public final void cancelRemoval(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        BukkitTask bukkitTask = this.scheduledTasks.get(grave.getOwnerId());
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.scheduledTasks.remove(grave.getOwnerId());
    }

    public final void cancelAll() {
        Collection<BukkitTask> collection = this.scheduledTasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BukkitTask it = (BukkitTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.scheduledTasks.clear();
    }

    private static final void scheduleRemoval$lambda$0(Grave $grave, TimeGraveRemove this$0, Ref.ObjectRef $task, Ref.IntRef $secondsLeft) {
        Player player = Bukkit.getPlayer((UUID)$grave.getOwnerId());
        if (this$0.plugin.getGraveManager().getGraveAt($grave.getLocation()) == null) {
            BukkitTask bukkitTask;
            this$0.scheduledTasks.remove($grave.getOwnerId());
            if ($task.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException("task");
                bukkitTask = null;
            } else {
                bukkitTask = (BukkitTask)$task.element;
            }
            bukkitTask.cancel();
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> TimeGraveRemove.scheduleRemoval$lambda$0$0($grave, this$0, $task, player, $secondsLeft));
        if ($secondsLeft.element <= 0) {
            BukkitTask bukkitTask;
            Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> TimeGraveRemove.scheduleRemoval$lambda$0$1(this$0, $grave));
            this$0.scheduledTasks.remove($grave.getOwnerId());
            if ($task.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException("task");
                bukkitTask = null;
            } else {
                bukkitTask = (BukkitTask)$task.element;
            }
            bukkitTask.cancel();
            return;
        }
        int n = $secondsLeft.element;
        $secondsLeft.element = n + -1;
    }

    private static final void scheduleRemoval$lambda$0$0(Grave $grave, TimeGraveRemove this$0, Ref.ObjectRef $task, Player $player, Ref.IntRef $secondsLeft) {
        if ($grave.getLocation().getBlock().getType() != Material.PLAYER_HEAD) {
            BukkitTask bukkitTask;
            this$0.plugin.getGraveManager().removeGrave($grave);
            this$0.scheduledTasks.remove($grave.getOwnerId());
            if ($task.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException("task");
                bukkitTask = null;
            } else {
                bukkitTask = (BukkitTask)$task.element;
            }
            bukkitTask.cancel();
            return;
        }
        if ($player != null && $player.isOnline()) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("time", String.valueOf($secondsLeft.element)), TuplesKt.to("x", String.valueOf($grave.getLocation().getBlockX())), TuplesKt.to("y", String.valueOf($grave.getLocation().getBlockY())), TuplesKt.to("z", String.valueOf($grave.getLocation().getBlockZ()))};
            Component msg = this$0.plugin.getMessageHandler().stringMessageToComponent("graves", "removal-countdown", MapsKt.mapOf(pairArray));
            $player.sendActionBar(msg);
        }
    }

    private static final void scheduleRemoval$lambda$0$1(TimeGraveRemove this$0, Grave $grave) {
        this$0.plugin.getGhostManager().removeGhost($grave.getOwnerId());
        this$0.plugin.getGraveManager().removeGrave($grave);
    }
}

