/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.spirits.GhostManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u0006\u0010\u0019\u001a\u00020\u000eJ.\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e2\b\b\u0002\u0010!\u001a\u00020\u001fJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0#2\u0006\u0010$\u001a\u00020\u000bJ\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020'J\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010+\u001a\u00020\b2\u0006\u0010&\u001a\u00020'H\u0002J\"\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010$\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveManager;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "activeGraves", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "graveRemoveListeners", "Ljava/util/UUID;", "", "Lkotlin/Function0;", "", "pendingSaveTask", "Lorg/bukkit/scheduler/BukkitTask;", "saveDebounceTicks", "", "notifyGraveRemoved", "grave", "loadGravesFromStorage", "saveGravesToStorage", "requestSave", "performSaveAsync", "flushSavesSync", "createGraveAndGetIt", "player", "Lorg/bukkit/entity/Player;", "items", "", "", "Lorg/bukkit/inventory/ItemStack;", "xp", "getGravesFor", "", "ownerId", "createHologram", "location", "Lorg/bukkit/Location;", "ownerName", "getGraveAt", "removeGrave", "getKey", "applyPlayerProfile", "skull", "Lorg/bukkit/block/Skull;", "resolvePlayerProfile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "ModernProfileSupport", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1869#2,2:319\n1788#2,4:321\n774#2:325\n865#2,2:326\n295#2,2:328\n1869#2,2:330\n1869#2,2:333\n1#3:332\n*S KotlinDebug\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager\n*L\n23#1:319,2\n148#1:321,4\n201#1:325\n201#1:326,2\n234#1:328,2\n248#1:330,2\n101#1:333,2\n*E\n"})
public final class GraveManager {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final ConcurrentHashMap<String, Grave> activeGraves;
    @NotNull
    private final ConcurrentHashMap<UUID, List<Function0<Unit>>> graveRemoveListeners;
    @Nullable
    private volatile BukkitTask pendingSaveTask;
    private final long saveDebounceTicks;

    public GraveManager(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.activeGraves = new ConcurrentHashMap();
        this.graveRemoveListeners = new ConcurrentHashMap();
        this.saveDebounceTicks = 40L;
    }

    private final void notifyGraveRemoved(Grave grave) {
        List<Function0<Unit>> list = this.graveRemoveListeners.get(grave.getOwnerId());
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
        this.graveRemoveListeners.remove(grave.getOwnerId());
    }

    public final void loadGravesFromStorage() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof TextDisplay && ((TextDisplay)entity).getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "grave_hologram"), PersistentDataType.STRING)) {
                    ((TextDisplay)entity).remove();
                }
                if (!entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "grave_ghost"), PersistentDataType.STRING)) continue;
                entity.remove();
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0(this));
    }

    public final void saveGravesToStorage() {
        this.requestSave();
    }

    public final void requestSave() {
        BukkitTask bukkitTask = this.pendingSaveTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.pendingSaveTask = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> GraveManager.requestSave$lambda$0(this), this.saveDebounceTicks);
    }

    private final void performSaveAsync() {
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List snapshot = CollectionsKt.toList((Iterable)collection);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> GraveManager.performSaveAsync$lambda$0(this, snapshot));
    }

    public final void flushSavesSync() {
        BukkitTask bukkitTask = this.pendingSaveTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.pendingSaveTask = null;
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List snapshot = CollectionsKt.toList((Iterable)collection);
        this.plugin.getDatabaseHandler().writeGravesToJsonIfConfigured(snapshot);
    }

    @Nullable
    public final Grave createGraveAndGetIt(@NotNull Player player, @NotNull Map<Integer, ? extends ItemStack> items, int xp) {
        Skull skull;
        int playerGraves;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(items, "items");
        int maxGraves = this.plugin.getConfig().getInt("graves.max-per-player", 3);
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv2 : $this$count$iv) {
                Grave it = (Grave)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getOwnerId(), player.getUniqueId()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = playerGraves = count$iv;
        }
        if (playerGraves >= maxGraves) {
            Component message = this.plugin.getMessageHandler().stringMessageToComponent("graves", "reached-max-graves", MapsKt.mapOf(TuplesKt.to("limit", String.valueOf(maxGraves))));
            player.sendMessage(message);
            return null;
        }
        Location location = player.getLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location location2 = location;
        Block block = location2.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockData blockData = block2.getType() != Material.AIR ? block2.getBlockData().clone() : Bukkit.createBlockData((Material)Material.AIR);
        Intrinsics.checkNotNull(blockData);
        BlockData originalBlockData = blockData;
        block2.setType(Material.PLAYER_HEAD);
        element$iv2 = block2.getState();
        Skull skull2 = skull = element$iv2 instanceof Skull ? (Skull)element$iv2 : null;
        if (skull2 != null) {
            Object $this$createGraveAndGetIt_u24lambda_u241 = element$iv2 = skull2;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            this.applyPlayerProfile((Skull)$this$createGraveAndGetIt_u24lambda_u241, uUID, player.getName());
            $this$createGraveAndGetIt_u24lambda_u241.update(true, false);
        }
        String string = player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        List<UUID> hologramIds = this.createHologram(location2, string);
        GhostManager ghostManager = this.plugin.getGhostManager();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        String string2 = player.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        UUID ghostEntityId = ghostManager.createGhostAndGetId(uUID, location2, string2);
        Pair[] pairArray = new Pair[5];
        ItemStack itemStack = player.getInventory().getHelmet();
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        pairArray[0] = TuplesKt.to("helmet", itemStack.clone());
        ItemStack itemStack2 = player.getInventory().getChestplate();
        if (itemStack2 == null) {
            itemStack2 = new ItemStack(Material.AIR);
        }
        pairArray[1] = TuplesKt.to("chestplate", itemStack2.clone());
        ItemStack itemStack3 = player.getInventory().getLeggings();
        if (itemStack3 == null) {
            itemStack3 = new ItemStack(Material.AIR);
        }
        pairArray[2] = TuplesKt.to("leggings", itemStack3.clone());
        ItemStack itemStack4 = player.getInventory().getBoots();
        if (itemStack4 == null) {
            itemStack4 = new ItemStack(Material.AIR);
        }
        pairArray[3] = TuplesKt.to("boots", itemStack4.clone());
        ItemStack itemStack5 = player.getInventory().getItemInOffHand();
        if (itemStack5 == null) {
            itemStack5 = new ItemStack(Material.AIR);
        }
        pairArray[4] = TuplesKt.to("offhand", itemStack5.clone());
        Map armorContents = MapsKt.mapOf(pairArray);
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID uUID3 = uUID2;
        String string3 = player.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        String string4 = string3;
        Map<Integer, ? extends ItemStack> map = MapsKt.toMutableMap(items);
        long l = System.currentTimeMillis();
        boolean bl = ghostEntityId != null;
        Grave grave = new Grave(uUID3, string4, location2, map, armorContents, hologramIds, originalBlockData, xp, l, ghostEntityId, bl, null, 0);
        ((Map)this.activeGraves).put(this.getKey(location2), grave);
        this.plugin.getTimeGraveRemove().scheduleRemoval(grave);
        this.saveGravesToStorage();
        return grave;
    }

    public static /* synthetic */ Grave createGraveAndGetIt$default(GraveManager graveManager, Player player, Map map, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return graveManager.createGraveAndGetIt(player, map, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Grave> getGravesFor(@NotNull UUID ownerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ownerId, "ownerId");
        Collection<Grave> collection = this.activeGraves.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Grave it = (Grave)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getOwnerId(), ownerId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<UUID> createHologram(Location location, String ownerName) {
        Component text = this.plugin.getMessageHandler().stringMessageToComponentNoPrefix("graveh", "hologram", MapsKt.mapOf(TuplesKt.to("player", ownerName)));
        Location location2 = location.clone().add(0.5, 1.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        Location hologramLocation = location2;
        World world = hologramLocation.getWorld();
        if (world == null) {
            return CollectionsKt.emptyList();
        }
        World world2 = world;
        Entity entity = world2.spawn(hologramLocation, TextDisplay.class, arg_0 -> GraveManager.createHologram$lambda$1(arg_0 -> GraveManager.createHologram$lambda$0(text, this, ownerName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(entity, "spawn(...)");
        TextDisplay textDisplay = (TextDisplay)entity;
        return CollectionsKt.listOf(textDisplay.getUniqueId());
    }

    @Nullable
    public final Grave getGraveAt(@NotNull Location location) {
        Object v3;
        block2: {
            Intrinsics.checkNotNullParameter(location, "location");
            Object object = location.getWorld();
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            Object worldName = object;
            Integer[] integerArray = new Integer[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()};
            List<Integer> list = CollectionsKt.listOf(integerArray);
            int x = ((Number)list.get(0)).intValue();
            int y = ((Number)list.get(1)).intValue();
            int z = ((Number)list.get(2)).intValue();
            Collection<Grave> collection = this.activeGraves.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Grave it = (Grave)element$iv;
                boolean bl = false;
                Location loc = it.getLocation();
                World world = loc.getWorld();
                if (!(Intrinsics.areEqual(world != null ? world.getName() : null, worldName) && loc.getBlockX() == x && loc.getBlockY() == y && loc.getBlockZ() == z)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        return v3;
    }

    public final void removeGrave(@NotNull Grave grave) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        this.plugin.getTimeGraveRemove().cancelRemoval(grave);
        Location location = grave.getLocation().toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location location2 = location;
        Block block = location2.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        block2.setBlockData(grave.getOriginalBlockData());
        Iterable $this$forEach$iv = grave.getHologramIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)it);
            if (entity == null) continue;
            entity.remove();
        }
        UUID uUID = grave.getGhostEntityId();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)it);
            if (entity != null) {
                entity.remove();
            }
        }
        this.plugin.getGhostManager().removeGhost(grave.getOwnerId());
        this.activeGraves.remove(this.getKey(location2));
        this.notifyGraveRemoved(grave);
        this.saveGravesToStorage();
    }

    private final String getKey(Location location) {
        Object object = location.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        Object worldName = object;
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return (String)worldName + ":" + x + ":" + y + ":" + z;
    }

    private final void applyPlayerProfile(Skull skull, UUID ownerId, String ownerName) {
        PlayerProfile playerProfile = this.resolvePlayerProfile(ownerId, ownerName);
        if (playerProfile == null) {
            return;
        }
        PlayerProfile profile = playerProfile;
        if (ModernProfileSupport.INSTANCE.trySetProfile(skull, profile)) {
            return;
        }
        skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)ownerId));
    }

    private final PlayerProfile resolvePlayerProfile(UUID ownerId, String ownerName) {
        PlayerProfile playerProfile;
        try {
            PlayerProfile $this$resolvePlayerProfile_u24lambda_u240 = playerProfile = Bukkit.createProfile((UUID)ownerId, (String)ownerName);
            boolean bl = false;
            $this$resolvePlayerProfile_u24lambda_u240.complete();
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Failed to resolve player profile for grave owner " + ownerName + ": " + ex.getMessage());
            playerProfile = null;
        }
        return playerProfile;
    }

    private static final void loadGravesFromStorage$lambda$0(GraveManager this$0) {
        List<Grave> loadedGraves = this$0.plugin.getDatabaseHandler().loadAllGraves();
        if (loadedGraves.isEmpty()) {
            return;
        }
        Ref.IntRef restored = new Ref.IntRef();
        Ref.IntRef skipped = new Ref.IntRef();
        Bukkit.getScheduler().runTaskLater((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0(loadedGraves, this$0, skipped, restored), 40L);
    }

    private static final void loadGravesFromStorage$lambda$0$0(List $loadedGraves, GraveManager this$0, Ref.IntRef $skipped, Ref.IntRef $restored) {
        for (Grave grave : $loadedGraves) {
            World world;
            Location loc = grave.getLocation();
            if (loc.getWorld() == null) {
                GraveManager $this$loadGravesFromStorage_u24lambda_u240_u240_u240 = this$0;
                boolean bl = false;
                int n = $skipped.element;
                $skipped.element = n + 1;
                return;
            }
            world.getChunkAtAsync(loc).thenAccept(arg_0 -> GraveManager.loadGravesFromStorage$lambda$0$0$2(arg_0 -> GraveManager.loadGravesFromStorage$lambda$0$0$1(this$0, loc, grave, $restored, arg_0), arg_0));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this$0.plugin, GraveManager::loadGravesFromStorage$lambda$0$0$3, 100L);
    }

    private static final Unit loadGravesFromStorage$lambda$0$0$1(GraveManager this$0, Location $loc, Grave $grave, Ref.IntRef $restored, Chunk it) {
        Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0$1$0($loc, this$0, $grave, $restored));
        return Unit.INSTANCE;
    }

    private static final void loadGravesFromStorage$lambda$0$0$1$0(Location $loc, GraveManager this$0, Grave $grave, Ref.IntRef $restored) {
        Skull skull;
        Block block = $loc.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        block2.setType(Material.PLAYER_HEAD);
        BlockState blockState = block2.getState();
        Skull skull2 = skull = blockState instanceof Skull ? (Skull)blockState : null;
        if (skull2 != null) {
            BlockState $this$loadGravesFromStorage_u24lambda_u240_u240_u241_u240_u240 = blockState = skull2;
            boolean bl = false;
            this$0.applyPlayerProfile((Skull)$this$loadGravesFromStorage_u24lambda_u240_u240_u241_u240_u240, $grave.getOwnerId(), $grave.getOwnerName());
            $this$loadGravesFromStorage_u24lambda_u240_u240_u241_u240_u240.update(true, false);
        }
        List<UUID> hologramIds = this$0.createHologram($loc, $grave.getOwnerName());
        UUID ghostId = null;
        if ($grave.getGhostActive()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this$0.plugin, () -> GraveManager.loadGravesFromStorage$lambda$0$0$1$0$1(this$0, $grave, $loc), 40L);
        }
        Grave updated = Grave.copy$default($grave, null, null, null, null, null, hologramIds, null, 0, 0L, ghostId, $grave.getGhostActive(), null, 0, 6623, null);
        Iterable $this$forEach$iv = $grave.getHologramIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID oldId = (UUID)element$iv;
            boolean bl = false;
            Entity entity = Bukkit.getEntity((UUID)oldId);
            if (entity == null) continue;
            entity.remove();
        }
        Location location = $loc.toBlockLocation();
        Intrinsics.checkNotNullExpressionValue(location, "toBlockLocation(...)");
        Location blockLoc = location;
        ((Map)this$0.activeGraves).put(this$0.getKey(blockLoc), updated);
        this$0.plugin.getTimeGraveRemove().scheduleRemoval(updated);
        int n = $restored.element;
        $restored.element = n + 1;
    }

    private static final void loadGravesFromStorage$lambda$0$0$1$0$1(GraveManager this$0, Grave $grave, Location $loc) {
        Grave active;
        UUID newGhostId = this$0.plugin.getGhostManager().createGhostAndGetId($grave.getOwnerId(), $loc, $grave.getOwnerName());
        if (newGhostId != null && (active = this$0.activeGraves.get(this$0.getKey($loc))) != null) {
            Grave updated = Grave.copy$default(active, null, null, null, null, null, null, null, 0, 0L, newGhostId, true, null, 0, 6655, null);
            ((Map)this$0.activeGraves).put(this$0.getKey($loc), updated);
        }
    }

    private static final void loadGravesFromStorage$lambda$0$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void loadGravesFromStorage$lambda$0$0$3() {
    }

    private static final void requestSave$lambda$0(GraveManager this$0) {
        this$0.pendingSaveTask = null;
        this$0.performSaveAsync();
    }

    private static final void performSaveAsync$lambda$0(GraveManager this$0, List $snapshot) {
        this$0.plugin.getDatabaseHandler().writeGravesToJsonIfConfigured($snapshot);
    }

    private static final Unit createHologram$lambda$0(Component $text, GraveManager this$0, String $ownerName, TextDisplay display) {
        display.text($text);
        display.setBillboard(Display.Billboard.CENTER);
        display.setShadowed(false);
        display.setTextOpacity((byte)-1);
        display.setBackgroundColor(Color.fromARGB((int)120, (int)10, (int)10, (int)10));
        display.setBrightness(new Display.Brightness(15, 15));
        display.setSeeThrough(true);
        Transformation transformation = display.getTransformation();
        Intrinsics.checkNotNullExpressionValue(transformation, "getTransformation(...)");
        Transformation transform = transformation;
        transform.getScale().set((Vector3fc)new Vector3f(1.25f, 1.25f, 1.25f));
        display.setTransformation(transform);
        display.getPersistentDataContainer().set(new NamespacedKey((Plugin)this$0.plugin, "grave_hologram"), PersistentDataType.STRING, (Object)$ownerName);
        return Unit.INSTANCE;
    }

    private static final void createHologram$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveManager$ModernProfileSupport;", "", "<init>", "()V", "resolvableProfileClass", "Ljava/lang/Class;", "resolvableProfileFactory", "Ljava/lang/reflect/Method;", "skullSetProfileMethod", "trySetProfile", "", "skull", "Lorg/bukkit/block/Skull;", "profile", "Lcom/destroystokyo/paper/profile/PlayerProfile;", "GraveDiggerX"})
    @SourceDebugExtension(value={"SMAP\nGraveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveManager.kt\npl/syntaxdevteam/gravediggerx/graves/GraveManager$ModernProfileSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
    private static final class ModernProfileSupport {
        @NotNull
        public static final ModernProfileSupport INSTANCE;
        @Nullable
        private static final Class<?> resolvableProfileClass;
        @Nullable
        private static final Method resolvableProfileFactory;
        @Nullable
        private static final Method skullSetProfileMethod;

        private ModernProfileSupport() {
        }

        public final boolean trySetProfile(@NotNull Skull skull, @NotNull PlayerProfile profile) {
            boolean bl;
            Intrinsics.checkNotNullParameter(skull, "skull");
            Intrinsics.checkNotNullParameter(profile, "profile");
            Method method = resolvableProfileFactory;
            if (method == null) {
                return false;
            }
            Method factory = method;
            Method method2 = skullSetProfileMethod;
            if (method2 == null) {
                return false;
            }
            Method setter = method2;
            try {
                Object[] objectArray = new Object[]{profile};
                Object resolvable = factory.invoke(null, objectArray);
                objectArray = new Object[]{resolvable};
                setter.invoke((Object)skull, objectArray);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }

        static {
            Method method;
            Method method2;
            Class[] classArray;
            Object object;
            Class<?> it;
            Class<?> clazz;
            INSTANCE = new ModernProfileSupport();
            try {
                clazz = Class.forName("io.papermc.paper.datacomponent.item.ResolvableProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            resolvableProfileClass = clazz;
            Class<?> clazz2 = resolvableProfileClass;
            if (clazz2 != null) {
                Object $this$resolvableProfileFactory_u24lambda_u240_u240;
                it = clazz2;
                boolean bl = false;
                object = INSTANCE;
                try {
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = object;
                    boolean bl2 = false;
                    classArray = new Class[]{PlayerProfile.class};
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = Result.constructor-impl(it.getMethod("resolvableProfile", classArray));
                }
                catch (Throwable bl2) {
                    $this$resolvableProfileFactory_u24lambda_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object = $this$resolvableProfileFactory_u24lambda_u240_u240;
                method2 = (Method)(Result.isFailure-impl(object) ? null : object);
            } else {
                method2 = null;
            }
            resolvableProfileFactory = method2;
            Class<?> clazz3 = resolvableProfileClass;
            if (clazz3 != null) {
                Object object2;
                it = clazz3;
                boolean bl = false;
                object = INSTANCE;
                try {
                    Object $this$skullSetProfileMethod_u24lambda_u240_u240 = object;
                    boolean bl3 = false;
                    classArray = new Class[]{it};
                    object2 = Result.constructor-impl(Skull.class.getMethod("setProfile", classArray));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object = object2;
                method = (Method)(Result.isFailure-impl(object) ? null : object);
            } else {
                method = null;
            }
            skullSetProfileMethod = method;
        }
    }
}

