/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.listeners;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.GraveManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lpl/syntaxdevteam/gravediggerx/listeners/GraveProtectionListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onEntityExplode", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "onBlockExplode", "Lorg/bukkit/event/block/BlockExplodeEvent;", "onBlockFromTo", "Lorg/bukkit/event/block/BlockFromToEvent;", "onEntityChangeBlock", "Lorg/bukkit/event/entity/EntityChangeBlockEvent;", "onPistonExtend", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "onPistonRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "onBlockMove", "Lorg/bukkit/event/inventory/InventoryMoveItemEvent;", "onEntityDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onEntityDeath", "Lorg/bukkit/event/entity/EntityDeathEvent;", "isGhostSpirit", "", "entity", "Lorg/bukkit/entity/Entity;", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveProtectionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveProtectionListener.kt\npl/syntaxdevteam/gravediggerx/listeners/GraveProtectionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1761#2,3:104\n1761#2,3:107\n*S KotlinDebug\n*F\n+ 1 GraveProtectionListener.kt\npl/syntaxdevteam/gravediggerx/listeners/GraveProtectionListener\n*L\n60#1:104,3\n68#1:107,3\n*E\n"})
public final class GraveProtectionListener
implements Listener {
    @NotNull
    private final GraveDiggerX plugin;

    public GraveProtectionListener(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GraveManager graveManager = this.plugin.getGraveManager();
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (graveManager.getGraveAt(location) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onEntityExplode(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.plugin.getConfig().getBoolean("graves.protection.explosions", true)) {
            return;
        }
        event.blockList().removeIf(arg_0 -> GraveProtectionListener.onEntityExplode$lambda$1(arg_0 -> GraveProtectionListener.onEntityExplode$lambda$0(this, arg_0), arg_0));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockExplode(@NotNull BlockExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.plugin.getConfig().getBoolean("graves.protection.explosions", true)) {
            return;
        }
        event.blockList().removeIf(arg_0 -> GraveProtectionListener.onBlockExplode$lambda$1(arg_0 -> GraveProtectionListener.onBlockExplode$lambda$0(this, arg_0), arg_0));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockFromTo(@NotNull BlockFromToEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.plugin.getConfig().getBoolean("graves.protection.fluids", true)) {
            return;
        }
        GraveManager graveManager = this.plugin.getGraveManager();
        Location location = event.getToBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (graveManager.getGraveAt(location) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onEntityChangeBlock(@NotNull EntityChangeBlockEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.plugin.getConfig().getBoolean("graves.protection.mobs", true)) {
            return;
        }
        GraveManager graveManager = this.plugin.getGraveManager();
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (graveManager.getGraveAt(location) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPistonExtend(@NotNull BlockPistonExtendEvent event) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(event, "event");
            if (!this.plugin.getConfig().getBoolean("graves.protection.pistons", true)) {
                return;
            }
            List list = event.getBlocks();
            Intrinsics.checkNotNullExpressionValue(list, "getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    GraveManager graveManager = this.plugin.getGraveManager();
                    Location location = it.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                    if (!(graveManager.getGraveAt(location) != null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPistonRetract(@NotNull BlockPistonRetractEvent event) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(event, "event");
            if (!this.plugin.getConfig().getBoolean("graves.protection.pistons", true)) {
                return;
            }
            List list = event.getBlocks();
            Intrinsics.checkNotNullExpressionValue(list, "getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    GraveManager graveManager = this.plugin.getGraveManager();
                    Location location = it.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                    if (!(graveManager.getGraveAt(location) != null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockMove(@NotNull InventoryMoveItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.plugin.getConfig().getBoolean("graves.protection.hoppers", true)) {
            return;
        }
        Location location = event.getDestination().getLocation();
        if (location == null) {
            return;
        }
        Location destination = location;
        if (this.plugin.getGraveManager().getGraveAt(destination) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onEntityDamage(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        if (this.isGhostSpirit(entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onEntityDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(livingEntity, "getEntity(...)");
        if (this.isGhostSpirit((Entity)livingEntity)) {
            event.setCancelled(true);
        }
    }

    private final boolean isGhostSpirit(Entity entity) {
        return entity.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "ghost_spirit"), PersistentDataType.STRING);
    }

    private static final boolean onEntityExplode$lambda$0(GraveProtectionListener this$0, Block it) {
        GraveManager graveManager = this$0.plugin.getGraveManager();
        Location location = it.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return graveManager.getGraveAt(location) != null;
    }

    private static final boolean onEntityExplode$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onBlockExplode$lambda$0(GraveProtectionListener this$0, Block it) {
        GraveManager graveManager = this$0.plugin.getGraveManager();
        Location location = it.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return graveManager.getGraveAt(location) != null;
    }

    private static final boolean onBlockExplode$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

