/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.gui;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.permissions.PermissionChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/gravediggerx/gui/GraveGUI;", "Lorg/bukkit/event/Listener;", "grave", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/graves/Grave;Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "inventory", "Lorg/bukkit/inventory/Inventory;", "openedBy", "Lorg/bukkit/entity/Player;", "setupInventory", "", "createOwnerBanner", "Lorg/bukkit/inventory/ItemStack;", "createXpBanner", "createCollectButton", "open", "player", "onInventoryClick", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onInventoryClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "collectAll", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveGUI.kt\npl/syntaxdevteam/gravediggerx/gui/GraveGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1869#2,2:183\n1#3:185\n*S KotlinDebug\n*F\n+ 1 GraveGUI.kt\npl/syntaxdevteam/gravediggerx/gui/GraveGUI\n*L\n52#1:183,2\n*E\n"})
public final class GraveGUI
implements Listener {
    @NotNull
    private final Grave grave;
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final Inventory inventory;
    @Nullable
    private Player openedBy;

    public GraveGUI(@NotNull Grave grave, @NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter(grave, "grave");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.grave = grave;
        this.plugin = plugin;
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)this.plugin.getMessageHandler().getLogMessage("gui-grave", "title", MapsKt.emptyMap()));
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        this.inventory = inventory;
        this.setupInventory();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    private final void setupInventory() {
        for (Map.Entry<Integer, ItemStack> object2 : this.grave.getItems().entrySet()) {
            int slot = ((Number)object2.getKey()).intValue();
            ItemStack item = object2.getValue();
            boolean bl = 0 <= slot ? slot < 36 : false;
            if (!bl || slot >= this.inventory.getSize() - 9) continue;
            this.inventory.setItem(slot, item);
        }
        Integer[] integerArray = new Integer[]{45, 46, 47, 48, 49};
        List<Integer> armorSlots = CollectionsKt.listOf(integerArray);
        ItemStack[] slot = new ItemStack[]{this.grave.getArmorContents().get("helmet"), this.grave.getArmorContents().get("chestplate"), this.grave.getArmorContents().get("leggings"), this.grave.getArmorContents().get("boots"), this.grave.getArmorContents().get("offhand")};
        List<ItemStack> list = CollectionsKt.listOf(slot);
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)armorSlots, (Iterable)list);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int slot2 = ((Number)pair.component1()).intValue();
            ItemStack item = (ItemStack)pair.component2();
            if (item == null || item.getType() == Material.AIR) continue;
            this.inventory.setItem(slot2, item);
        }
        this.inventory.setItem(51, this.createOwnerBanner());
        this.inventory.setItem(52, this.createXpBanner());
        this.inventory.setItem(53, this.createCollectButton());
    }

    private final ItemStack createOwnerBanner() {
        CharSequence charSequence;
        ItemStack banner = new ItemStack(Material.WHITE_BANNER);
        ItemMeta meta = banner.getItemMeta();
        CharSequence charSequence2 = this.grave.getOwnerName();
        if (StringsKt.isBlank(charSequence2)) {
            boolean bl = false;
            charSequence = this.plugin.getMessageHandler().getCleanMessage("error", "unknown-player", MapsKt.emptyMap());
        } else {
            charSequence = charSequence2;
        }
        String ownerName = (String)charSequence;
        String message = this.plugin.getMessageHandler().getCleanMessage("gui-grave", "stats-owner", MapsKt.mapOf(TuplesKt.to("player", ownerName)));
        meta.displayName(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(message, null));
        banner.setItemMeta(meta);
        return banner;
    }

    private final ItemStack createXpBanner() {
        ItemStack banner = new ItemStack(Material.CYAN_BANNER);
        ItemMeta meta = banner.getItemMeta();
        String message = this.plugin.getMessageHandler().getCleanMessage("gui-grave", "stats-xp", MapsKt.mapOf(TuplesKt.to("xp", String.valueOf(this.grave.getStoredXp()))));
        meta.displayName(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(message, null));
        banner.setItemMeta(meta);
        return banner;
    }

    private final ItemStack createCollectButton() {
        ItemStack item = new ItemStack(Material.LIME_CANDLE);
        ItemMeta meta = item.getItemMeta();
        String displayName = this.plugin.getMessageHandler().getCleanMessage("gui-grave", "collect-item-name", MapsKt.emptyMap());
        List loreList = this.plugin.getMessageHandler().getSmartMessage("gui-grave", "collect-item-lore", MapsKt.emptyMap());
        meta.displayName(this.plugin.getMessageHandler().formatMixedTextToMiniMessage(displayName, null));
        meta.lore(loreList);
        item.setItemMeta(meta);
        return item;
    }

    public final void open(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!PermissionChecker.INSTANCE.has((CommandSender)player, PermissionChecker.PermissionKey.OPEN_GRAVE)) {
            Component msg = this.plugin.getMessageHandler().getMessage("error", "no-permission", MapsKt.emptyMap());
            player.sendMessage(msg);
            return;
        }
        this.openedBy = player;
        player.openInventory(this.inventory);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    @EventHandler
    public final void onInventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (!Intrinsics.areEqual(event.getView().getTopInventory(), this.inventory)) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == 53) {
            this.collectAll(player2);
            player2.closeInventory();
        }
    }

    @EventHandler
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getInventory(), this.inventory)) {
            return;
        }
        this.openedBy = null;
    }

    private final void collectAll(Player player) {
        if (!Intrinsics.areEqual(player.getUniqueId(), this.grave.getOwnerId())) {
            Location location = this.grave.getLocation().clone().add(0.5, 0.5, 0.5);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location loc = location;
            World world = loc.getWorld();
            if (world == null) {
                return;
            }
            World world2 = world;
            Component notYourGraveMsg = this.plugin.getMessageHandler().getMessage("graves", "not-your-grave", MapsKt.emptyMap());
            player.sendMessage(notYourGraveMsg);
            world2.spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 20, 0.2, 0.2, 0.2, 0.05);
            world2.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.5f);
            player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_HURT, 1.0f, 0.5f);
            player.closeInventory();
            return;
        }
        block7: for (Map.Entry<Integer, ItemStack> entry : this.grave.getItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            switch (slot) {
                case 36: {
                    player.getInventory().setHelmet(item);
                    continue block7;
                }
                case 37: {
                    player.getInventory().setChestplate(item);
                    continue block7;
                }
                case 38: {
                    player.getInventory().setLeggings(item);
                    continue block7;
                }
                case 39: {
                    player.getInventory().setBoots(item);
                    continue block7;
                }
                case 40: {
                    player.getInventory().setItemInOffHand(item);
                    continue block7;
                }
            }
            boolean bl = 0 <= slot ? slot < 36 : false;
            if (!bl) continue;
            player.getInventory().setItem(slot, item);
        }
        ItemStack itemStack = this.grave.getArmorContents().get("helmet");
        if (itemStack != null) {
            ItemStack it = itemStack;
            boolean bl = false;
            if (it.getType() != Material.AIR) {
                player.getInventory().setHelmet(it);
            }
        }
        ItemStack itemStack2 = this.grave.getArmorContents().get("chestplate");
        if (itemStack2 != null) {
            ItemStack it = itemStack2;
            boolean bl = false;
            if (it.getType() != Material.AIR) {
                player.getInventory().setChestplate(it);
            }
        }
        ItemStack itemStack3 = this.grave.getArmorContents().get("leggings");
        if (itemStack3 != null) {
            ItemStack it = itemStack3;
            boolean bl = false;
            if (it.getType() != Material.AIR) {
                player.getInventory().setLeggings(it);
            }
        }
        ItemStack itemStack4 = this.grave.getArmorContents().get("boots");
        if (itemStack4 != null) {
            ItemStack it = itemStack4;
            boolean bl = false;
            if (it.getType() != Material.AIR) {
                player.getInventory().setBoots(it);
            }
        }
        ItemStack itemStack5 = this.grave.getArmorContents().get("offhand");
        if (itemStack5 != null) {
            ItemStack it = itemStack5;
            boolean bl = false;
            if (it.getType() != Material.AIR) {
                player.getInventory().setItemInOffHand(it);
            }
        }
        if (this.grave.getStoredXp() > 0) {
            player.giveExp(this.grave.getStoredXp());
        }
        Location location = this.grave.getLocation().clone().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location loc = location;
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        World world3 = world;
        world3.spawnParticle(Particle.SOUL, loc, 30, 0.3, 0.3, 0.3, 0.02);
        world3.playSound(loc, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.3f);
        world3.playSound(loc, Sound.BLOCK_SOUL_SAND_BREAK, 0.7f, 0.9f);
        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        Component successMsg = this.plugin.getMessageHandler().getMessage("graves", "collected", MapsKt.mapOf(TuplesKt.to("player", player.getName())));
        player.sendMessage(successMsg);
        this.plugin.getGhostManager().removeGhost(this.grave.getOwnerId());
        this.plugin.getGraveManager().removeGrave(this.grave);
    }
}

