/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveDataStore;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "dataFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "saveAllGraves", "", "graves", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "loadAllGraves", "", "serializeItemStack", "Lcom/google/gson/JsonObject;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "deserializeItemFromJson", "json", "deserializeItemLegacyBase64", "data", "", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveDataStore.kt\npl/syntaxdevteam/gravediggerx/graves/GraveDataStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class GraveDataStore {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final File dataFile;
    @NotNull
    private final Gson gson;

    public GraveDataStore(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.dataFile = new File(this.plugin.getDataFolder(), "data.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAllGraves(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        try {
            Comparable comparable;
            CopyOption[] copyOptionArray;
            Object locationJson;
            Object graveJson;
            JsonArray jsonArray = new JsonArray();
            for (Grave grave : graves) {
                graveJson = new JsonObject();
                graveJson.addProperty("ownerId", grave.getOwnerId().toString());
                graveJson.addProperty("ownerName", grave.getOwnerName());
                locationJson = new JsonObject();
                Object object = grave.getLocation().getWorld();
                if (object == null || (object = object.getName()) == null) {
                    object = "world";
                }
                locationJson.addProperty("world", (String)object);
                locationJson.addProperty("x", (Number)grave.getLocation().getX());
                locationJson.addProperty("y", (Number)grave.getLocation().getY());
                locationJson.addProperty("z", (Number)grave.getLocation().getZ());
                locationJson.addProperty("yaw", (Number)Float.valueOf(grave.getLocation().getYaw()));
                locationJson.addProperty("pitch", (Number)Float.valueOf(grave.getLocation().getPitch()));
                graveJson.add("location", (JsonElement)locationJson);
                JsonArray itemsArray = new JsonArray();
                for (Map.Entry entry : grave.getItems().entrySet()) {
                    int slot = ((Number)entry.getKey()).intValue();
                    ItemStack itemStack = (ItemStack)entry.getValue();
                    JsonObject itemJson = new JsonObject();
                    itemJson.addProperty("slot", (Number)slot);
                    JsonObject serialized = this.serializeItemStack(itemStack);
                    itemJson.add("item", (JsonElement)serialized);
                    itemsArray.add((JsonElement)itemJson);
                }
                graveJson.add("items", (JsonElement)itemsArray);
                graveJson.addProperty("originalBlockData", grave.getOriginalBlockData().getAsString());
                graveJson.addProperty("storedXp", (Number)grave.getStoredXp());
                graveJson.addProperty("createdAt", (Number)grave.getCreatedAt());
                UUID uUID = grave.getGhostEntityId();
                graveJson.addProperty("ghostEntityId", uUID != null ? uUID.toString() : null);
                graveJson.addProperty("ghostActive", Boolean.valueOf(grave.getGhostActive()));
                UUID uUID2 = grave.getLastAttackerId();
                graveJson.addProperty("lastAttackerId", uUID2 != null ? uUID2.toString() : null);
                graveJson.addProperty("itemsStolen", (Number)grave.getItemsStolen());
                jsonArray.add((JsonElement)graveJson);
            }
            String jsonText = this.gson.toJson((JsonElement)jsonArray);
            File tmpFile = new File(this.dataFile.getParentFile(), this.dataFile.getName() + ".tmp");
            graveJson = tmpFile;
            locationJson = Charsets.UTF_8;
            int itemsArray = 8192;
            Object object = graveJson;
            graveJson = (object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)locationJson)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, itemsArray);
            locationJson = null;
            try {
                BufferedWriter writer = (BufferedWriter)graveJson;
                boolean bl = false;
                writer.write(jsonText);
                writer.flush();
                copyOptionArray = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                locationJson = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)graveJson, (Throwable)locationJson);
            }
            try {
                Path source = tmpFile.toPath();
                Path target = this.dataFile.toPath();
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
                comparable = Files.move(source, target, copyOptionArray);
            }
            catch (Exception exception) {
                if (this.dataFile.exists()) {
                    this.dataFile.delete();
                }
                comparable = Boolean.valueOf(tmpFile.renameTo(this.dataFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final List<Grave> loadAllGraves() {
        try {
            if (!this.dataFile.exists()) {
                return CollectionsKt.emptyList();
            }
            content = FilesKt.readText$default(this.dataFile, null, 1, null);
            if (((CharSequence)content).length() == 0) {
                return CollectionsKt.emptyList();
            }
            jsonArray = JsonParser.parseString((String)content).getAsJsonArray();
            graves = new ArrayList<E>();
            v0 = jsonArray.iterator();
            Intrinsics.checkNotNullExpressionValue(v0, "iterator(...)");
            var4_5 = v0;
            while (var4_5.hasNext()) {
                element = (JsonElement)var4_5.next();
                try {
                    obj = element.getAsJsonObject();
                    locObj = obj.getAsJsonObject("location");
                    v1 = Bukkit.getWorld((String)locObj.get("world").getAsString());
                    if (v1 == null) {
                        v1 = Bukkit.getWorld((String)"world");
                    }
                    world = v1;
                    location = new Location(world, locObj.get("x").getAsDouble(), locObj.get("y").getAsDouble(), locObj.get("z").getAsDouble(), locObj.get("yaw").getAsFloat(), locObj.get("pitch").getAsFloat());
                    items = new LinkedHashMap<K, V>();
                    itemsArray = obj.getAsJsonArray("items");
                    Intrinsics.checkNotNullExpressionValue(itemsArray.iterator(), "iterator(...)");
                    while (var12_14.hasNext()) {
                        itemElement = (JsonElement)var12_14.next();
                        itemObj = itemElement.getAsJsonObject();
                        slot = itemObj.get("slot").getAsInt();
                        if (itemObj.has("item") && itemObj.get("item").isJsonObject()) {
                            v2 = itemObj.getAsJsonObject("item");
                            Intrinsics.checkNotNullExpressionValue(v2, "getAsJsonObject(...)");
                            v3 = this.deserializeItemFromJson(v2);
                        } else if (itemObj.has("data") && itemObj.get("data").isJsonPrimitive()) {
                            v4 = itemObj.get("data").getAsString();
                            Intrinsics.checkNotNullExpressionValue(v4, "getAsString(...)");
                            v3 = this.deserializeItemLegacyBase64(v4);
                        } else {
                            v3 = new ItemStack(Material.AIR);
                        }
                        itemStack = v3;
                        items.put(slot, itemStack);
                    }
                    try {
                        var14_16 = Bukkit.createBlockData((String)obj.get("originalBlockData").getAsString());
                    }
                    catch (Exception e) {
                        var14_16 = Bukkit.createBlockData((Material)Material.STONE);
                    }
                    itemElement = var14_16;
                    Intrinsics.checkNotNull(itemElement);
                    blockData = itemElement;
                    v5 = UUID.fromString(obj.get("ownerId").getAsString());
                    v6 = v5;
                    Intrinsics.checkNotNullExpressionValue(v5, "fromString(...)");
                    v7 = obj.get("ownerName").getAsString();
                    v8 = v7;
                    Intrinsics.checkNotNullExpressionValue(v7, "getAsString(...)");
                    v9 = location;
                    v10 = items;
                    v11 = null;
                    v12 = CollectionsKt.emptyList();
                    v13 = blockData;
                    v14 = obj.get("storedXp");
                    v15 = v14 != null ? v14.getAsInt() : 0;
                    v16 = obj.get("createdAt");
                    v17 = v16 != null ? v16.getAsLong() : System.currentTimeMillis();
                    v18 /* !! */  = obj.get("ghostEntityId");
                    if (v18 /* !! */  == null) ** GOTO lbl-1000
                    var17_20 = var16_19 = v18 /* !! */ ;
                    var28_34 = v17;
                    var27_33 = v15;
                    var26_32 = v13;
                    var25_31 = v12;
                    var24_30 = v11;
                    var23_29 = v10;
                    var22_28 = v9;
                    var21_27 = v8;
                    var20_26 = v6;
                    $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$1 = false;
                    var30_35 = it.isJsonNull() == false;
                    v6 = var20_26;
                    v8 = var21_27;
                    v9 = var22_28;
                    v10 = var23_29;
                    v11 = var24_30;
                    v12 = var25_31;
                    v13 = var26_32;
                    v15 = var27_33;
                    v17 = var28_34;
                    v18 /* !! */  = var30_35 != false ? var16_19 : null;
                    if (v18 /* !! */  != null && (v18 /* !! */  = v18 /* !! */ .getAsString()) != null) {
                        $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$1 /* !! */  = v18 /* !! */ ;
                        var28_34 = v17;
                        var27_33 = v15;
                        var26_32 = v13;
                        var25_31 = v12;
                        var24_30 = v11;
                        var23_29 = v10;
                        var22_28 = v9;
                        var21_27 = v8;
                        var20_26 = v6;
                        $i$a$-let-GraveDataStore$loadAllGraves$grave$2 = false;
                        var30_36 = UUID.fromString((String)it);
                        v6 = var20_26;
                        v8 = var21_27;
                        v9 = var22_28;
                        v10 = var23_29;
                        v11 = var24_30;
                        v12 = var25_31;
                        v13 = var26_32;
                        v15 = var27_33;
                        v17 = var28_34;
                        v19 = var30_36;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v19 = null;
                    }
                    v20 = obj.get("ghostActive");
                    v21 = v20 != null ? v20.getAsBoolean() : false;
                    v22 /* !! */  = obj.get("lastAttackerId");
                    if (v22 /* !! */  == null) ** GOTO lbl-1000
                    it = var16_19 = v22 /* !! */ ;
                    var31_38 = v21;
                    var30_37 = v19;
                    var28_34 = v17;
                    var27_33 = v15;
                    var26_32 = v13;
                    var25_31 = v12;
                    var24_30 = v11;
                    var23_29 = v10;
                    var22_28 = v9;
                    var21_27 = v8;
                    var20_26 = v6;
                    $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$3 = false;
                    var32_39 = it.isJsonNull() == false;
                    v6 = var20_26;
                    v8 = var21_27;
                    v9 = var22_28;
                    v10 = var23_29;
                    v11 = var24_30;
                    v12 = var25_31;
                    v13 = var26_32;
                    v15 = var27_33;
                    v17 = var28_34;
                    v19 = var30_37;
                    v21 = var31_38;
                    v22 /* !! */  = var32_39 != false ? var16_19 : null;
                    if (v22 /* !! */  != null && (v22 /* !! */  = v22 /* !! */ .getAsString()) != null) {
                        $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$3 /* !! */  = v22 /* !! */ ;
                        var31_38 = v21;
                        var30_37 = v19;
                        var28_34 = v17;
                        var27_33 = v15;
                        var26_32 = v13;
                        var25_31 = v12;
                        var24_30 = v11;
                        var23_29 = v10;
                        var22_28 = v9;
                        var21_27 = v8;
                        var20_26 = v6;
                        $i$a$-let-GraveDataStore$loadAllGraves$grave$4 = false;
                        var32_40 = UUID.fromString((String)it);
                        v6 = var20_26;
                        v8 = var21_27;
                        v9 = var22_28;
                        v10 = var23_29;
                        v11 = var24_30;
                        v12 = var25_31;
                        v13 = var26_32;
                        v15 = var27_33;
                        v17 = var28_34;
                        v19 = var30_37;
                        v21 = var31_38;
                        v23 = var32_40;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v23 = null;
                    }
                    v24 = obj.get("itemsStolen");
                    var33_41 = null;
                    var34_42 = 16;
                    var35_43 = v24 != null ? v24.getAsInt() : 0;
                    var36_44 = v23;
                    var37_45 = v21;
                    var38_46 = v19;
                    var39_47 = v17;
                    var41_48 = v15;
                    var42_49 = v13;
                    var43_50 = v12;
                    var44_51 = v11;
                    var45_52 = v10;
                    var46_53 = v9;
                    var47_54 = v8;
                    var48_55 = v6;
                    grave = new Grave(var48_55, var47_54, var46_53, var45_52, var44_51, var43_50, (BlockData)var42_49, var41_48, var39_47, var38_46, var37_45, var36_44, var35_43, var34_42, var33_41);
                    graves.add(grave);
                }
                catch (Exception var7_9) {}
            }
            var1_1 = var3_4;
        }
        catch (Exception e) {
            var1_1 = CollectionsKt.emptyList();
        }
        return var1_1;
    }

    private final JsonObject serializeItemStack(ItemStack itemStack) {
        JsonObject jsonObject;
        try {
            Map map = itemStack.serialize();
            Intrinsics.checkNotNullExpressionValue(map, "serialize(...)");
            Map map2 = map;
            jsonObject = this.gson.toJsonTree((Object)map2).getAsJsonObject();
            Intrinsics.checkNotNull(jsonObject);
        }
        catch (Exception e) {
            jsonObject = new JsonObject();
        }
        return jsonObject;
    }

    private final ItemStack deserializeItemFromJson(JsonObject json) {
        ItemStack itemStack;
        try {
            Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            Object object = this.gson.fromJson((JsonElement)json, type2);
            Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
            Map map = (Map)object;
            itemStack = ItemStack.deserialize((Map)map);
            Intrinsics.checkNotNull(itemStack);
        }
        catch (Exception e) {
            itemStack = new ItemStack(Material.AIR);
        }
        return itemStack;
    }

    private final ItemStack deserializeItemLegacyBase64(String data) {
        ItemStack itemStack;
        try {
            if (((CharSequence)data).length() == 0) {
                return new ItemStack(Material.AIR);
            }
            byte[] decoded = Base64.getDecoder().decode(data);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
            Class<?> cls = Class.forName("org.bukkit.util.io.BukkitObjectInputStream");
            Class[] classArray = new Class[]{InputStream.class};
            Constructor<?> ctor = cls.getConstructor(classArray);
            Object object = new Object[]{inputStream};
            Object obj = ctor.newInstance(object);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type java.io.ObjectInputStream");
            ObjectInputStream dataInput = (ObjectInputStream)obj;
            object = dataInput.readObject();
            ItemStack itemStack2 = object instanceof ItemStack ? (ItemStack)object : null;
            dataInput.close();
            ItemStack itemStack3 = itemStack2;
            if (itemStack3 == null) {
                itemStack3 = new ItemStack(Material.AIR);
            }
            itemStack = itemStack3;
        }
        catch (Exception e) {
            itemStack = new ItemStack(Material.AIR);
        }
        return itemStack;
    }
}

