/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.effects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lpl/syntaxdevteam/gravediggerx/effects/MovementTracker;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "history", "", "Ljava/util/UUID;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lpl/syntaxdevteam/gravediggerx/effects/MovementTracker$TimedPoint;", "windowMs", "", "minDistanceSq", "", "onMove", "", "e", "Lorg/bukkit/event/player/PlayerMoveEvent;", "trimOld", "q", "getRecentPath", "", "Lorg/bukkit/Location;", "playerId", "seconds", "", "clear", "TimedPoint", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nMovementTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovementTracker.kt\npl/syntaxdevteam/gravediggerx/effects/MovementTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n1563#2:73\n1634#2,3:74\n*S KotlinDebug\n*F\n+ 1 MovementTracker.kt\npl/syntaxdevteam/gravediggerx/effects/MovementTracker\n*L\n62#1:70\n62#1:71,2\n62#1:73\n62#1:74,3\n*E\n"})
public final class MovementTracker
implements Listener {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final Map<UUID, ConcurrentLinkedDeque<TimedPoint>> history;
    private final long windowMs;
    private final double minDistanceSq;

    public MovementTracker(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.history = new ConcurrentHashMap();
        this.windowMs = 5000L;
        this.minDistanceSq = 0.05;
    }

    @EventHandler
    public final void onMove(@NotNull PlayerMoveEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Location location = e.getFrom();
        Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
        Location from = location;
        Location location2 = e.getTo();
        if (location2 == null) {
            return;
        }
        Location to = location2;
        if (!Intrinsics.areEqual(from.getWorld(), to.getWorld())) {
            return;
        }
        if (from.distanceSquared(to) < this.minDistanceSq) {
            return;
        }
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player p = player;
        ConcurrentLinkedDeque concurrentLinkedDeque = this.history.computeIfAbsent(p.getUniqueId(), arg_0 -> MovementTracker.onMove$lambda$1(MovementTracker::onMove$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentLinkedDeque, "computeIfAbsent(...)");
        ConcurrentLinkedDeque q = concurrentLinkedDeque;
        long l = System.currentTimeMillis();
        Location location3 = to.clone();
        Intrinsics.checkNotNullExpressionValue(location3, "clone(...)");
        q.addLast(new TimedPoint(l, location3));
        this.trimOld(q);
        while (q.size() > 400) {
            q.pollFirst();
        }
    }

    private final void trimOld(ConcurrentLinkedDeque<TimedPoint> q) {
        TimedPoint first;
        long cutoff = System.currentTimeMillis() - this.windowMs;
        while (q.peekFirst() != null && first.getTime() < cutoff) {
            q.pollFirst();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getRecentPath(@NotNull UUID playerId, int seconds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TimedPoint it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        ConcurrentLinkedDeque<TimedPoint> concurrentLinkedDeque = this.history.get(playerId);
        if (concurrentLinkedDeque == null) {
            return CollectionsKt.emptyList();
        }
        ConcurrentLinkedDeque<TimedPoint> q = concurrentLinkedDeque;
        long cutoff = System.currentTimeMillis() - (long)seconds * 1000L;
        Iterable $this$filter$iv = q;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TimedPoint)element$iv$iv;
            boolean bl = false;
            if (!(it.getTime() >= cutoff)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TimedPoint)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLoc().clone());
        }
        List list = (List)destination$iv$iv;
        return list.isEmpty() ? CollectionsKt.emptyList() : list;
    }

    public static /* synthetic */ List getRecentPath$default(MovementTracker movementTracker, UUID uUID, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        return movementTracker.getRecentPath(uUID, n);
    }

    public final void clear(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        this.history.remove(playerId);
    }

    private static final ConcurrentLinkedDeque onMove$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ConcurrentLinkedDeque();
    }

    private static final ConcurrentLinkedDeque onMove$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentLinkedDeque)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/gravediggerx/effects/MovementTracker$TimedPoint;", "", "time", "", "loc", "Lorg/bukkit/Location;", "<init>", "(JLorg/bukkit/Location;)V", "getTime", "()J", "getLoc", "()Lorg/bukkit/Location;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "GraveDiggerX"})
    public static final class TimedPoint {
        private final long time;
        @NotNull
        private final Location loc;

        public TimedPoint(long time, @NotNull Location loc) {
            Intrinsics.checkNotNullParameter(loc, "loc");
            this.time = time;
            this.loc = loc;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final Location getLoc() {
            return this.loc;
        }

        public final long component1() {
            return this.time;
        }

        @NotNull
        public final Location component2() {
            return this.loc;
        }

        @NotNull
        public final TimedPoint copy(long time, @NotNull Location loc) {
            Intrinsics.checkNotNullParameter(loc, "loc");
            return new TimedPoint(time, loc);
        }

        public static /* synthetic */ TimedPoint copy$default(TimedPoint timedPoint, long l, Location location, int n, Object object) {
            if ((n & 1) != 0) {
                l = timedPoint.time;
            }
            if ((n & 2) != 0) {
                location = timedPoint.loc;
            }
            return timedPoint.copy(l, location);
        }

        @NotNull
        public String toString() {
            return "TimedPoint(time=" + this.time + ", loc=" + this.loc + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.time);
            result = result * 31 + this.loc.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimedPoint)) {
                return false;
            }
            TimedPoint timedPoint = (TimedPoint)other;
            if (this.time != timedPoint.time) {
                return false;
            }
            return Intrinsics.areEqual(this.loc, timedPoint.loc);
        }
    }
}

