/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/gravediggerx/effects/BloodTrailManager;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "trails", "", "Ljava/util/UUID;", "Lpl/syntaxdevteam/gravediggerx/effects/BloodTrailManager$Trail;", "createTrail", "", "owner", "from", "Lorg/bukkit/Location;", "to", "onMove", "e", "Lorg/bukkit/event/player/PlayerMoveEvent;", "groundify", "loc", "cancelTrail", "cancelAll", "Trail", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nBloodTrailManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloodTrailManager.kt\npl/syntaxdevteam/gravediggerx/effects/BloodTrailManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1869#2,2:132\n1869#2,2:135\n1#3:134\n*S KotlinDebug\n*F\n+ 1 BloodTrailManager.kt\npl/syntaxdevteam/gravediggerx/effects/BloodTrailManager\n*L\n85#1:132,2\n128#1:135,2\n*E\n"})
public final class BloodTrailManager
implements Listener {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final Map<UUID, Trail> trails;

    public BloodTrailManager(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.trails = new ConcurrentHashMap();
    }

    public final void createTrail(@NotNull UUID owner, @NotNull Location from, @NotNull Location to) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(owner, "owner");
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                boolean enabled = this.plugin.getConfig().getBoolean("effects.blood-trail.enabled", true);
                if (!enabled) {
                    return;
                }
                World world = from.getWorld();
                if (world == null) {
                    return;
                }
                World world2 = world;
                if (to.getWorld() == null) break block8;
                World world3 = to.getWorld();
                Intrinsics.checkNotNull(world3);
                if (Intrinsics.areEqual(world3.getName(), world2.getName())) break block9;
            }
            return;
        }
        this.cancelTrail(owner);
        int seconds = Math.max(5, this.plugin.getConfig().getInt("effects.blood-trail.seconds", 90));
        double spacing = this.plugin.getConfig().getDouble("effects.blood-trail.spacing", 0.75);
        Vector vector = to.toVector().subtract(from.toVector());
        Intrinsics.checkNotNullExpressionValue(vector, "subtract(...)");
        Vector dir = vector;
        double length = dir.length();
        if (length <= 0.01) {
            return;
        }
        dir.normalize();
        int count = Math.min(512, Math.max(4, (int)(length / spacing)));
        ArrayList<Location> pts = new ArrayList<Location>(count);
        Location location = from.clone().add(0.0, 0.05, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location start = location;
        int i = 0;
        if (i <= count) {
            while (true) {
                Location p;
                Intrinsics.checkNotNullExpressionValue(start.clone().add(dir.clone().multiply((double)i * spacing)), "add(...)");
                Location ground = this.groundify(p);
                pts.add(ground);
                if (i == count) break;
                ++i;
            }
        }
        long expireAt = System.currentTimeMillis() + (long)seconds * 1000L;
        Trail trail = new Trail(owner, (List<Location>)pts, null, expireAt);
        this.trails.put(owner, trail);
        Particle.DustOptions dust = new Particle.DustOptions(Color.fromARGB((int)255, (int)160, (int)0, (int)0), 1.2f);
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> BloodTrailManager.createTrail$lambda$0(trail, dust, this, owner), 2L, 8L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
        BukkitTask task = bukkitTask;
        trail.setTask(task);
    }

    @EventHandler
    public final void onMove(@NotNull PlayerMoveEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (this.trails.isEmpty()) {
            return;
        }
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player p = player;
        UUID uUID = p.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uid = uUID;
        Iterable $this$forEach$iv = this.trails.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Trail tr = (Trail)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(tr.getOwner(), uid) || e.getTo() == null) continue;
            double radiusSq = 0.48999999999999994;
            Iterator<Location> iter = tr.getPoints().iterator();
            boolean removed = false;
            while (iter.hasNext()) {
                Location to;
                Location l = iter.next();
                if (!Intrinsics.areEqual(l.getWorld(), to.getWorld()) || !(l.distanceSquared(to) <= radiusSq)) continue;
                iter.remove();
                removed = true;
            }
            if (!removed || !tr.getPoints().isEmpty()) continue;
            this.cancelTrail(tr.getOwner());
        }
    }

    private final Location groundify(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return loc;
        }
        World w = world;
        int y = loc.getBlockY();
        Location location = loc.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location result = location;
        for (int steps = 0; y > w.getMinHeight() && steps < 8; --y, ++steps) {
            Block below;
            Intrinsics.checkNotNullExpressionValue(w.getBlockAt(loc.getBlockX(), y - 1, loc.getBlockZ()), "getBlockAt(...)");
            if (!below.getType().isSolid()) continue;
            result.setY((double)y + 0.01);
            return result;
        }
        return result;
    }

    public final void cancelTrail(@NotNull UUID owner) {
        block1: {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Trail trail = this.trails.remove(owner);
            if (trail == null) break block1;
            Trail tr = trail;
            boolean bl = false;
            BukkitTask bukkitTask = tr.getTask();
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
        }
    }

    public final void cancelAll() {
        Iterable $this$forEach$iv = this.trails.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Trail it = (Trail)element$iv;
            boolean bl = false;
            BukkitTask bukkitTask = it.getTask();
            if (bukkitTask == null) continue;
            bukkitTask.cancel();
        }
        this.trails.clear();
    }

    private static final void createTrail$lambda$0(Trail $trail, Particle.DustOptions $dust, BloodTrailManager this$0, UUID $owner) {
        for (Location l : $trail.getPoints()) {
            World world = l.getWorld();
            if (world != null) {
                world.spawnParticle(Particle.DUST, l, 6, 0.03, 0.0, 0.03, 0.0, (Object)$dust);
            }
            World world2 = l.getWorld();
            if (world2 == null) continue;
            world2.spawnParticle(Particle.DRIPPING_LAVA, l, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (System.currentTimeMillis() >= $trail.getExpireAt() || $trail.getPoints().isEmpty()) {
            this$0.cancelTrail($owner);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J9\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lpl/syntaxdevteam/gravediggerx/effects/BloodTrailManager$Trail;", "", "owner", "Ljava/util/UUID;", "points", "", "Lorg/bukkit/Location;", "task", "Lorg/bukkit/scheduler/BukkitTask;", "expireAt", "", "<init>", "(Ljava/util/UUID;Ljava/util/List;Lorg/bukkit/scheduler/BukkitTask;J)V", "getOwner", "()Ljava/util/UUID;", "getPoints", "()Ljava/util/List;", "getTask", "()Lorg/bukkit/scheduler/BukkitTask;", "setTask", "(Lorg/bukkit/scheduler/BukkitTask;)V", "getExpireAt", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "GraveDiggerX"})
    private static final class Trail {
        @NotNull
        private final UUID owner;
        @NotNull
        private final List<Location> points;
        @Nullable
        private BukkitTask task;
        private final long expireAt;

        public Trail(@NotNull UUID owner, @NotNull List<Location> points, @Nullable BukkitTask task, long expireAt) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(points, "points");
            this.owner = owner;
            this.points = points;
            this.task = task;
            this.expireAt = expireAt;
        }

        public /* synthetic */ Trail(UUID uUID, List list, BukkitTask bukkitTask, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bukkitTask = null;
            }
            this(uUID, list, bukkitTask, l);
        }

        @NotNull
        public final UUID getOwner() {
            return this.owner;
        }

        @NotNull
        public final List<Location> getPoints() {
            return this.points;
        }

        @Nullable
        public final BukkitTask getTask() {
            return this.task;
        }

        public final void setTask(@Nullable BukkitTask bukkitTask) {
            this.task = bukkitTask;
        }

        public final long getExpireAt() {
            return this.expireAt;
        }

        @NotNull
        public final UUID component1() {
            return this.owner;
        }

        @NotNull
        public final List<Location> component2() {
            return this.points;
        }

        @Nullable
        public final BukkitTask component3() {
            return this.task;
        }

        public final long component4() {
            return this.expireAt;
        }

        @NotNull
        public final Trail copy(@NotNull UUID owner, @NotNull List<Location> points, @Nullable BukkitTask task, long expireAt) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(points, "points");
            return new Trail(owner, points, task, expireAt);
        }

        public static /* synthetic */ Trail copy$default(Trail trail, UUID uUID, List list, BukkitTask bukkitTask, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = trail.owner;
            }
            if ((n & 2) != 0) {
                list = trail.points;
            }
            if ((n & 4) != 0) {
                bukkitTask = trail.task;
            }
            if ((n & 8) != 0) {
                l = trail.expireAt;
            }
            return trail.copy(uUID, list, bukkitTask, l);
        }

        @NotNull
        public String toString() {
            return "Trail(owner=" + this.owner + ", points=" + this.points + ", task=" + this.task + ", expireAt=" + this.expireAt + ")";
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = result * 31 + ((Object)this.points).hashCode();
            result = result * 31 + (this.task == null ? 0 : this.task.hashCode());
            result = result * 31 + Long.hashCode(this.expireAt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trail)) {
                return false;
            }
            Trail trail = (Trail)other;
            if (!Intrinsics.areEqual(this.owner, trail.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.points, trail.points)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.task, trail.task)) {
                return false;
            }
            return this.expireAt == trail.expireAt;
        }
    }
}

