/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.listeners;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;
import pl.syntaxdevteam.gravediggerx.graves.GraveManager;
import pl.syntaxdevteam.gravediggerx.gui.GraveGUI;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/syntaxdevteam/gravediggerx/listeners/GraveClickListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "effectCooldowns", "", "Ljava/util/UUID;", "", "graveGuiCache", "", "Lpl/syntaxdevteam/gravediggerx/gui/GraveGUI;", "onGraveInteract", "", "e", "Lorg/bukkit/event/player/PlayerInteractEvent;", "collectGraveInstantly", "player", "Lorg/bukkit/entity/Player;", "grave", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveClickListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveClickListener.kt\npl/syntaxdevteam/gravediggerx/listeners/GraveClickListener\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,102:1\n382#2,7:103\n*S KotlinDebug\n*F\n+ 1 GraveClickListener.kt\npl/syntaxdevteam/gravediggerx/listeners/GraveClickListener\n*L\n36#1:103,7\n*E\n"})
public final class GraveClickListener
implements Listener {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final Map<UUID, Long> effectCooldowns;
    @NotNull
    private final Map<String, GraveGUI> graveGuiCache;

    public GraveClickListener(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.effectCooldowns = new LinkedHashMap();
        this.graveGuiCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onGraveInteract(@NotNull PlayerInteractEvent e) {
        int graveExpireSeconds;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e.isCancelled()) {
            return;
        }
        Player player = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        GraveManager graveManager = this.plugin.getGraveManager();
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Grave grave = graveManager.getGraveAt(location);
        if (grave == null) {
            return;
        }
        Grave grave2 = grave;
        e.setCancelled(true);
        if (Intrinsics.areEqual(grave2.getOwnerId(), player2.getUniqueId())) {
            Object object;
            void $this$getOrPut$iv;
            if (player2.isSneaking()) {
                this.collectGraveInstantly(player2, grave2);
                return;
            }
            String string = grave2.getLocation().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String graveId = string;
            Map<String, GraveGUI> map = this.graveGuiCache;
            String key$iv = graveId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                GraveGUI answer$iv = new GraveGUI(grave2, this.plugin);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            GraveGUI gui = (GraveGUI)object;
            gui.open(player2);
            if (this.plugin.getGraveManager().getGraveAt(grave2.getLocation()) == null) {
                this.graveGuiCache.remove(graveId);
            }
            return;
        }
        long graveAgeSeconds = (System.currentTimeMillis() - grave2.getCreatedAt()) / (long)1000;
        if (graveAgeSeconds < (long)(graveExpireSeconds = this.plugin.getConfig().getInt("graves.grave-despawn", 120))) {
            long effectCooldownMs;
            long now = System.currentTimeMillis();
            Long l = this.effectCooldowns.get(player2.getUniqueId());
            long lastEffectTime = l != null ? l : 0L;
            if (now - lastEffectTime < (effectCooldownMs = this.plugin.getConfig().getLong("graves.protected-effect-cooldown", 5000L))) {
                return;
            }
            Location location2 = grave2.getLocation().clone().add(0.5, 0.5, 0.5);
            Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
            Location loc = location2;
            World world = loc.getWorld();
            if (world == null) {
                return;
            }
            World world2 = world;
            world2.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.5f);
            Component notYourGraveMsg = this.plugin.getMessageHandler().getMessage("graves", "not-your-grave", MapsKt.emptyMap());
            player2.sendMessage(notYourGraveMsg);
            Vector vector = player2.getLocation().subtract(grave2.getLocation()).toVector().normalize();
            Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
            Vector direction = vector;
            player2.setVelocity(direction.multiply(1.5));
            this.effectCooldowns.put(player2.getUniqueId(), now);
            return;
        }
        Component graveExpiredMsg = this.plugin.getMessageHandler().getMessage("graves", "not-your-grave", MapsKt.emptyMap());
        player2.sendMessage(graveExpiredMsg);
    }

    private final void collectGraveInstantly(Player player, Grave grave) {
        if (!Intrinsics.areEqual(player.getUniqueId(), grave.getOwnerId())) {
            return;
        }
        block7: for (Map.Entry<Integer, ItemStack> entry : grave.getItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            switch (slot) {
                case 36: {
                    player.getInventory().setHelmet(item);
                    continue block7;
                }
                case 37: {
                    player.getInventory().setChestplate(item);
                    continue block7;
                }
                case 38: {
                    player.getInventory().setLeggings(item);
                    continue block7;
                }
                case 39: {
                    player.getInventory().setBoots(item);
                    continue block7;
                }
                case 40: {
                    player.getInventory().setItemInOffHand(item);
                    continue block7;
                }
            }
            boolean bl = 0 <= slot ? slot < 36 : false;
            if (!bl) continue;
            ItemStack[] itemStackArray = new ItemStack[]{item};
            player.getInventory().addItem(itemStackArray);
        }
        if (grave.getStoredXp() > 0) {
            player.giveExp(grave.getStoredXp());
        }
        this.plugin.getGraveManager().removeGrave(grave);
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        Location location = grave.getLocation().clone().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location loc = location;
        world2.playSound(loc, Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.3f);
        world2.spawnParticle(Particle.SOUL, loc, 30, 0.3, 0.3, 0.3, 0.02);
        Component msg = this.plugin.getMessageHandler().getMessage("graves", "collected", MapsKt.mapOf(TuplesKt.to("player", player.getName())));
        player.sendMessage(msg);
    }
}

