/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.gravediggerx.graves;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.gravediggerx.GraveDiggerX;
import pl.syntaxdevteam.gravediggerx.graves.Grave;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpl/syntaxdevteam/gravediggerx/graves/GraveDataStore;", "", "plugin", "Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;", "<init>", "(Lpl/syntaxdevteam/gravediggerx/GraveDiggerX;)V", "dataFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "saveAllGraves", "", "graves", "", "Lpl/syntaxdevteam/gravediggerx/graves/Grave;", "loadAllGraves", "", "serializeItemStack", "", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "deserializeItemStack", "data", "GraveDiggerX"})
@SourceDebugExtension(value={"SMAP\nGraveDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraveDataStore.kt\npl/syntaxdevteam/gravediggerx/graves/GraveDataStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class GraveDataStore {
    @NotNull
    private final GraveDiggerX plugin;
    @NotNull
    private final File dataFile;
    @NotNull
    private final Gson gson;

    public GraveDataStore(@NotNull GraveDiggerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.dataFile = new File(this.plugin.getDataFolder(), "data.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAllGraves(@NotNull Collection<Grave> graves) {
        Intrinsics.checkNotNullParameter(graves, "graves");
        try {
            Object itemsArray;
            JsonArray jsonArray = new JsonArray();
            for (Grave grave : graves) {
                JsonObject graveJson = new JsonObject();
                graveJson.addProperty("ownerId", grave.getOwnerId().toString());
                graveJson.addProperty("ownerName", grave.getOwnerName());
                JsonObject locationJson = new JsonObject();
                Object object = grave.getLocation().getWorld();
                if (object == null || (object = object.getName()) == null) {
                    object = "world";
                }
                locationJson.addProperty("world", (String)object);
                locationJson.addProperty("x", (Number)grave.getLocation().getX());
                locationJson.addProperty("y", (Number)grave.getLocation().getY());
                locationJson.addProperty("z", (Number)grave.getLocation().getZ());
                locationJson.addProperty("yaw", (Number)Float.valueOf(grave.getLocation().getYaw()));
                locationJson.addProperty("pitch", (Number)Float.valueOf(grave.getLocation().getPitch()));
                graveJson.add("location", (JsonElement)locationJson);
                itemsArray = new JsonArray();
                for (Map.Entry<Integer, ItemStack> entry : grave.getItems().entrySet()) {
                    int slot = ((Number)entry.getKey()).intValue();
                    ItemStack itemStack = entry.getValue();
                    JsonObject itemJson = new JsonObject();
                    itemJson.addProperty("slot", (Number)slot);
                    itemJson.addProperty("data", this.serializeItemStack(itemStack));
                    itemsArray.add((JsonElement)itemJson);
                }
                graveJson.add("items", (JsonElement)itemsArray);
                graveJson.addProperty("originalBlockData", grave.getOriginalBlockData().getAsString());
                graveJson.addProperty("storedXp", (Number)grave.getStoredXp());
                graveJson.addProperty("createdAt", (Number)grave.getCreatedAt());
                UUID uUID = grave.getGhostEntityId();
                graveJson.addProperty("ghostEntityId", uUID != null ? uUID.toString() : null);
                graveJson.addProperty("ghostActive", Boolean.valueOf(grave.getGhostActive()));
                UUID uUID2 = grave.getLastAttackerId();
                graveJson.addProperty("lastAttackerId", uUID2 != null ? uUID2.toString() : null);
                graveJson.addProperty("itemsStolen", (Number)grave.getItemsStolen());
                jsonArray.add((JsonElement)graveJson);
            }
            String jsonText = this.gson.toJson((JsonElement)jsonArray);
            Object object = this.dataFile;
            Object object2 = Charsets.UTF_8;
            int locationJson = 8192;
            itemsArray = object;
            object = (itemsArray = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)itemsArray), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)itemsArray : new BufferedWriter((Writer)itemsArray, locationJson);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                writer.write(jsonText);
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final List<Grave> loadAllGraves() {
        try {
            if (!this.dataFile.exists()) {
                return CollectionsKt.emptyList();
            }
            content = FilesKt.readText$default(this.dataFile, null, 1, null);
            if (((CharSequence)content).length() == 0) {
                return CollectionsKt.emptyList();
            }
            jsonArray = JsonParser.parseString((String)content).getAsJsonArray();
            graves = new ArrayList<E>();
            v0 = jsonArray.iterator();
            Intrinsics.checkNotNullExpressionValue(v0, "iterator(...)");
            var4_5 = v0;
            while (var4_5.hasNext()) {
                element = (JsonElement)var4_5.next();
                try {
                    obj = element.getAsJsonObject();
                    locObj = obj.getAsJsonObject("location");
                    v1 = Bukkit.getWorld((String)locObj.get("world").getAsString());
                    if (v1 == null) {
                        v1 = Bukkit.getWorld((String)"world");
                    }
                    world = v1;
                    location = new Location(world, locObj.get("x").getAsDouble(), locObj.get("y").getAsDouble(), locObj.get("z").getAsDouble(), locObj.get("yaw").getAsFloat(), locObj.get("pitch").getAsFloat());
                    items = new LinkedHashMap<K, V>();
                    itemsArray = obj.getAsJsonArray("items");
                    Intrinsics.checkNotNullExpressionValue(itemsArray.iterator(), "iterator(...)");
                    while (var12_14.hasNext()) {
                        itemElement = (JsonElement)var12_14.next();
                        itemObj = itemElement.getAsJsonObject();
                        slot = itemObj.get("slot").getAsInt();
                        v2 = itemObj.get("data").getAsString();
                        Intrinsics.checkNotNullExpressionValue(v2, "getAsString(...)");
                        itemStack = this.deserializeItemStack(v2);
                        items.put(slot, itemStack);
                    }
                    try {
                        var14_16 = Bukkit.createBlockData((String)obj.get("originalBlockData").getAsString());
                    }
                    catch (Exception e) {
                        var14_16 = Bukkit.createBlockData((Material)Material.STONE);
                    }
                    itemElement = var14_16;
                    Intrinsics.checkNotNull(itemElement);
                    blockData = itemElement;
                    v3 = UUID.fromString(obj.get("ownerId").getAsString());
                    v4 = v3;
                    Intrinsics.checkNotNullExpressionValue(v3, "fromString(...)");
                    v5 = obj.get("ownerName").getAsString();
                    v6 = v5;
                    Intrinsics.checkNotNullExpressionValue(v5, "getAsString(...)");
                    v7 = location;
                    v8 = items;
                    v9 = null;
                    v10 = CollectionsKt.emptyList();
                    v11 = blockData;
                    v12 = obj.get("storedXp");
                    v13 = v12 != null ? v12.getAsInt() : 0;
                    v14 = obj.get("createdAt");
                    v15 = v14 != null ? v14.getAsLong() : System.currentTimeMillis();
                    v16 /* !! */  = obj.get("ghostEntityId");
                    if (v16 /* !! */  == null) ** GOTO lbl-1000
                    var17_20 = var16_19 = v16 /* !! */ ;
                    var28_34 = v15;
                    var27_33 = v13;
                    var26_32 = v11;
                    var25_31 = v10;
                    var24_30 = v9;
                    var23_29 = v8;
                    var22_28 = v7;
                    var21_27 = v6;
                    var20_26 = v4;
                    $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$1 = false;
                    var30_35 = it.isJsonNull() == false;
                    v4 = var20_26;
                    v6 = var21_27;
                    v7 = var22_28;
                    v8 = var23_29;
                    v9 = var24_30;
                    v10 = var25_31;
                    v11 = var26_32;
                    v13 = var27_33;
                    v15 = var28_34;
                    v16 /* !! */  = var30_35 != false ? var16_19 : null;
                    if (v16 /* !! */  != null && (v16 /* !! */  = v16 /* !! */ .getAsString()) != null) {
                        $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$1 /* !! */  = v16 /* !! */ ;
                        var28_34 = v15;
                        var27_33 = v13;
                        var26_32 = v11;
                        var25_31 = v10;
                        var24_30 = v9;
                        var23_29 = v8;
                        var22_28 = v7;
                        var21_27 = v6;
                        var20_26 = v4;
                        $i$a$-let-GraveDataStore$loadAllGraves$grave$2 = false;
                        var30_36 = UUID.fromString((String)it);
                        v4 = var20_26;
                        v6 = var21_27;
                        v7 = var22_28;
                        v8 = var23_29;
                        v9 = var24_30;
                        v10 = var25_31;
                        v11 = var26_32;
                        v13 = var27_33;
                        v15 = var28_34;
                        v17 = var30_36;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v17 = null;
                    }
                    v18 = obj.get("ghostActive");
                    v19 = v18 != null ? v18.getAsBoolean() : false;
                    v20 /* !! */  = obj.get("lastAttackerId");
                    if (v20 /* !! */  == null) ** GOTO lbl-1000
                    it = var16_19 = v20 /* !! */ ;
                    var31_38 = v19;
                    var30_37 = v17;
                    var28_34 = v15;
                    var27_33 = v13;
                    var26_32 = v11;
                    var25_31 = v10;
                    var24_30 = v9;
                    var23_29 = v8;
                    var22_28 = v7;
                    var21_27 = v6;
                    var20_26 = v4;
                    $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$3 = false;
                    var32_39 = it.isJsonNull() == false;
                    v4 = var20_26;
                    v6 = var21_27;
                    v7 = var22_28;
                    v8 = var23_29;
                    v9 = var24_30;
                    v10 = var25_31;
                    v11 = var26_32;
                    v13 = var27_33;
                    v15 = var28_34;
                    v17 = var30_37;
                    v19 = var31_38;
                    v20 /* !! */  = var32_39 != false ? var16_19 : null;
                    if (v20 /* !! */  != null && (v20 /* !! */  = v20 /* !! */ .getAsString()) != null) {
                        $i$a$-takeIf-GraveDataStore$loadAllGraves$grave$3 /* !! */  = v20 /* !! */ ;
                        var31_38 = v19;
                        var30_37 = v17;
                        var28_34 = v15;
                        var27_33 = v13;
                        var26_32 = v11;
                        var25_31 = v10;
                        var24_30 = v9;
                        var23_29 = v8;
                        var22_28 = v7;
                        var21_27 = v6;
                        var20_26 = v4;
                        $i$a$-let-GraveDataStore$loadAllGraves$grave$4 = false;
                        var32_40 = UUID.fromString((String)it);
                        v4 = var20_26;
                        v6 = var21_27;
                        v7 = var22_28;
                        v8 = var23_29;
                        v9 = var24_30;
                        v10 = var25_31;
                        v11 = var26_32;
                        v13 = var27_33;
                        v15 = var28_34;
                        v17 = var30_37;
                        v19 = var31_38;
                        v21 = var32_40;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v21 = null;
                    }
                    v22 = obj.get("itemsStolen");
                    var33_41 = null;
                    var34_42 = 16;
                    var35_43 = v22 != null ? v22.getAsInt() : 0;
                    var36_44 = v21;
                    var37_45 = v19;
                    var38_46 = v17;
                    var39_47 = v15;
                    var41_48 = v13;
                    var42_49 = v11;
                    var43_50 = v10;
                    var44_51 = v9;
                    var45_52 = v8;
                    var46_53 = v7;
                    var47_54 = v6;
                    var48_55 = v4;
                    grave = new Grave(var48_55, var47_54, var46_53, var45_52, var44_51, var43_50, (BlockData)var42_49, var41_48, var39_47, var38_46, var37_45, var36_44, var35_43, var34_42, var33_41);
                    graves.add(grave);
                }
                catch (Exception var7_9) {}
            }
            var1_1 = var3_4;
        }
        catch (Exception e) {
            var1_1 = CollectionsKt.emptyList();
        }
        return var1_1;
    }

    private final String serializeItemStack(ItemStack itemStack) {
        String string;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemStack);
            dataOutput.close();
            string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            Intrinsics.checkNotNull(string);
        }
        catch (Exception e) {
            String string2 = Base64.getEncoder().encodeToString(new byte[0]);
            Intrinsics.checkNotNull(string2);
            string = string2;
        }
        return string;
    }

    private final ItemStack deserializeItemStack(String data) {
        ItemStack itemStack;
        try {
            if (((CharSequence)data).length() == 0) {
                return new ItemStack(Material.AIR);
            }
            byte[] decoded = Base64.getDecoder().decode(data);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Object object = dataInput.readObject();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.inventory.ItemStack");
            ItemStack itemStack2 = (ItemStack)object;
            dataInput.close();
            itemStack = itemStack2;
        }
        catch (Exception e) {
            itemStack = new ItemStack(Material.AIR);
        }
        return itemStack;
    }
}

