/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.storage;

import com.smartchat.SmartChatPlugin;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public class StorageManager {
    private final SmartChatPlugin plugin;
    private final String dbPath;
    private Connection conn;

    public StorageManager(SmartChatPlugin plugin) {
        this.plugin = plugin;
        String cfgPath = plugin.getConfig().getString("general.sqlite_file", "");
        if (cfgPath == null || cfgPath.isBlank()) {
            File f = plugin.getDataFolder();
            if (!f.exists()) {
                f.mkdirs();
            }
            this.dbPath = f.getAbsolutePath() + File.separator + "smartchat.db";
        } else {
            this.dbPath = cfgPath;
            File dbFile = new File(this.dbPath);
            File parent = dbFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
        }
        this.init();
    }

    private synchronized void init() {
        try {
            String url = "jdbc:sqlite:" + this.dbPath;
            this.conn = DriverManager.getConnection(url);
            try (Statement s = this.conn.createStatement();){
                s.executeUpdate("CREATE TABLE IF NOT EXISTS mail (id INTEGER PRIMARY KEY AUTOINCREMENT,recipient TEXT NOT NULL,payload TEXT NOT NULL,ts INTEGER NOT NULL)");
                s.executeUpdate("CREATE TABLE IF NOT EXISTS ignores (player TEXT NOT NULL,ignored TEXT NOT NULL,PRIMARY KEY (player, ignored))");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize StorageManager: " + e.getMessage());
        }
    }

    public synchronized void addMail(UUID recipient, String senderName, String messagePlain) {
        if (recipient == null) {
            return;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO mail (recipient, payload, ts) VALUES (?, ?, ?)");){
            String payload = (String)this.plugin.miniMessage().serialize(Component.text((String)("From " + senderName + ": ")).append((Component)Component.text((String)messagePlain)));
            ps.setString(1, recipient.toString());
            ps.setString(2, payload);
            ps.setLong(3, System.currentTimeMillis());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to add mail: " + e.getMessage());
        }
    }

    public synchronized List<String> getMail(UUID recipient) {
        ArrayList<String> out = new ArrayList<String>();
        if (recipient == null) {
            return out;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("SELECT payload FROM mail WHERE recipient = ? ORDER BY ts ASC");){
            ps.setString(1, recipient.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    out.add(rs.getString("payload"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to fetch mail: " + e.getMessage());
        }
        return out;
    }

    public synchronized void clearMail(UUID recipient) {
        if (recipient == null) {
            return;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("DELETE FROM mail WHERE recipient = ?");){
            ps.setString(1, recipient.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to clear mail: " + e.getMessage());
        }
    }

    public synchronized void addIgnore(UUID player, UUID ignored) {
        if (player == null || ignored == null) {
            return;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT OR IGNORE INTO ignores (player, ignored) VALUES (?, ?)");){
            ps.setString(1, player.toString());
            ps.setString(2, ignored.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to add ignore: " + e.getMessage());
        }
    }

    public synchronized void removeIgnore(UUID player, UUID ignored) {
        if (player == null || ignored == null) {
            return;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("DELETE FROM ignores WHERE player = ? AND ignored = ?");){
            ps.setString(1, player.toString());
            ps.setString(2, ignored.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to remove ignore: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isIgnored(UUID recipient, UUID sender) {
        if (recipient == null || sender == null) {
            return false;
        }
        try (PreparedStatement ps = this.conn.prepareStatement("SELECT 1 FROM ignores WHERE player = ? AND ignored = ? LIMIT 1");){
            boolean bl;
            block15: {
                ps.setString(1, recipient.toString());
                ps.setString(2, sender.toString());
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to check ignore: " + e.getMessage());
            return false;
        }
    }

    public synchronized void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to close StorageManager connection: " + e.getMessage());
        }
    }
}

