/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.moderation;

import com.smartchat.SmartChatPlugin;
import com.smartchat.chat.ChatChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class FilterManager {
    private final SmartChatPlugin plugin;
    private final Map<UUID, Long> lastMessageTimestamps = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> lastMessages = new ConcurrentHashMap<UUID, String>();
    private final Set<UUID> mentionsDisabled = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Map<ChatChannel, List<Long>>> channelMessageHistory = new ConcurrentHashMap<UUID, Map<ChatChannel, List<Long>>>();

    public FilterManager(SmartChatPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isOnGlobalCooldown(UUID player) {
        if (player == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        Long last = this.lastMessageTimestamps.get(player);
        int cooldownSeconds = this.plugin.getConfig().getInt("general.global_cooldown_seconds", 1);
        if (last == null) {
            return false;
        }
        return now - last < (long)cooldownSeconds * 1000L;
    }

    public void recordMessageTimestamp(UUID player) {
        if (player == null) {
            return;
        }
        this.lastMessageTimestamps.put(player, System.currentTimeMillis());
    }

    public String applyAutoLowercase(String message) {
        if (message == null) {
            return null;
        }
        int totalLetters = 0;
        int upperLetters = 0;
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (!Character.isLetter(c)) continue;
            ++totalLetters;
            if (!Character.isUpperCase(c)) continue;
            ++upperLetters;
        }
        if (totalLetters == 0) {
            return message;
        }
        double percentUpper = (double)upperLetters / (double)totalLetters * 100.0;
        int threshold = this.plugin.getConfig().getInt("general.auto_lowercase_threshold_percent", 70);
        if (percentUpper >= (double)threshold) {
            return message.toLowerCase();
        }
        return message;
    }

    public String applyProfanityFilter(String message) {
        if (message == null) {
            return null;
        }
        List badWords = this.plugin.getConfig().getStringList("general.profanity");
        String out = message;
        for (String raw : badWords) {
            if (raw == null || raw.isBlank()) continue;
            String word = raw.trim();
            try {
                Pattern p = Pattern.compile("(?i)\\b" + Pattern.quote(word) + "\\b", 64);
                out = p.matcher(out).replaceAll("***");
            }
            catch (Exception e) {
                out = out.replaceAll("(?i)" + Pattern.quote(word), "***");
            }
        }
        return out;
    }

    public boolean isSpam(UUID player, String newMessage) {
        if (player == null || newMessage == null) {
            return false;
        }
        String last = this.lastMessages.get(player);
        if (last == null || last.isBlank()) {
            return false;
        }
        String a = this.normalizeForComparison(last);
        String b = this.normalizeForComparison(newMessage);
        if (a.isEmpty() && b.isEmpty()) {
            return false;
        }
        int dist = this.levenshteinDistance(a, b);
        int maxLen = Math.max(a.length(), b.length());
        if (maxLen == 0) {
            return false;
        }
        double similarityPercent = (1.0 - (double)dist / (double)maxLen) * 100.0;
        int threshold = this.plugin.getConfig().getInt("general.spam_similarity_threshold_percent", 80);
        return similarityPercent >= (double)threshold;
    }

    public boolean isRateLimited(UUID player, ChatChannel channel) {
        if (player == null || channel == null) {
            return false;
        }
        if (channel != ChatChannel.GLOBAL && channel != ChatChannel.TRADE) {
            return false;
        }
        long now = System.currentTimeMillis();
        String configKey = channel == ChatChannel.GLOBAL ? "channels.global.cooldown_per_minute" : "channels.trade.cooldown_per_minute";
        int limit = this.plugin.getConfig().getInt(configKey, 2);
        Map playerHistory = this.channelMessageHistory.computeIfAbsent(player, k -> new ConcurrentHashMap());
        List timestamps = playerHistory.computeIfAbsent(channel, k -> new ArrayList());
        timestamps.removeIf(ts -> now - ts >= 60000L);
        if (timestamps.size() >= limit) {
            return true;
        }
        timestamps.add(now);
        return false;
    }

    public void recordLastMessage(UUID player, String message) {
        if (player == null) {
            return;
        }
        if (message == null) {
            this.lastMessages.remove(player);
        } else {
            this.lastMessages.put(player, message);
        }
    }

    public String getLastMessage(UUID player) {
        return this.lastMessages.get(player);
    }

    public boolean toggleMentions(UUID uuid) {
        if (uuid == null) {
            return true;
        }
        if (this.mentionsDisabled.contains(uuid)) {
            this.mentionsDisabled.remove(uuid);
            return true;
        }
        this.mentionsDisabled.add(uuid);
        return false;
    }

    public boolean hasMentionsDisabled(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.mentionsDisabled.contains(uuid);
    }

    private String normalizeForComparison(String s) {
        return s.trim().replaceAll("\\s+", " ").toLowerCase();
    }

    private int levenshteinDistance(String a, String b) {
        int n = a.length();
        int m = b.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] prev = new int[m + 1];
        int[] curr = new int[m + 1];
        for (int j = 0; j <= m; ++j) {
            prev[j] = j;
        }
        for (int i = 1; i <= n; ++i) {
            curr[0] = i;
            for (int j = 1; j <= m; ++j) {
                int cost = a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1;
                curr[j] = Math.min(Math.min(curr[j - 1] + 1, prev[j] + 1), prev[j - 1] + cost);
            }
            int[] tmp = prev;
            prev = curr;
            curr = tmp;
        }
        return prev[m];
    }
}

