/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.listener;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.smartchat.SmartChatPlugin;
import com.smartchat.chat.ChannelManager;
import com.smartchat.chat.ChatChannel;
import com.smartchat.chat.Party;
import com.smartchat.interactive.ChatBubbleManager;
import com.smartchat.moderation.FilterManager;
import com.smartchat.storage.StorageManager;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final SmartChatPlugin plugin;
    private final ChannelManager channelManager;
    private final FilterManager filterManager;
    private final StorageManager storageManager;
    private final ChatBubbleManager bubbleManager;
    private final Map<UUID, Long> itemLinkCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> mutedUntil = new ConcurrentHashMap<UUID, Long>();
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([A-Za-z0-9_]{2,16})");
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://\\S+)", 2);

    public ChatListener(SmartChatPlugin plugin, ChannelManager channelManager, FilterManager filterManager, StorageManager storageManager, ChatBubbleManager bubbleManager) {
        this.plugin = plugin;
        this.channelManager = channelManager;
        this.filterManager = filterManager;
        this.storageManager = storageManager;
        this.bubbleManager = bubbleManager;
    }

    @EventHandler
    public void onAsyncChat(AsyncChatEvent event) {
        event.setCancelled(true);
        Player sender = event.getPlayer();
        UUID senderId = sender.getUniqueId();
        Long muted = this.mutedUntil.get(senderId);
        if (muted != null && muted > System.currentTimeMillis()) {
            sender.sendMessage((Component)Component.text((String)"You are muted for spam. Wait before chatting.", (TextColor)NamedTextColor.RED));
            return;
        }
        String plain = PlainTextComponentSerializer.plainText().serialize(event.message());
        boolean bypass = sender.hasPermission("smartchat.bypass");
        if (!bypass) {
            if (this.filterManager.isOnGlobalCooldown(senderId)) {
                sender.sendMessage((Component)Component.text((String)"You are sending messages too quickly. Wait before chatting.", (TextColor)NamedTextColor.RED));
                return;
            }
            if (this.filterManager.isSpam(senderId, plain)) {
                this.mutedUntil.put(senderId, System.currentTimeMillis() + (long)this.plugin.getConfig().getInt("general.spam_mute_seconds", 30) * 1000L);
                sender.sendMessage((Component)Component.text((String)"Message detected as spam and blocked. You are muted for 30s.", (TextColor)NamedTextColor.RED));
                return;
            }
            plain = this.filterManager.applyAutoLowercase(plain);
            plain = this.filterManager.applyProfanityFilter(plain);
        }
        this.filterManager.recordMessageTimestamp(senderId);
        this.filterManager.recordLastMessage(senderId, plain);
        Component senderNameComp = this.buildSenderComponent(sender);
        Component messageComp = this.buildMessageComponentWithInteractivity(sender, plain);
        if (messageComp == null) {
            return;
        }
        ChatChannel active = this.channelManager.getActiveChannel(senderId);
        if (active == ChatChannel.GLOBAL && !this.channelManager.isInGlobal(senderId)) {
            this.channelManager.setActiveChannel(senderId, ChatChannel.PROXIMITY);
            sender.sendMessage((Component)Component.text((String)"You are no longer in Global. Switched to Proximity.", (TextColor)NamedTextColor.YELLOW));
            active = ChatChannel.PROXIMITY;
        }
        if (active == ChatChannel.PARTY && !this.channelManager.getPartyForPlayer(senderId).isPresent()) {
            this.channelManager.setActiveChannel(senderId, ChatChannel.PROXIMITY);
            sender.sendMessage((Component)Component.text((String)"You are not in a party. Switched to Proximity.", (TextColor)NamedTextColor.YELLOW));
            active = ChatChannel.PROXIMITY;
        }
        if ((active == ChatChannel.GLOBAL || active == ChatChannel.TRADE) && this.filterManager.isRateLimited(senderId, active)) {
            sender.sendMessage((Component)Component.text((String)"You have reached the message limit for this channel. Please wait.", (TextColor)NamedTextColor.RED));
            return;
        }
        TextComponent finalComp = Component.empty();
        switch (active) {
            case GLOBAL: {
                String gPrefix = this.plugin.getConfig().getString("channels.global.prefix", "[Global]");
                finalComp = ((TextComponent)((TextComponent)Component.text((String)(gPrefix + " "), (TextColor)NamedTextColor.GREEN).append(senderNameComp)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.WHITE))).append(messageComp);
                break;
            }
            case TRADE: {
                String tPrefix = this.plugin.getConfig().getString("channels.trade.prefix", "[Trade]");
                finalComp = ((TextComponent)((TextComponent)Component.text((String)(tPrefix + " "), (TextColor)NamedTextColor.YELLOW).append(senderNameComp)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.WHITE))).append(messageComp);
                break;
            }
            case PARTY: {
                Optional<Party> optParty = this.channelManager.getPartyForPlayer(senderId);
                String pPrefix = this.plugin.getConfig().getString("channels.party.prefix_member", "[Party]");
                if (optParty.isPresent() && optParty.get().getLeader().equals(senderId)) {
                    pPrefix = this.plugin.getConfig().getString("channels.party.prefix_leader", "[Party Leader]");
                }
                finalComp = ((TextComponent)((TextComponent)Component.text((String)(pPrefix + " "), (TextColor)NamedTextColor.BLUE).append(senderNameComp)).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.WHITE))).append(messageComp);
                break;
            }
            default: {
                finalComp = senderNameComp.append((Component)Component.text((String)": ", (TextColor)NamedTextColor.WHITE)).append(messageComp);
            }
        }
        TextComponent messageToBroadcast = finalComp;
        ChatChannel sendChannel = active;
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.lambda$onAsyncChat$0(sendChannel, sender, (Component)messageToBroadcast));
    }

    @EventHandler
    public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
        String lastWord;
        String buffer = event.getBuffer();
        if (buffer.startsWith("/")) {
            return;
        }
        int lastSpace = buffer.lastIndexOf(32);
        String string = lastWord = lastSpace == -1 ? buffer : buffer.substring(lastSpace + 1);
        if (!lastWord.startsWith("@")) {
            return;
        }
        String partialName = lastWord.substring(1).toLowerCase();
        ArrayList<CallSite> suggestions = new ArrayList<CallSite>();
        UUID senderId = event.getSender() instanceof Player ? ((Player)event.getSender()).getUniqueId() : null;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (senderId != null && p.getUniqueId().equals(senderId) || senderId != null && this.storageManager.isIgnored(p.getUniqueId(), senderId) || !p.getName().toLowerCase().startsWith(partialName)) continue;
            suggestions.add((CallSite)((Object)("@" + p.getName())));
        }
        event.setCompletions(suggestions);
        if (!suggestions.isEmpty()) {
            event.setHandled(true);
        }
    }

    private Component buildSenderComponent(Player sender) {
        UUID id = sender.getUniqueId();
        int ping = sender.getPing();
        double health = sender.getHealth();
        long playTicks = sender.getStatistic(Statistic.PLAY_ONE_MINUTE);
        double hours = (double)playTicks / 72000.0;
        String hover = String.format("Name: %s\nStatus: %s\nPing: %d ms\nHealth: %.1f\nPlaytime: %.2f h\nClick to whisper", sender.getName(), sender.isOp() ? "OP" : "NON-OP", ping, health, hours);
        TextComponent hoverComp = Component.text((String)hover);
        return ((TextComponent)Component.text((String)sender.getName(), (TextColor)NamedTextColor.WHITE).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComp))).clickEvent(ClickEvent.suggestCommand((String)("/w " + sender.getName())));
    }

    private Component buildMessageComponentWithInteractivity(Player sender, String plain) {
        int pos;
        String processedText = plain;
        ArrayList<Integer> itemPositions = new ArrayList<Integer>();
        int idx = 0;
        while (idx < processedText.length() && (pos = processedText.indexOf("[item]", idx)) != -1) {
            itemPositions.add(pos);
            idx = pos + 6;
        }
        ArrayList<Match> allMatches = new ArrayList<Match>();
        Matcher mentionMatcher = MENTION_PATTERN.matcher(plain);
        while (mentionMatcher.find()) {
            allMatches.add(new Match(mentionMatcher.start(), mentionMatcher.end(), "mention", mentionMatcher.group(1)));
        }
        Matcher urlMatcher = URL_PATTERN.matcher(plain);
        while (urlMatcher.find()) {
            allMatches.add(new Match(urlMatcher.start(), urlMatcher.end(), "url", urlMatcher.group(1)));
        }
        allMatches.sort((a, b) -> Integer.compare(a.start, b.start));
        TextComponent finalComp = Component.empty();
        int lastEnd = 0;
        int processedEnd = 0;
        for (Match match : allMatches) {
            if (match.start < processedEnd) continue;
            if (match.start > lastEnd) {
                String beforeText = plain.substring(lastEnd, match.start);
                Component beforeComp = this.buildTextWithItems(sender, beforeText);
                if (beforeComp == null) {
                    return null;
                }
                finalComp = finalComp.append(beforeComp);
            }
            if (match.type.equals("mention")) {
                String name = match.value;
                Player mentioned = Bukkit.getPlayerExact((String)name);
                if (mentioned != null && mentioned.isOnline()) {
                    Component mentionComp = this.buildMentionComponent(mentioned);
                    finalComp = finalComp.append(mentionComp);
                    UUID mentionedId = mentioned.getUniqueId();
                    UUID senderId = sender.getUniqueId();
                    if (!this.filterManager.hasMentionsDisabled(mentionedId) && !this.storageManager.isIgnored(mentionedId, senderId)) {
                        mentioned.playSound(mentioned.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                } else {
                    finalComp = finalComp.append((Component)Component.text((String)("@" + name), (TextColor)NamedTextColor.GRAY));
                }
            } else if (match.type.equals("url")) {
                String url = match.value;
                Component urlComp = ((TextComponent)((TextComponent)Component.text((String)url, (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)url))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open link.\nAlways trust the source!", (TextColor)NamedTextColor.GRAY)));
                finalComp = finalComp.append(urlComp);
            }
            lastEnd = match.end;
            processedEnd = match.end;
        }
        if (lastEnd < plain.length()) {
            String remainingText = plain.substring(lastEnd);
            Component remainingComp = this.buildTextWithItems(sender, remainingText);
            if (remainingComp == null) {
                return null;
            }
            finalComp = finalComp.append(remainingComp);
        }
        return finalComp;
    }

    private Component buildTextWithItems(Player sender, String text) {
        TextComponent result = Component.empty();
        int idx = 0;
        while (idx < text.length()) {
            int pos = text.indexOf("[item]", idx);
            if (pos == -1) {
                result = result.append((Component)Component.text((String)text.substring(idx), (TextColor)NamedTextColor.WHITE));
                break;
            }
            if (pos > idx) {
                result = result.append((Component)Component.text((String)text.substring(idx, pos), (TextColor)NamedTextColor.WHITE));
            }
            TextComponent itemComp = Component.text((String)"[No Item]", (TextColor)NamedTextColor.GOLD);
            ItemStack stack = sender.getInventory().getItemInMainHand();
            if (stack != null && !stack.getType().isAir()) {
                int cooldownSecs;
                long last;
                long now = System.currentTimeMillis();
                if (now - (last = this.itemLinkCooldowns.getOrDefault(sender.getUniqueId(), 0L).longValue()) >= (long)(cooldownSecs = this.plugin.getConfig().getInt("interactivity.item_link_cooldown_seconds", 8)) * 1000L) {
                    this.itemLinkCooldowns.put(sender.getUniqueId(), now);
                    try {
                        String name = stack.hasItemMeta() && stack.getItemMeta().hasDisplayName() ? stack.getItemMeta().getDisplayName() : stack.getType().name();
                        itemComp = Component.text((String)name, (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)stack.asHoverEvent());
                    }
                    catch (Throwable t) {
                        itemComp = Component.text((String)stack.getType().name(), (TextColor)NamedTextColor.GOLD);
                    }
                } else {
                    long remaining = (long)cooldownSecs * 1000L - (now - last);
                    long secs = Math.max(1L, (remaining + 999L) / 1000L);
                    sender.sendMessage((Component)Component.text((String)("You are on item-link cooldown for " + secs + "s."), (TextColor)NamedTextColor.RED));
                    return null;
                }
            }
            result = result.append((Component)itemComp);
            idx = pos + 6;
        }
        return result;
    }

    private Component buildMentionComponent(Player mentioned) {
        int ping = mentioned.getPing();
        double health = mentioned.getHealth();
        long playTicks = mentioned.getStatistic(Statistic.PLAY_ONE_MINUTE);
        double hours = (double)playTicks / 72000.0;
        String hover = String.format("Name: %s\nStatus: %s\nPing: %d ms\nHealth: %.1f\nPlaytime: %.2f h\nClick to whisper", mentioned.getName(), mentioned.isOp() ? "OP" : "NON-OP", ping, health, hours);
        TextComponent hoverComp = Component.text((String)hover);
        return ((TextComponent)Component.text((String)("@" + mentioned.getName()), (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComp))).clickEvent(ClickEvent.suggestCommand((String)("/w " + mentioned.getName())));
    }

    private void broadcastToGlobal(Player sender, Component message) {
        UUID senderId = sender.getUniqueId();
        HashSet<UUID> recipients = new HashSet<UUID>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.storageManager.isIgnored(p.getUniqueId(), senderId) || !this.channelManager.isInGlobal(p.getUniqueId())) continue;
            p.sendMessage(message);
            recipients.add(p.getUniqueId());
        }
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("smartchat.spy") || recipients.contains(admin.getUniqueId()) || this.storageManager.isIgnored(admin.getUniqueId(), senderId)) continue;
            admin.sendMessage(Component.text((String)"[Spy] ").append(message));
        }
    }

    private void broadcastToTrade(Player sender, Component message) {
        UUID senderId = sender.getUniqueId();
        HashSet<UUID> recipients = new HashSet<UUID>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.storageManager.isIgnored(p.getUniqueId(), senderId)) continue;
            p.sendMessage(message);
            recipients.add(p.getUniqueId());
        }
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("smartchat.spy") || recipients.contains(admin.getUniqueId()) || this.storageManager.isIgnored(admin.getUniqueId(), senderId)) continue;
            admin.sendMessage(Component.text((String)"[Spy] ").append(message));
        }
    }

    private void broadcastToParty(Player sender, Component message) {
        UUID senderId = sender.getUniqueId();
        Optional<Party> optParty = this.channelManager.getPartyForPlayer(senderId);
        if (!optParty.isPresent()) {
            sender.sendMessage((Component)Component.text((String)"You are not in a party.", (TextColor)NamedTextColor.RED));
            return;
        }
        Party party = optParty.get();
        HashSet<UUID> recipients = new HashSet<UUID>();
        recipients.add(party.getLeader());
        recipients.addAll(party.getMembers());
        for (UUID uid : recipients) {
            Player p = Bukkit.getPlayer((UUID)uid);
            if (p == null || !p.isOnline() || this.storageManager.isIgnored(p.getUniqueId(), senderId)) continue;
            p.sendMessage(message);
        }
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("smartchat.spy") || recipients.contains(admin.getUniqueId()) || this.storageManager.isIgnored(admin.getUniqueId(), senderId)) continue;
            admin.sendMessage(Component.text((String)"[Spy] ").append(message));
        }
    }

    private void broadcastToProximity(Player sender, Component message) {
        UUID senderId = sender.getUniqueId();
        int radius = this.plugin.getConfig().getInt("channels.proximity.radius", 100);
        boolean found = false;
        for (Player p : sender.getWorld().getPlayers()) {
            if (p.equals((Object)sender) || this.storageManager.isIgnored(p.getUniqueId(), senderId) || !(p.getLocation().distanceSquared(sender.getLocation()) <= (double)(radius * radius))) continue;
            p.sendMessage(message);
            found = true;
        }
        if (!found) {
            sender.sendMessage((Component)Component.text((String)this.plugin.getConfig().getString("channels.proximity.no_listeners_message", "No one is near you and no one heard you."), (TextColor)NamedTextColor.GRAY));
        } else {
            this.bubbleManager.spawnBubble(sender, message);
        }
        sender.sendMessage(message);
    }

    private /* synthetic */ void lambda$onAsyncChat$0(ChatChannel sendChannel, Player sender, Component messageToBroadcast) {
        switch (sendChannel) {
            case GLOBAL: {
                this.broadcastToGlobal(sender, messageToBroadcast);
                break;
            }
            case TRADE: {
                this.broadcastToTrade(sender, messageToBroadcast);
                break;
            }
            case PARTY: {
                this.broadcastToParty(sender, messageToBroadcast);
                break;
            }
            default: {
                this.broadcastToProximity(sender, messageToBroadcast);
            }
        }
    }

    private static class Match {
        int start;
        int end;
        String type;
        String value;

        Match(int start, int end, String type, String value) {
            this.start = start;
            this.end = end;
            this.type = type;
            this.value = value;
        }
    }
}

