/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.interactive;

import com.smartchat.SmartChatPlugin;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChatBubbleManager {
    private final SmartChatPlugin plugin;
    private final Map<UUID, BubbleInfo> activeBubbles = new ConcurrentHashMap<UUID, BubbleInfo>();

    public ChatBubbleManager(SmartChatPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQuit(PlayerQuitEvent ev) {
                ChatBubbleManager.this.removeBubble(ev.getPlayer().getUniqueId());
            }
        }, (Plugin)plugin);
        plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> plugin.getServer().getPluginManager().registerEvents(new Listener(this){}, (Plugin)plugin));
    }

    public void spawnBubble(final Player player, Component message) {
        TextDisplay display;
        if (player == null || message == null) {
            return;
        }
        final UUID id = player.getUniqueId();
        this.removeBubble(id);
        Location loc = player.getLocation().add(0.0, 2.2, 0.0);
        try {
            display = (TextDisplay)player.getWorld().spawnEntity(loc, EntityType.TEXT_DISPLAY);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to spawn TextDisplay: " + e.getMessage());
            return;
        }
        try {
            display.text(message);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            // empty catch block
        }
        try {
            display.setBillboard(Display.Billboard.CENTER);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            display.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        }
        catch (Throwable e) {
            // empty catch block
        }
        final BukkitRunnable tracker = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || display.isDead()) {
                    this.cancel();
                    if (!display.isDead()) {
                        try {
                            display.remove();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ChatBubbleManager.this.activeBubbles.remove(id);
                    return;
                }
                Location target = player.getLocation().add(0.0, 2.2, 0.0);
                try {
                    display.teleport(target);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        tracker.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        int duration = this.plugin.getConfig().getInt("channels.proximity.bubble_duration_seconds", 4);
        BukkitRunnable remover = new BukkitRunnable(){

            public void run() {
                tracker.cancel();
                try {
                    if (!display.isDead()) {
                        display.remove();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ChatBubbleManager.this.activeBubbles.remove(id);
            }
        };
        remover.runTaskLater((Plugin)this.plugin, (long)duration * 20L);
        this.activeBubbles.put(id, new BubbleInfo(display, tracker, remover));
    }

    public void removeBubble(UUID playerId) {
        if (playerId == null) {
            return;
        }
        BubbleInfo info = this.activeBubbles.remove(playerId);
        if (info == null) {
            return;
        }
        try {
            info.tracker.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            info.remover.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!info.display.isDead()) {
                info.display.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void shutdown() {
        for (UUID id : this.activeBubbles.keySet()) {
            this.removeBubble(id);
        }
    }

    private static class BubbleInfo {
        final TextDisplay display;
        final BukkitRunnable tracker;
        final BukkitRunnable remover;

        BubbleInfo(TextDisplay display, BukkitRunnable tracker, BukkitRunnable remover) {
            this.display = display;
            this.tracker = tracker;
            this.remover = remover;
        }
    }
}

