/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.commands;

import com.smartchat.SmartChatPlugin;
import com.smartchat.chat.ChannelManager;
import com.smartchat.chat.ChatChannel;
import com.smartchat.chat.Party;
import com.smartchat.moderation.FilterManager;
import com.smartchat.storage.StorageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final SmartChatPlugin plugin;
    private final ChannelManager channelManager;
    private final StorageManager storageManager;
    private final FilterManager filterManager;
    private final Map<UUID, UUID> lastMessaged = new HashMap<UUID, UUID>();

    public CommandManager(SmartChatPlugin plugin, ChannelManager channelManager, StorageManager storageManager, FilterManager filterManager) {
        this.plugin = plugin;
        this.channelManager = channelManager;
        this.storageManager = storageManager;
        this.filterManager = filterManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can use SmartChat commands.", (TextColor)NamedTextColor.RED));
            return true;
        }
        Player p = (Player)sender;
        UUID pid = p.getUniqueId();
        switch (cmd = command.getName().toLowerCase()) {
            case "s": {
                this.channelManager.setActiveChannel(pid, ChatChannel.PROXIMITY);
                p.sendMessage((Component)Component.text((String)"Switched to proximity chat.", (TextColor)NamedTextColor.GRAY));
                return true;
            }
            case "g": {
                this.channelManager.setActiveChannel(pid, ChatChannel.GLOBAL);
                p.sendMessage((Component)Component.text((String)"Switched to global chat.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "t": {
                this.channelManager.setActiveChannel(pid, ChatChannel.TRADE);
                p.sendMessage((Component)Component.text((String)"Switched to trade chat.", (TextColor)NamedTextColor.YELLOW));
                return true;
            }
            case "join": {
                if (args.length < 1 || !args[0].equalsIgnoreCase("global")) break;
                if (this.channelManager.joinGlobal(pid)) {
                    p.sendMessage((Component)Component.text((String)"You joined the Global channel.", (TextColor)NamedTextColor.GREEN));
                } else {
                    p.sendMessage((Component)Component.text((String)"You are already in the Global channel.", (TextColor)NamedTextColor.YELLOW));
                }
                return true;
            }
            case "leave": {
                if (args.length < 1 || !args[0].equalsIgnoreCase("global")) break;
                if (this.channelManager.leaveGlobal(pid)) {
                    p.sendMessage((Component)Component.text((String)"You left the Global channel.", (TextColor)NamedTextColor.GRAY));
                } else {
                    p.sendMessage((Component)Component.text((String)"You were not in the Global channel.", (TextColor)NamedTextColor.YELLOW));
                }
                return true;
            }
            case "w": {
                if (args.length < 2) {
                    p.sendMessage((Component)Component.text((String)"Usage: /w <player> <message>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                String targetName = args[0];
                Player target = Bukkit.getPlayerExact((String)targetName);
                String msg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                if (target != null && target.isOnline()) {
                    if (this.storageManager.isIgnored(target.getUniqueId(), pid)) {
                        p.sendMessage((Component)Component.text((String)"That player is ignoring you.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Component comp = ((TextComponent)Component.text((String)"[Whisper] ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((String)("[" + p.getName() + " -> " + target.getName() + "]: "), (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)msg, (TextColor)NamedTextColor.LIGHT_PURPLE));
                    target.sendMessage(comp);
                    p.sendMessage(comp);
                    this.lastMessaged.put(target.getUniqueId(), pid);
                    this.lastMessaged.put(pid, target.getUniqueId());
                    for (Player admin : Bukkit.getOnlinePlayers()) {
                        if (!admin.hasPermission("smartchat.spy") || admin.equals((Object)p) || admin.equals((Object)target)) continue;
                        Component spy = ((TextComponent)Component.text((String)"[Spy] ").append((Component)Component.text((String)("[" + p.getName() + " -> " + target.getName() + "]: "), (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)msg, (TextColor)NamedTextColor.LIGHT_PURPLE));
                        admin.sendMessage(spy);
                    }
                } else {
                    OfflinePlayer offlineTarget = Bukkit.getOfflinePlayer((String)targetName);
                    try {
                        this.storageManager.addMail(offlineTarget.getUniqueId(), p.getName(), msg);
                        p.sendMessage((Component)Component.text((String)"Player is offline. Sent to mailbox.", (TextColor)NamedTextColor.GRAY));
                    }
                    catch (NoSuchMethodError | UnsupportedOperationException e) {
                        p.sendMessage((Component)Component.text((String)"Player is offline and mail could not be saved (storage not available).", (TextColor)NamedTextColor.RED));
                    }
                }
                return true;
            }
            case "r": {
                if (args.length < 1) {
                    p.sendMessage((Component)Component.text((String)"Usage: /r <message>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                UUID last = this.lastMessaged.get(pid);
                if (last == null) {
                    p.sendMessage((Component)Component.text((String)"No one to reply to.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player lastPlayer = Bukkit.getPlayer((UUID)last);
                String replyMsg = String.join((CharSequence)" ", args);
                if (lastPlayer != null && lastPlayer.isOnline()) {
                    Component comp = ((TextComponent)Component.text((String)"[Whisper] ", (TextColor)NamedTextColor.LIGHT_PURPLE).append((Component)Component.text((String)("[" + p.getName() + " -> " + lastPlayer.getName() + "]: "), (TextColor)NamedTextColor.LIGHT_PURPLE))).append((Component)Component.text((String)replyMsg, (TextColor)NamedTextColor.LIGHT_PURPLE));
                    if (!this.storageManager.isIgnored(lastPlayer.getUniqueId(), pid)) {
                        lastPlayer.sendMessage(comp);
                    }
                    p.sendMessage(comp);
                    this.lastMessaged.put(lastPlayer.getUniqueId(), pid);
                } else {
                    p.sendMessage((Component)Component.text((String)"The player you are replying to is offline.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "mail": {
                try {
                    List<String> mail = this.storageManager.getMail(pid);
                    if (mail == null || mail.isEmpty()) {
                        p.sendMessage((Component)Component.text((String)"You have no unread mail.", (TextColor)NamedTextColor.GRAY));
                    } else {
                        p.sendMessage((Component)Component.text((String)("You have " + mail.size() + " unread messages:"), (TextColor)NamedTextColor.GREEN));
                        for (String m : mail) {
                            try {
                                Component comp = this.plugin.miniMessage().deserialize((Object)m);
                                p.sendMessage(comp);
                            }
                            catch (Exception ex) {
                                p.sendMessage((Component)Component.text((String)m, (TextColor)NamedTextColor.WHITE));
                            }
                        }
                        this.storageManager.clearMail(pid);
                    }
                }
                catch (NoSuchMethodError | UnsupportedOperationException e) {
                    p.sendMessage((Component)Component.text((String)"Mail system unavailable.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "pinv": {
                Party party;
                if (args.length < 1) {
                    p.sendMessage((Component)Component.text((String)"Usage: /pinv <player>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player invitee = Bukkit.getPlayerExact((String)args[0]);
                if (invitee == null || !invitee.isOnline()) {
                    p.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Optional<Party> maybe = this.channelManager.getPartyForPlayer(pid);
                if (maybe.isPresent()) {
                    party = maybe.get();
                    if (!party.getLeader().equals(pid)) {
                        p.sendMessage((Component)Component.text((String)"Only party leaders can invite.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                } else {
                    Optional<Party> created = this.channelManager.createParty(pid);
                    if (!created.isPresent()) {
                        p.sendMessage((Component)Component.text((String)"Could not create party.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    party = created.get();
                }
                this.channelManager.putPendingInvite(invitee.getUniqueId(), party.getLeader());
                invitee.sendMessage((Component)Component.text((String)(p.getName() + " has invited you to a party! Type /p accept or /p deny"), (TextColor)NamedTextColor.GREEN));
                p.sendMessage((Component)Component.text((String)("Invite sent to " + invitee.getName()), (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "pleave": {
                boolean left = this.channelManager.leaveParty(pid);
                if (left) {
                    p.sendMessage((Component)Component.text((String)"You left your party.", (TextColor)NamedTextColor.GRAY));
                } else {
                    p.sendMessage((Component)Component.text((String)"You are not in a party.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "p": {
                if (args.length == 0) {
                    this.channelManager.setActiveChannel(pid, ChatChannel.PARTY);
                    p.sendMessage((Component)Component.text((String)"Switched to party chat.", (TextColor)NamedTextColor.BLUE));
                    return true;
                }
                String sub = args[0].toLowerCase();
                if (sub.equals("accept")) {
                    Optional<UUID> optLeader = this.channelManager.getPendingInviteLeader(pid);
                    if (!optLeader.isPresent()) {
                        p.sendMessage((Component)Component.text((String)"You have no pending party invites.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    UUID leaderId = optLeader.get();
                    boolean ok = this.channelManager.joinParty(leaderId, pid);
                    this.channelManager.removePendingInvite(pid);
                    if (ok) {
                        p.sendMessage((Component)Component.text((String)"You joined the party.", (TextColor)NamedTextColor.GREEN));
                        Player leader = Bukkit.getPlayer((UUID)leaderId);
                        if (leader != null && leader.isOnline()) {
                            leader.sendMessage((Component)Component.text((String)(p.getName() + " accepted your invite."), (TextColor)NamedTextColor.GREEN));
                        }
                    } else {
                        p.sendMessage((Component)Component.text((String)"Could not join the party (may be full or leader left).", (TextColor)NamedTextColor.RED));
                        Player leader = Bukkit.getPlayer((UUID)leaderId);
                        if (leader != null && leader.isOnline()) {
                            leader.sendMessage((Component)Component.text((String)(p.getName() + " could not join your party."), (TextColor)NamedTextColor.RED));
                        }
                    }
                    return true;
                }
                if (sub.equals("deny")) {
                    Optional<UUID> optLeader = this.channelManager.getPendingInviteLeader(pid);
                    if (!optLeader.isPresent()) {
                        p.sendMessage((Component)Component.text((String)"You have no pending party invites.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    UUID leaderId = optLeader.get();
                    this.channelManager.removePendingInvite(pid);
                    p.sendMessage((Component)Component.text((String)"You denied the party invite.", (TextColor)NamedTextColor.GRAY));
                    Player leader = Bukkit.getPlayer((UUID)leaderId);
                    if (leader != null && leader.isOnline()) {
                        leader.sendMessage((Component)Component.text((String)(p.getName() + " denied your invite."), (TextColor)NamedTextColor.GRAY));
                    }
                    return true;
                }
                Optional<Party> opt = this.channelManager.getPartyForPlayer(pid);
                if (!opt.isPresent()) {
                    p.sendMessage((Component)Component.text((String)"You are not in a party.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                String body = String.join((CharSequence)" ", args);
                Component comp = ((TextComponent)((TextComponent)Component.text((String)"[Party] ", (TextColor)NamedTextColor.BLUE).append((Component)Component.text((String)p.getName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)body, (TextColor)NamedTextColor.WHITE));
                this.channelManager.getPartyForPlayer(pid).ifPresent(party1 -> {
                    HashSet<UUID> rec = new HashSet<UUID>();
                    rec.add(party1.getLeader());
                    rec.addAll(party1.getMembers());
                    for (UUID u : rec) {
                        Player pl = Bukkit.getPlayer((UUID)u);
                        if (pl == null || !pl.isOnline()) continue;
                        pl.sendMessage(comp);
                    }
                });
                return true;
            }
            case "ignore": {
                if (args.length < 1) {
                    p.sendMessage((Component)Component.text((String)"Usage: /ignore <player>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player ig = Bukkit.getPlayerExact((String)args[0]);
                if (ig == null) {
                    p.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                try {
                    this.storageManager.addIgnore(pid, ig.getUniqueId());
                    p.sendMessage((Component)Component.text((String)("You are now ignoring " + ig.getName()), (TextColor)NamedTextColor.GRAY));
                }
                catch (NoSuchMethodError | UnsupportedOperationException e) {
                    p.sendMessage((Component)Component.text((String)"Ignore system unavailable.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "unignore": {
                if (args.length < 1) {
                    p.sendMessage((Component)Component.text((String)"Usage: /unignore <player>", (TextColor)NamedTextColor.RED));
                    return true;
                }
                Player uig = Bukkit.getPlayerExact((String)args[0]);
                if (uig == null) {
                    p.sendMessage((Component)Component.text((String)"Player not found.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                try {
                    this.storageManager.removeIgnore(pid, uig.getUniqueId());
                    p.sendMessage((Component)Component.text((String)("You no longer ignore " + uig.getName()), (TextColor)NamedTextColor.GRAY));
                }
                catch (NoSuchMethodError | UnsupportedOperationException e) {
                    p.sendMessage((Component)Component.text((String)"Ignore system unavailable.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "smartchat": 
            case "chat": {
                this.sendHelp(p);
                return true;
            }
            case "mention": {
                boolean enabled = this.filterManager.toggleMentions(pid);
                if (enabled) {
                    p.sendMessage((Component)Component.text((String)"Mention sounds enabled.", (TextColor)NamedTextColor.GREEN));
                } else {
                    p.sendMessage((Component)Component.text((String)"Mention sounds disabled.", (TextColor)NamedTextColor.RED));
                }
                return true;
            }
        }
        return false;
    }

    private void sendHelp(Player p) {
        p.sendMessage((Component)Component.text((String)"SmartChat Commands:", (TextColor)NamedTextColor.GOLD));
        p.sendMessage((Component)Component.text((String)"/s - Switch to proximity chat", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/g - Switch to global chat", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/t - Switch to trade chat", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/join global - Join global channel", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/leave global - Leave global channel", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/w <player> <msg> - Whisper to player", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/r <msg> - Reply to last whisper", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/mail - Check your mailbox", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/pinv <player> - Invite/add to party", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/pleave - Leave your party", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/p [message] - Party chat or switch", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/ignore <player> - Ignore a player", (TextColor)NamedTextColor.YELLOW));
        p.sendMessage((Component)Component.text((String)"/unignore <player> - Unignore a player", (TextColor)NamedTextColor.YELLOW));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if ((cmd.equals("w") || cmd.equals("pinv") || cmd.equals("ignore") || cmd.equals("unignore")) && args.length == 1) {
            String partial = args[0].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(partial)) continue;
                matches.add(p.getName());
            }
            return matches;
        }
        return Collections.emptyList();
    }
}

