/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.chat;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class Party {
    public static final int MAX_PLAYERS = 10;
    private final UUID leader;
    private final CopyOnWriteArrayList<UUID> members = new CopyOnWriteArrayList();

    public Party(UUID leader) {
        this.leader = leader;
    }

    public UUID getLeader() {
        return this.leader;
    }

    public List<UUID> getMembers() {
        return this.members;
    }

    public int sizeIncludingLeader() {
        return 1 + this.members.size();
    }

    public boolean isFull() {
        return this.sizeIncludingLeader() >= 10;
    }

    public boolean isEmpty() {
        return this.sizeIncludingLeader() == 0;
    }

    public boolean contains(UUID player) {
        if (player == null) {
            return false;
        }
        if (player.equals(this.leader)) {
            return true;
        }
        return this.members.contains(player);
    }

    public boolean addMember(UUID player) {
        if (player == null) {
            return false;
        }
        if (this.contains(player)) {
            return false;
        }
        if (this.isFull()) {
            return false;
        }
        return this.members.add(player);
    }

    public boolean removeMember(UUID player) {
        if (player == null) {
            return false;
        }
        return this.members.remove(player);
    }
}

