/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat.chat;

import com.smartchat.SmartChatPlugin;
import com.smartchat.chat.ChatChannel;
import com.smartchat.chat.Party;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class ChannelManager {
    private final SmartChatPlugin plugin;
    private final Map<UUID, ChatChannel> activeChannels = new ConcurrentHashMap<UUID, ChatChannel>();
    private final Set<UUID> globalOptIns = new CopyOnWriteArraySet<UUID>();
    private final Map<UUID, Party> partiesByLeader = new ConcurrentHashMap<UUID, Party>();
    private final Map<UUID, UUID> memberToLeader = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> pendingInvites = new ConcurrentHashMap<UUID, UUID>();

    public ChannelManager(SmartChatPlugin plugin) {
        this.plugin = plugin;
    }

    public ChatChannel getActiveChannel(UUID player) {
        return this.activeChannels.getOrDefault(player, ChatChannel.PROXIMITY);
    }

    public void setActiveChannel(UUID player, ChatChannel channel) {
        if (player == null || channel == null) {
            return;
        }
        this.activeChannels.put(player, channel);
    }

    public void clearActiveChannel(UUID player) {
        if (player == null) {
            return;
        }
        this.activeChannels.remove(player);
    }

    public boolean joinGlobal(UUID player) {
        if (player == null) {
            return false;
        }
        return this.globalOptIns.add(player);
    }

    public boolean leaveGlobal(UUID player) {
        if (player == null) {
            return false;
        }
        boolean removed = this.globalOptIns.remove(player);
        ChatChannel active = this.activeChannels.get(player);
        if (removed && active == ChatChannel.GLOBAL) {
            this.activeChannels.put(player, ChatChannel.PROXIMITY);
        }
        return removed;
    }

    public boolean isInGlobal(UUID player) {
        if (player == null) {
            return false;
        }
        return this.globalOptIns.contains(player);
    }

    public Optional<Party> createParty(UUID leader) {
        if (leader == null) {
            return Optional.empty();
        }
        Party existing = this.partiesByLeader.get(leader);
        if (existing != null) {
            return Optional.of(existing);
        }
        if (this.memberToLeader.containsKey(leader)) {
            return Optional.empty();
        }
        Party party = new Party(leader);
        this.partiesByLeader.put(leader, party);
        return Optional.of(party);
    }

    public Optional<Party> getPartyByLeader(UUID leader) {
        if (leader == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.partiesByLeader.get(leader));
    }

    public Optional<Party> getPartyForPlayer(UUID player) {
        if (player == null) {
            return Optional.empty();
        }
        Party asLeader = this.partiesByLeader.get(player);
        if (asLeader != null) {
            return Optional.of(asLeader);
        }
        UUID leader = this.memberToLeader.get(player);
        if (leader == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.partiesByLeader.get(leader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinParty(UUID leader, UUID player) {
        if (leader == null || player == null) {
            return false;
        }
        Party party = this.partiesByLeader.get(leader);
        if (party == null) {
            return false;
        }
        Party party2 = party;
        synchronized (party2) {
            if (party.isFull()) {
                return false;
            }
            boolean ok = party.addMember(player);
            if (ok) {
                this.memberToLeader.put(player, leader);
            }
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveParty(UUID player) {
        if (player == null) {
            return false;
        }
        Party leaderParty = this.partiesByLeader.get(player);
        if (leaderParty != null) {
            Party party = leaderParty;
            synchronized (party) {
                for (UUID m : leaderParty.getMembers()) {
                    this.memberToLeader.remove(m);
                }
                this.partiesByLeader.remove(player);
            }
            ChatChannel activeLeader = this.activeChannels.get(player);
            if (activeLeader == ChatChannel.PARTY) {
                this.activeChannels.put(player, ChatChannel.PROXIMITY);
            }
            return true;
        }
        UUID leader = this.memberToLeader.get(player);
        if (leader == null) {
            return false;
        }
        Party party = this.partiesByLeader.get(leader);
        if (party == null) {
            this.memberToLeader.remove(player);
            return false;
        }
        Party party2 = party;
        synchronized (party2) {
            boolean removed = party.removeMember(player);
            this.memberToLeader.remove(player);
            ChatChannel activeMember = this.activeChannels.get(player);
            if (activeMember == ChatChannel.PARTY) {
                this.activeChannels.put(player, ChatChannel.PROXIMITY);
            }
            if (party.sizeIncludingLeader() <= 1) {
                this.partiesByLeader.remove(leader);
                ChatChannel activeL = this.activeChannels.get(leader);
                if (activeL == ChatChannel.PARTY) {
                    this.activeChannels.put(leader, ChatChannel.PROXIMITY);
                }
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disbandParty(UUID leader) {
        if (leader == null) {
            return false;
        }
        Party party = this.partiesByLeader.get(leader);
        if (party == null) {
            return false;
        }
        Party party2 = party;
        synchronized (party2) {
            for (UUID m : party.getMembers()) {
                this.memberToLeader.remove(m);
            }
            this.partiesByLeader.remove(leader);
        }
        return true;
    }

    public void putPendingInvite(UUID invitee, UUID leader) {
        if (invitee == null || leader == null) {
            return;
        }
        this.pendingInvites.put(invitee, leader);
    }

    public Optional<UUID> getPendingInviteLeader(UUID invitee) {
        if (invitee == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.pendingInvites.get(invitee));
    }

    public void removePendingInvite(UUID invitee) {
        if (invitee == null) {
            return;
        }
        this.pendingInvites.remove(invitee);
    }

    public Optional<UUID> getLeaderForPlayer(UUID player) {
        if (player == null) {
            return Optional.empty();
        }
        if (this.partiesByLeader.containsKey(player)) {
            return Optional.of(player);
        }
        UUID leader = this.memberToLeader.get(player);
        return Optional.ofNullable(leader);
    }
}

