/*
 * Decompiled with CFR 0.152.
 */
package com.smartchat;

import com.smartchat.chat.ChannelManager;
import com.smartchat.commands.CommandManager;
import com.smartchat.interactive.ChatBubbleManager;
import com.smartchat.listener.ChatListener;
import com.smartchat.listener.PlayerJoinListener;
import com.smartchat.moderation.FilterManager;
import com.smartchat.storage.StorageManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SmartChatPlugin
extends JavaPlugin {
    private MiniMessage miniMessage;
    private StorageManager storageManager;
    private ChannelManager channelManager;
    private FilterManager filterManager;
    private ChatBubbleManager chatBubbleManager;

    public void onEnable() {
        String[] cmds;
        this.saveDefaultConfig();
        this.miniMessage = MiniMessage.miniMessage();
        this.getLogger().info("SmartChat v" + this.getDescription().getVersion() + " enabling...");
        this.storageManager = new StorageManager(this);
        this.channelManager = new ChannelManager(this);
        this.filterManager = new FilterManager(this);
        this.chatBubbleManager = new ChatBubbleManager(this);
        CommandManager cmdManager = new CommandManager(this, this.channelManager, this.storageManager, this.filterManager);
        for (String cmd : cmds = new String[]{"smartchat", "s", "g", "t", "w", "r", "mail", "p", "pinv", "pleave", "join", "leave", "ignore", "unignore", "mention"}) {
            PluginCommand c = this.getCommand(cmd);
            if (c == null) continue;
            c.setExecutor((CommandExecutor)cmdManager);
            c.setTabCompleter((TabCompleter)cmdManager);
        }
        ChatListener listener = new ChatListener(this, this.channelManager, this.filterManager, this.storageManager, this.chatBubbleManager);
        Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        PlayerJoinListener joinListener = new PlayerJoinListener(this, this.storageManager);
        Bukkit.getPluginManager().registerEvents((Listener)joinListener, (Plugin)this);
        this.getLogger().info("SmartChat enabled.");
    }

    public void onDisable() {
        this.getLogger().info("SmartChat disabling...");
        if (this.chatBubbleManager != null) {
            this.chatBubbleManager.shutdown();
        }
        if (this.storageManager != null) {
            this.storageManager.closeConnection();
        }
        this.getLogger().info("SmartChat disabled.");
    }

    public MiniMessage miniMessage() {
        return this.miniMessage;
    }
}

