/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.tasks;

import com.smartafk.SmartAFK;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AFKTasks {
    private final SmartAFK plugin;
    private int autoAfkTaskId;
    private int timerTaskId;
    private int kickTaskId;
    private final Set<UUID> warnedPlayers;

    public AFKTasks(SmartAFK plugin) {
        this.plugin = plugin;
        this.warnedPlayers = new HashSet<UUID>();
    }

    public void start() {
        this.startAutoAfkTask();
        this.startTimerTask();
        this.startKickTask();
    }

    public void stop() {
        Bukkit.getScheduler().cancelTask(this.autoAfkTaskId);
        Bukkit.getScheduler().cancelTask(this.timerTaskId);
        Bukkit.getScheduler().cancelTask(this.kickTaskId);
        this.warnedPlayers.clear();
    }

    private void startAutoAfkTask() {
        this.autoAfkTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (!this.plugin.getConfigManager().isAutoAfkEnabled()) {
                return;
            }
            int autoAfkTime = this.plugin.getConfigManager().getAutoAfkTime() * 60;
            int warningTime = this.plugin.getConfigManager().getAutoAfkWarningTime();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (this.plugin.getAfkManager().isAFK(player) || player.hasPermission("smartafk.bypass.auto")) continue;
                long idleSeconds = this.plugin.getAfkManager().getIdleTimeSeconds(player);
                if (this.plugin.getConfigManager().isAutoAfkWarning() && idleSeconds >= (long)(autoAfkTime - warningTime) && idleSeconds < (long)autoAfkTime && !this.warnedPlayers.contains(player.getUniqueId())) {
                    this.warnedPlayers.add(player.getUniqueId());
                    String message = this.plugin.getConfigManager().getMessage("afk-auto-warning").replace("%time%", String.valueOf(warningTime));
                    player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(message));
                }
                if (idleSeconds < (long)autoAfkTime) continue;
                this.warnedPlayers.remove(player.getUniqueId());
                this.plugin.getAfkManager().setAFK(player, true);
                player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getConfigManager().getMessage("afk-auto-activated")));
                if (!this.plugin.getConfigManager().isSpectatorMode()) continue;
                player.setGameMode(GameMode.SPECTATOR);
            }
        }, 20L, 20L);
    }

    private void startTimerTask() {
        this.timerTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (!this.plugin.getConfigManager().isTimerEnabled()) {
                return;
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.plugin.getAfkManager().isAFK(player)) continue;
                if (this.plugin.getConfigManager().isTimerInName()) {
                    this.plugin.getNameManager().updateTimerDisplay(player);
                }
                if (!this.plugin.getConfigManager().isTimerInActionbar()) continue;
                String duration = this.plugin.getAfkManager().getFormattedAFKDuration(player);
                TextComponent message = Component.text((String)("AFK: " + duration));
                player.sendActionBar((Component)message);
            }
        }, 20L, 20L);
    }

    private void startKickTask() {
        this.kickTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            int kickMinutes = this.plugin.getConfigManager().getKickAfterMinutes();
            if (kickMinutes <= 0) {
                return;
            }
            long kickMillis = (long)(kickMinutes * 60) * 1000L;
            for (Player player : Bukkit.getOnlinePlayers()) {
                long afkDuration;
                if (!this.plugin.getAfkManager().isAFK(player) || player.hasPermission("smartafk.bypass.kick") || (afkDuration = this.plugin.getAfkManager().getAFKDuration(player)) < kickMillis) continue;
                String kickMessage = this.plugin.getConfigManager().getMessage("kick-message");
                player.kick((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(kickMessage));
            }
        }, 600L, 600L);
    }

    public void clearWarning(Player player) {
        this.warnedPlayers.remove(player.getUniqueId());
    }
}

