/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.manager;

import com.smartafk.SmartAFK;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class NameManager {
    private final SmartAFK plugin;
    private final Map<UUID, Component> originalDisplayNames;
    private final Map<UUID, Component> originalPlayerListNames;
    private final Map<UUID, NamedTextColor> originalColors;
    private Scoreboard scoreboard;
    private Team afkTeam;

    public NameManager(SmartAFK plugin) {
        this.plugin = plugin;
        this.originalDisplayNames = new HashMap<UUID, Component>();
        this.originalPlayerListNames = new HashMap<UUID, Component>();
        this.originalColors = new HashMap<UUID, NamedTextColor>();
        this.initScoreboard();
    }

    private void initScoreboard() {
        this.scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        this.afkTeam = this.scoreboard.getTeam("smartafk_afk");
        if (this.afkTeam == null) {
            this.afkTeam = this.scoreboard.registerNewTeam("smartafk_afk");
        }
        this.afkTeam.color(NamedTextColor.GRAY);
    }

    public void applyAFKStyle(Player player) {
        UUID uuid = player.getUniqueId();
        this.originalDisplayNames.put(uuid, player.displayName());
        this.originalPlayerListNames.put(uuid, player.playerListName());
        String prefix = this.plugin.getConfigManager().getAfkPrefix();
        String color = this.plugin.getConfigManager().getAfkColor();
        boolean prefixEnabled = this.plugin.getConfigManager().isPrefixEnabled();
        TextComponent afkPrefix = LegacyComponentSerializer.legacyAmpersand().deserialize(prefix);
        TextComponent afkColor = LegacyComponentSerializer.legacyAmpersand().deserialize(color);
        Component originalName = player.displayName();
        if (prefixEnabled) {
            Component newDisplayName = ((TextComponent)((TextComponent)Component.empty().append((Component)afkPrefix)).append((Component)Component.space())).append(originalName);
            player.displayName(newDisplayName);
        }
        BuildableComponent playerListName = ((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(originalName)).build();
        player.playerListName((Component)playerListName);
        this.afkTeam.addEntry(player.getName());
        if (this.plugin.getConfigManager().isHideFromTab()) {
            player.setPlayerListName(null);
        }
    }

    public void removeAFKStyle(Player player) {
        Component originalPlayerListName;
        UUID uuid = player.getUniqueId();
        Component originalDisplayName = this.originalDisplayNames.remove(uuid);
        if (originalDisplayName != null) {
            player.displayName(originalDisplayName);
        }
        if ((originalPlayerListName = this.originalPlayerListNames.remove(uuid)) != null) {
            player.playerListName(originalPlayerListName);
        }
        this.afkTeam.removeEntry(player.getName());
    }

    public void updateTimerDisplay(Player player) {
        if (!this.plugin.getConfigManager().isTimerInName()) {
            return;
        }
        if (!this.plugin.getAfkManager().isAFK(player)) {
            return;
        }
        String duration = this.plugin.getAfkManager().getFormattedAFKDuration(player);
        String prefix = this.plugin.getConfigManager().getAfkPrefix();
        boolean prefixEnabled = this.plugin.getConfigManager().isPrefixEnabled();
        Component originalName = this.originalDisplayNames.getOrDefault(player.getUniqueId(), player.displayName());
        TextComponent afkPrefix = LegacyComponentSerializer.legacyAmpersand().deserialize(prefix);
        Component newDisplayName = prefixEnabled ? ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)afkPrefix)).append((Component)Component.space())).append(originalName)).append((Component)Component.space())).append((Component)Component.text((String)duration, (TextColor)NamedTextColor.GRAY)) : ((TextComponent)((TextComponent)Component.empty().append(originalName)).append((Component)Component.space())).append((Component)Component.text((String)duration, (TextColor)NamedTextColor.GRAY));
        player.displayName(newDisplayName);
    }

    public void broadcastAFK(Player player, boolean goingAFK) {
        if (!this.plugin.getConfigManager().isBroadcastEnabled()) {
            return;
        }
        String messageKey = goingAFK ? "broadcastAfkMessage" : "broadcastReturnMessage";
        String message = goingAFK ? this.plugin.getConfigManager().getBroadcastAfkMessage() : this.plugin.getConfigManager().getBroadcastReturnMessage();
        message = message.replace("%player%", player.getName());
        TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!this.plugin.getAfkManager().isNotifyEnabled(onlinePlayer)) continue;
            onlinePlayer.sendMessage((Component)component);
        }
    }

    public void restoreAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.plugin.getAfkManager().isAFK(player)) continue;
            this.removeAFKStyle(player);
        }
    }
}

