/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.manager;

import com.smartafk.SmartAFK;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class AFKManager {
    private final SmartAFK plugin;
    private final Map<UUID, AFKData> afkPlayers;
    private final Map<UUID, Long> lastActivity;
    private final Map<UUID, Long> lastToggle;
    private final Map<UUID, Boolean> notifyEnabled;
    private final Map<UUID, Boolean> silentMode;

    public AFKManager(SmartAFK plugin) {
        this.plugin = plugin;
        this.afkPlayers = new HashMap<UUID, AFKData>();
        this.lastActivity = new HashMap<UUID, Long>();
        this.lastToggle = new HashMap<UUID, Long>();
        this.notifyEnabled = new HashMap<UUID, Boolean>();
        this.silentMode = new HashMap<UUID, Boolean>();
    }

    public boolean isAFK(Player player) {
        return this.afkPlayers.containsKey(player.getUniqueId());
    }

    public void setAFK(Player player, boolean afk) {
        this.setAFK(player, afk, false);
    }

    public void setAFK(Player player, boolean afk, boolean silent) {
        UUID uuid = player.getUniqueId();
        if (afk) {
            if (!this.isAFK(player)) {
                this.afkPlayers.put(uuid, new AFKData(System.currentTimeMillis()));
                this.lastToggle.put(uuid, System.currentTimeMillis());
                this.plugin.getNameManager().applyAFKStyle(player);
                if (!silent && !this.isSilentMode(player)) {
                    this.plugin.getNameManager().broadcastAFK(player, true);
                }
            }
        } else if (this.isAFK(player)) {
            this.afkPlayers.remove(uuid);
            this.lastToggle.put(uuid, System.currentTimeMillis());
            this.plugin.getNameManager().removeAFKStyle(player);
            if (!silent && !this.isSilentMode(player)) {
                this.plugin.getNameManager().broadcastAFK(player, false);
            }
        }
    }

    public void toggleAFK(Player player) {
        this.toggleAFK(player, false);
    }

    public void toggleAFK(Player player, boolean silent) {
        this.setAFK(player, !this.isAFK(player), silent);
    }

    public long getAFKDuration(Player player) {
        AFKData data = this.afkPlayers.get(player.getUniqueId());
        if (data == null) {
            return 0L;
        }
        return System.currentTimeMillis() - data.getStartTime();
    }

    public String getFormattedAFKDuration(Player player) {
        long duration = this.getAFKDuration(player);
        return this.formatDuration(duration);
    }

    private String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String format = this.plugin.getConfigManager().getTimerFormat();
        if (format.equalsIgnoreCase("HH:MM:SS")) {
            return String.format("%02d:%02d:%02d", hours, minutes % 60L, seconds % 60L);
        }
        return String.format("%02d:%02d", minutes, seconds % 60L);
    }

    public void updateActivity(Player player) {
        this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public long getLastActivity(Player player) {
        return this.lastActivity.getOrDefault(player.getUniqueId(), System.currentTimeMillis());
    }

    public long getIdleTime(Player player) {
        return System.currentTimeMillis() - this.getLastActivity(player);
    }

    public long getIdleTimeSeconds(Player player) {
        return this.getIdleTime(player) / 1000L;
    }

    public boolean canToggle(Player player) {
        if (player.hasPermission("smartafk.cooldown.bypass")) {
            return true;
        }
        Long lastToggleTime = this.lastToggle.get(player.getUniqueId());
        if (lastToggleTime == null) {
            return true;
        }
        long cooldown = (long)this.plugin.getConfigManager().getAfkCooldown() * 1000L;
        return System.currentTimeMillis() - lastToggleTime >= cooldown;
    }

    public int getRemainingCooldown(Player player) {
        long elapsed;
        Long lastToggleTime = this.lastToggle.get(player.getUniqueId());
        if (lastToggleTime == null) {
            return 0;
        }
        long cooldown = (long)this.plugin.getConfigManager().getAfkCooldown() * 1000L;
        long remaining = cooldown - (elapsed = System.currentTimeMillis() - lastToggleTime);
        return remaining > 0L ? (int)(remaining / 1000L) : 0;
    }

    public boolean isNotifyEnabled(Player player) {
        return this.notifyEnabled.getOrDefault(player.getUniqueId(), true);
    }

    public void setNotifyEnabled(Player player, boolean enabled) {
        this.notifyEnabled.put(player.getUniqueId(), enabled);
    }

    public void toggleNotify(Player player) {
        this.setNotifyEnabled(player, !this.isNotifyEnabled(player));
    }

    public boolean isSilentMode(Player player) {
        return this.silentMode.getOrDefault(player.getUniqueId(), false);
    }

    public void setSilentMode(Player player, boolean silent) {
        this.silentMode.put(player.getUniqueId(), silent);
    }

    public void toggleSilentMode(Player player) {
        this.setSilentMode(player, !this.isSilentMode(player));
    }

    public void clearPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.afkPlayers.remove(uuid);
        this.lastActivity.remove(uuid);
        this.lastToggle.remove(uuid);
        this.notifyEnabled.remove(uuid);
        this.silentMode.remove(uuid);
    }

    private static class AFKData {
        private final long startTime;

        public AFKData(long startTime) {
            this.startTime = startTime;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

