/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.listeners;

import com.smartafk.SmartAFK;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerActivityListener
implements Listener {
    private final SmartAFK plugin;

    public PlayerActivityListener(SmartAFK plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getAfkManager().updateActivity(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().isRemoveOnChat() && this.plugin.getAfkManager().isAFK(player)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getAfkManager().setAFK(player, false));
        }
        this.plugin.getAfkManager().updateActivity(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase();
        if (command.startsWith("/afk") || command.startsWith("/away")) {
            return;
        }
        if (this.plugin.getConfigManager().isRemoveOnCommand() && this.plugin.getAfkManager().isAFK(player)) {
            this.plugin.getAfkManager().setAFK(player, false);
        }
        this.plugin.getAfkManager().updateActivity(player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().isRemoveOnInteract() && this.plugin.getAfkManager().isAFK(player)) {
            this.plugin.getAfkManager().setAFK(player, false);
        }
        this.plugin.getAfkManager().updateActivity(player);
    }
}

