/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.listeners;

import com.smartafk.SmartAFK;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class AFKListener
implements Listener {
    private final SmartAFK plugin;

    public AFKListener(SmartAFK plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getAfkManager().clearPlayer(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getX() == event.getTo().getX() && event.getFrom().getY() == event.getTo().getY() && event.getFrom().getZ() == event.getTo().getZ()) {
            return;
        }
        this.plugin.getAfkManager().updateActivity(player);
        if (!this.plugin.getAfkManager().isAFK(player)) {
            return;
        }
        if (this.plugin.getConfigManager().isFreezeEnabled() && !player.hasPermission("smartafk.bypass.freeze")) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getConfigManager().isRemoveOnMove()) {
            this.plugin.getAfkManager().setAFK(player, false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.plugin.getAfkManager().isAFK(player)) {
            return;
        }
        if (this.plugin.getConfigManager().isInvincibleEnabled() && !player.hasPermission("smartafk.bypass.invincible")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.plugin.getAfkManager().isAFK(player)) {
            return;
        }
        event.setCancelled(true);
    }
}

