/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.config;

import com.smartafk.SmartAFK;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SmartAFK plugin;
    private FileConfiguration config;
    private File configFile;
    private boolean afkEnabled;
    private int afkCooldown;
    private String afkPrefix;
    private String afkColor;
    private boolean prefixEnabled;
    private boolean autoAfkEnabled;
    private int autoAfkTime;
    private boolean autoAfkWarning;
    private int autoAfkWarningTime;
    private boolean broadcastEnabled;
    private boolean broadcastAfk;
    private boolean broadcastReturn;
    private String broadcastAfkMessage;
    private String broadcastReturnMessage;
    private boolean antiSpamEnabled;
    private int antiSpamDelay;
    private boolean timerEnabled;
    private String timerFormat;
    private boolean timerInName;
    private boolean timerInActionbar;
    private boolean removeOnMove;
    private boolean removeOnChat;
    private boolean removeOnCommand;
    private boolean removeOnInteract;
    private boolean freezeEnabled;
    private boolean invincibleEnabled;
    private boolean hideFromTab;
    private boolean spectatorMode;
    private int kickAfterMinutes;
    private boolean disableInCombat;
    private Map<String, String> messages;

    public ConfigManager(SmartAFK plugin) {
        this.plugin = plugin;
        this.messages = new HashMap<String, String>();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.afkEnabled = this.config.getBoolean("afk.enabled", true);
        this.afkCooldown = this.config.getInt("afk.cooldown", 3);
        this.afkPrefix = this.config.getString("afk.prefix", "&7[AFK]");
        this.afkColor = this.config.getString("afk.color", "&7");
        this.prefixEnabled = this.config.getBoolean("afk.prefix-enabled", true);
        this.autoAfkEnabled = this.config.getBoolean("auto-afk.enabled", true);
        this.autoAfkTime = this.config.getInt("auto-afk.time", 5);
        this.autoAfkWarning = this.config.getBoolean("auto-afk.warning.enabled", true);
        this.autoAfkWarningTime = this.config.getInt("auto-afk.warning.time", 30);
        this.broadcastEnabled = this.config.getBoolean("broadcast.enabled", true);
        this.broadcastAfk = this.config.getBoolean("broadcast.afk", true);
        this.broadcastReturn = this.config.getBoolean("broadcast.return", true);
        this.broadcastAfkMessage = this.config.getString("broadcast.afk-message", "&7%player% is now AFK.");
        this.broadcastReturnMessage = this.config.getString("broadcast.return-message", "&7%player% is no longer AFK.");
        this.antiSpamEnabled = this.config.getBoolean("broadcast.anti-spam.enabled", true);
        this.antiSpamDelay = this.config.getInt("broadcast.anti-spam.delay", 5);
        this.timerEnabled = this.config.getBoolean("timer.enabled", true);
        this.timerFormat = this.config.getString("timer.format", "MM:SS");
        this.timerInName = this.config.getBoolean("timer.show-in-name", false);
        this.timerInActionbar = this.config.getBoolean("timer.show-in-actionbar", true);
        this.removeOnMove = this.config.getBoolean("removal.move", true);
        this.removeOnChat = this.config.getBoolean("removal.chat", true);
        this.removeOnCommand = this.config.getBoolean("removal.command", true);
        this.removeOnInteract = this.config.getBoolean("removal.interact", true);
        this.freezeEnabled = this.config.getBoolean("protection.freeze", false);
        this.invincibleEnabled = this.config.getBoolean("protection.invincible", false);
        this.hideFromTab = this.config.getBoolean("protection.hide-from-tab", false);
        this.spectatorMode = this.config.getBoolean("protection.spectator-mode", false);
        this.kickAfterMinutes = this.config.getInt("protection.kick-after-minutes", 0);
        this.disableInCombat = this.config.getBoolean("protection.disable-in-combat", true);
        this.loadMessages();
    }

    private void loadMessages() {
        this.messages.put("afk-toggle-on", this.config.getString("messages.afk-toggle-on", "&7You are now AFK."));
        this.messages.put("afk-toggle-off", this.config.getString("messages.afk-toggle-off", "&7You are no longer AFK."));
        this.messages.put("afk-auto-warning", this.config.getString("messages.afk-auto-warning", "&cYou will be marked AFK in %time% seconds!"));
        this.messages.put("afk-auto-activated", this.config.getString("messages.afk-auto-activated", "&7You have been automatically marked as AFK."));
        this.messages.put("no-permission", this.config.getString("messages.no-permission", "&cYou don't have permission to do that."));
        this.messages.put("cooldown", this.config.getString("messages.cooldown", "&cPlease wait %time% seconds before toggling AFK again."));
        this.messages.put("player-not-found", this.config.getString("messages.player-not-found", "&cPlayer not found."));
        this.messages.put("config-reloaded", this.config.getString("messages.config-reloaded", "&aConfiguration reloaded successfully."));
        this.messages.put("notify-enabled", this.config.getString("messages.notify-enabled", "&aAFK notifications enabled."));
        this.messages.put("notify-disabled", this.config.getString("messages.notify-disabled", "&cAFK notifications disabled."));
        this.messages.put("silent-enabled", this.config.getString("messages.silent-enabled", "&7Silent AFK mode enabled."));
        this.messages.put("silent-disabled", this.config.getString("messages.silent-disabled", "&7Silent AFK mode disabled."));
        this.messages.put("time-format", this.config.getString("messages.time-format", "&7%player% has been AFK for %time%."));
        this.messages.put("kick-message", this.config.getString("messages.kick-message", "&cYou were kicked for being AFK too long."));
        this.messages.put("combat-blocked", this.config.getString("messages.combat-blocked", "&cYou cannot go AFK while in combat!"));
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.afkEnabled = this.config.getBoolean("afk.enabled", true);
        this.afkCooldown = this.config.getInt("afk.cooldown", 3);
        this.afkPrefix = this.config.getString("afk.prefix", "&7[AFK]");
        this.afkColor = this.config.getString("afk.color", "&7");
        this.prefixEnabled = this.config.getBoolean("afk.prefix-enabled", true);
        this.autoAfkEnabled = this.config.getBoolean("auto-afk.enabled", true);
        this.autoAfkTime = this.config.getInt("auto-afk.time", 5);
        this.autoAfkWarning = this.config.getBoolean("auto-afk.warning.enabled", true);
        this.autoAfkWarningTime = this.config.getInt("auto-afk.warning.time", 30);
        this.broadcastEnabled = this.config.getBoolean("broadcast.enabled", true);
        this.broadcastAfk = this.config.getBoolean("broadcast.afk", true);
        this.broadcastReturn = this.config.getBoolean("broadcast.return", true);
        this.broadcastAfkMessage = this.config.getString("broadcast.afk-message", "&7%player% is now AFK.");
        this.broadcastReturnMessage = this.config.getString("broadcast.return-message", "&7%player% is no longer AFK.");
        this.antiSpamEnabled = this.config.getBoolean("broadcast.anti-spam.enabled", true);
        this.antiSpamDelay = this.config.getInt("broadcast.anti-spam.delay", 5);
        this.timerEnabled = this.config.getBoolean("timer.enabled", true);
        this.timerFormat = this.config.getString("timer.format", "MM:SS");
        this.timerInName = this.config.getBoolean("timer.show-in-name", false);
        this.timerInActionbar = this.config.getBoolean("timer.show-in-actionbar", true);
        this.removeOnMove = this.config.getBoolean("removal.move", true);
        this.removeOnChat = this.config.getBoolean("removal.chat", true);
        this.removeOnCommand = this.config.getBoolean("removal.command", true);
        this.removeOnInteract = this.config.getBoolean("removal.interact", true);
        this.freezeEnabled = this.config.getBoolean("protection.freeze", false);
        this.invincibleEnabled = this.config.getBoolean("protection.invincible", false);
        this.hideFromTab = this.config.getBoolean("protection.hide-from-tab", false);
        this.spectatorMode = this.config.getBoolean("protection.spectator-mode", false);
        this.kickAfterMinutes = this.config.getInt("protection.kick-after-minutes", 0);
        this.disableInCombat = this.config.getBoolean("protection.disable-in-combat", true);
        this.loadMessages();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config: " + e.getMessage());
        }
    }

    public boolean isAfkEnabled() {
        return this.afkEnabled;
    }

    public int getAfkCooldown() {
        return this.afkCooldown;
    }

    public String getAfkPrefix() {
        return this.afkPrefix;
    }

    public String getAfkColor() {
        return this.afkColor;
    }

    public boolean isPrefixEnabled() {
        return this.prefixEnabled;
    }

    public boolean isAutoAfkEnabled() {
        return this.autoAfkEnabled;
    }

    public int getAutoAfkTime() {
        return this.autoAfkTime;
    }

    public boolean isAutoAfkWarning() {
        return this.autoAfkWarning;
    }

    public int getAutoAfkWarningTime() {
        return this.autoAfkWarningTime;
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastEnabled;
    }

    public boolean isBroadcastAfk() {
        return this.broadcastAfk;
    }

    public boolean isBroadcastReturn() {
        return this.broadcastReturn;
    }

    public String getBroadcastAfkMessage() {
        return this.broadcastAfkMessage;
    }

    public String getBroadcastReturnMessage() {
        return this.broadcastReturnMessage;
    }

    public boolean isAntiSpamEnabled() {
        return this.antiSpamEnabled;
    }

    public int getAntiSpamDelay() {
        return this.antiSpamDelay;
    }

    public boolean isTimerEnabled() {
        return this.timerEnabled;
    }

    public String getTimerFormat() {
        return this.timerFormat;
    }

    public boolean isTimerInName() {
        return this.timerInName;
    }

    public boolean isTimerInActionbar() {
        return this.timerInActionbar;
    }

    public boolean isRemoveOnMove() {
        return this.removeOnMove;
    }

    public boolean isRemoveOnChat() {
        return this.removeOnChat;
    }

    public boolean isRemoveOnCommand() {
        return this.removeOnCommand;
    }

    public boolean isRemoveOnInteract() {
        return this.removeOnInteract;
    }

    public boolean isFreezeEnabled() {
        return this.freezeEnabled;
    }

    public boolean isInvincibleEnabled() {
        return this.invincibleEnabled;
    }

    public boolean isHideFromTab() {
        return this.hideFromTab;
    }

    public boolean isSpectatorMode() {
        return this.spectatorMode;
    }

    public int getKickAfterMinutes() {
        return this.kickAfterMinutes;
    }

    public boolean isDisableInCombat() {
        return this.disableInCombat;
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, "&cMessage not found: " + key);
    }

    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

