/*
 * Decompiled with CFR 0.152.
 */
package com.smartafk.commands;

import com.smartafk.SmartAFK;
import com.smartafk.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AFKCommand
implements CommandExecutor,
TabCompleter {
    private final SmartAFK plugin;
    private final ConfigManager config;

    public AFKCommand(SmartAFK plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            return this.handleReload(sender);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("time")) {
            return this.handleTime(sender, args);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("notify")) {
            return this.handleNotify(sender);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("silent")) {
            return this.handleSilent(sender);
        }
        if (args.length > 0 && sender.hasPermission("smartafk.afk.others")) {
            return this.handleOtherPlayer(sender, args[0]);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        Player player = (Player)sender;
        return this.handleSelfToggle(player);
    }

    private boolean handleSelfToggle(Player player) {
        if (!player.hasPermission("smartafk.afk")) {
            player.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        if (!this.plugin.getAfkManager().canToggle(player)) {
            int remaining = this.plugin.getAfkManager().getRemainingCooldown(player);
            String message = this.config.getMessage("cooldown").replace("%time%", String.valueOf(remaining));
            player.sendMessage(this.config.colorize(message));
            return true;
        }
        boolean wasAFK = this.plugin.getAfkManager().isAFK(player);
        this.plugin.getAfkManager().toggleAFK(player);
        String messageKey = wasAFK ? "afk-toggle-off" : "afk-toggle-on";
        player.sendMessage(this.config.colorize(this.config.getMessage(messageKey)));
        return true;
    }

    private boolean handleOtherPlayer(CommandSender sender, String targetName) {
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("player-not-found")));
            return true;
        }
        boolean wasAFK = this.plugin.getAfkManager().isAFK(target);
        this.plugin.getAfkManager().toggleAFK(target);
        String status = wasAFK ? "no longer" : "now";
        sender.sendMessage(this.config.colorize("&7" + target.getName() + " is " + status + " AFK."));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("smartafk.reload")) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        this.plugin.getConfigManager().reloadConfig();
        sender.sendMessage(this.config.colorize(this.config.getMessage("config-reloaded")));
        return true;
    }

    private boolean handleTime(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("smartafk.time")) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        if (args.length > 1) {
            if (!sender.hasPermission("smartafk.time.others")) {
                sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
                return true;
            }
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                sender.sendMessage(this.config.colorize(this.config.getMessage("player-not-found")));
                return true;
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.config.colorize("&cUsage: /afk time <player>"));
                return true;
            }
            Player player = (Player)sender;
            target = (Player)sender;
        }
        if (!this.plugin.getAfkManager().isAFK(target)) {
            sender.sendMessage(this.config.colorize("&7" + target.getName() + " is not AFK."));
            return true;
        }
        String duration = this.plugin.getAfkManager().getFormattedAFKDuration(target);
        String message = this.config.getMessage("time-format").replace("%player%", target.getName()).replace("%time%", duration);
        sender.sendMessage(this.config.colorize(message));
        return true;
    }

    private boolean handleNotify(CommandSender sender) {
        if (!sender.hasPermission("smartafk.notify")) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.config.colorize("&cThis command can only be used by players."));
            return true;
        }
        Player player = (Player)sender;
        this.plugin.getAfkManager().toggleNotify(player);
        boolean enabled = this.plugin.getAfkManager().isNotifyEnabled(player);
        String message = enabled ? this.config.getMessage("notify-enabled") : this.config.getMessage("notify-disabled");
        player.sendMessage(this.config.colorize(message));
        return true;
    }

    private boolean handleSilent(CommandSender sender) {
        if (!sender.hasPermission("smartafk.silent")) {
            sender.sendMessage(this.config.colorize(this.config.getMessage("no-permission")));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.config.colorize("&cThis command can only be used by players."));
            return true;
        }
        Player player = (Player)sender;
        this.plugin.getAfkManager().toggleSilentMode(player);
        boolean enabled = this.plugin.getAfkManager().isSilentMode(player);
        String message = enabled ? this.config.getMessage("silent-enabled") : this.config.getMessage("silent-disabled");
        player.sendMessage(this.config.colorize(message));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block9: {
            block8: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block8;
                ArrayList<String> subcommands = new ArrayList<String>();
                if (sender.hasPermission("smartafk.reload")) {
                    subcommands.add("reload");
                }
                if (sender.hasPermission("smartafk.time")) {
                    subcommands.add("time");
                }
                if (sender.hasPermission("smartafk.notify")) {
                    subcommands.add("notify");
                }
                if (sender.hasPermission("smartafk.silent")) {
                    subcommands.add("silent");
                }
                if (sender.hasPermission("smartafk.afk.others")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        subcommands.add(player.getName());
                    }
                }
                for (String sub : subcommands) {
                    if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    completions.add(sub);
                }
                break block9;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("time") || !sender.hasPermission("smartafk.time.others")) break block9;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(player.getName());
            }
        }
        return completions;
    }
}

