/*
 * Decompiled with CFR 0.152.
 */
package com.example.sharedtrades;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.java.JavaPlugin;

public class TradeListener
implements Listener {
    private final JavaPlugin plugin;
    private final Set<UUID> curedVillagers = new HashSet<UUID>();
    private final File dataFile;
    private final FileConfiguration dataConfig;
    private final int discount = 1;

    public TradeListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "cured_villagers.yml");
        if (!this.dataFile.exists()) {
            this.dataFile.getParentFile().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        List list = this.dataConfig.getStringList("cured");
        for (String uuid : list) {
            this.curedVillagers.add(UUID.fromString(uuid));
        }
    }

    private void saveCuredVillagers() {
        ArrayList<String> list = new ArrayList<String>();
        for (UUID uuid : this.curedVillagers) {
            list.add(uuid.toString());
        }
        this.dataConfig.set("cured", list);
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onVillagerCured(EntityTransformEvent event) {
        Entity entity;
        if (event.getEntityType() == EntityType.ZOMBIE_VILLAGER && (entity = event.getTransformedEntity()) instanceof Villager) {
            Villager villager = (Villager)entity;
            this.curedVillagers.add(villager.getUniqueId());
            this.saveCuredVillagers();
            this.applyDiscountToAllRecipes(villager);
        }
    }

    @EventHandler
    public void onVillagerAcquireTrade(VillagerAcquireTradeEvent event) {
        Villager villager = (Villager)event.getEntity();
        if (!this.curedVillagers.contains(villager.getUniqueId())) {
            return;
        }
        this.applyDiscountToRecipe(event.getRecipe());
        event.setRecipe(event.getRecipe());
        this.applyDiscountToAllRecipes(villager);
    }

    @EventHandler
    public void onPlayerTradeInteract(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (!this.curedVillagers.contains(villager.getUniqueId())) {
            return;
        }
        this.applyDiscountToAllRecipes(villager);
    }

    private void applyDiscountToRecipe(MerchantRecipe recipe) {
        recipe.setSpecialPrice(-1);
    }

    private void applyDiscountToAllRecipes(Villager villager) {
        ArrayList recipes = new ArrayList(villager.getRecipes());
        for (MerchantRecipe recipe : recipes) {
            this.applyDiscountToRecipe(recipe);
        }
        villager.setRecipes(recipes);
    }
}

