/*
 * Decompiled with CFR 0.152.
 */
package com.example.openenderchest;

import com.example.openenderchest.OpenEnder;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EnderChestListener
implements Listener {
    private final OpenEnder plugin;
    private final Set<Player> openEnders = new HashSet<Player>();

    public EnderChestListener(OpenEnder plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getHotbarButton() != -1 && this.openEnders.contains(player)) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() != player.getInventory()) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() != Material.ENDER_CHEST) {
            return;
        }
        if (event.getHotbarButton() != -1) {
            if (event.isRightClick()) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (event.isShiftClick()) {
            event.setCancelled(true);
            return;
        }
        if (event.isRightClick()) {
            event.setCancelled(true);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                player.setItemOnCursor(null);
                player.updateInventory();
                player.openInventory(player.getEnderChest());
                this.openEnders.add(player);
            });
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.openEnders.contains(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (event.getInventory() == player.getEnderChest() && this.openEnders.contains(player)) {
            this.openEnders.remove(player);
        }
    }
}

