/*
 * Decompiled with CFR 0.152.
 */
package com.example.mycoords;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MyCoords
extends JavaPlugin {
    private boolean enabled;
    private boolean prefix;
    private int decimals;
    private String color;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
    }

    public void onDisable() {
    }

    private void loadConfig() {
        this.enabled = this.getConfig().getBoolean("enabled", true);
        this.prefix = this.getConfig().getBoolean("prefix", true);
        this.decimals = this.getConfig().getInt("decimals", 2);
        this.color = this.getConfig().getString("color", "white");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("c")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            if (args.length == 0) {
                if (!this.enabled) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "MyCoords is disabled.");
                    return true;
                }
                double x = player.getLocation().getX();
                double y = player.getLocation().getY();
                double z = player.getLocation().getZ();
                String formattedX = String.format("%." + this.decimals + "f", x);
                String formattedY = String.format("%." + this.decimals + "f", y);
                String formattedZ = String.format("%." + this.decimals + "f", z);
                String coords = this.prefix ? "x:" + formattedX + " y:" + formattedY + " z:" + formattedZ : formattedX + " " + formattedY + " " + formattedZ;
                String message = "I am at " + coords;
                ChatColor chatColor = ChatColor.valueOf((String)this.color.toUpperCase());
                this.getServer().broadcastMessage(String.valueOf(chatColor) + player.getName() + ": " + message);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("toggle")) {
                    this.enabled = !this.enabled;
                    this.getConfig().set("enabled", (Object)this.enabled);
                    this.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "MyCoords " + (this.enabled ? "enabled" : "disabled"));
                    return true;
                }
                if (args[0].equalsIgnoreCase("prefix")) {
                    this.prefix = !this.prefix;
                    this.getConfig().set("prefix", (Object)this.prefix);
                    this.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Prefix " + (this.prefix ? "enabled" : "disabled"));
                    return true;
                }
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("decimals")) {
                    try {
                        int newDecimals = Integer.parseInt(args[1]);
                        if (newDecimals < 0 || newDecimals > 10) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Decimals must be between 0 and 10.");
                            return true;
                        }
                        this.decimals = newDecimals;
                        this.getConfig().set("decimals", (Object)this.decimals);
                        this.saveConfig();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Decimals set to " + this.decimals);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number for decimals.");
                        return true;
                    }
                }
                if (args[0].equalsIgnoreCase("color")) {
                    try {
                        ChatColor.valueOf((String)args[1].toUpperCase());
                        this.color = args[1].toLowerCase();
                        this.getConfig().set("color", (Object)this.color);
                        this.saveConfig();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Color set to " + this.color);
                        return true;
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Available colors: " + String.join((CharSequence)", ", this.getAvailableColors()));
                        return true;
                    }
                }
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /c [toggle|prefix|decimals <number>|color <color>]");
            return true;
        }
        return false;
    }

    private String[] getAvailableColors() {
        ChatColor[] colors = ChatColor.values();
        String[] colorNames = new String[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colorNames[i] = colors[i].name().toLowerCase();
        }
        return colorNames;
    }
}

