/*
 * Decompiled with CFR 0.152.
 */
package com.example.mendinginfinityfix;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MendingInfinityFix
extends JavaPlugin
implements Listener {
    private boolean useReflection = true;

    public void onEnable() {
        try {
            this.removeEnchantmentConflict();
            this.getLogger().info("Successfully removed Mending-Infinity conflict using reflection!");
        }
        catch (Exception e) {
            this.getLogger().warning("Could not use reflection to modify enchantments. Using event-based approach.");
            this.getLogger().warning("Error: " + e.getMessage());
            this.useReflection = false;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("MendingInfinityFix has been enabled! Bows can now have both Mending and Infinity.");
    }

    public void onDisable() {
        this.getLogger().info("MendingInfinityFix has been disabled.");
    }

    private void removeEnchantmentConflict() throws Exception {
        String[] possibleFieldNames;
        Field conflictsField = null;
        for (String fieldName : possibleFieldNames = new String[]{"conflicts", "conflictsWith"}) {
            try {
                conflictsField = Enchantment.class.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        if (conflictsField != null) {
            conflictsField.setAccessible(true);
            Enchantment mending = Enchantment.MENDING;
            Enchantment infinity = Enchantment.INFINITY;
            if (mending != null && infinity != null) {
                Object mendingConflicts = conflictsField.get(mending);
                Object infinityConflicts = conflictsField.get(infinity);
                if (mendingConflicts instanceof Set) {
                    ((Set)mendingConflicts).remove(infinity);
                    ((Set)infinityConflicts).remove(mending);
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("givemendinginfinity")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cThis command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            ItemStack bow = new ItemStack(Material.BOW);
            ItemMeta meta = bow.getItemMeta();
            if (meta != null) {
                meta.addEnchant(Enchantment.MENDING, 1, true);
                meta.addEnchant(Enchantment.INFINITY, 1, true);
                meta.setDisplayName("\u00a76Bow of Eternity");
                bow.setItemMeta(meta);
            }
            player.getInventory().addItem(new ItemStack[]{bow});
            player.sendMessage("\u00a7aYou have been given a bow with both Mending and Infinity!");
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onAnvilPrepare(PrepareAnvilEvent event) {
        ItemMeta rightMeta;
        boolean rightIsBook;
        ItemStack left = event.getInventory().getItem(0);
        ItemStack right = event.getInventory().getItem(1);
        if (left == null || right == null) {
            return;
        }
        boolean leftIsBow = left.getType() == Material.BOW;
        boolean rightIsBow = right.getType() == Material.BOW;
        boolean bl = rightIsBook = right.getType() == Material.ENCHANTED_BOOK;
        if (!leftIsBow && !rightIsBow) {
            return;
        }
        boolean hasMending = false;
        boolean hasInfinity = false;
        HashMap<Enchantment, Integer> allEnchants = new HashMap<Enchantment, Integer>();
        ItemMeta leftMeta = left.getItemMeta();
        if (leftMeta != null) {
            if (leftMeta.hasEnchant(Enchantment.MENDING)) {
                hasMending = true;
                allEnchants.put(Enchantment.MENDING, leftMeta.getEnchantLevel(Enchantment.MENDING));
            }
            if (leftMeta.hasEnchant(Enchantment.INFINITY)) {
                hasInfinity = true;
                allEnchants.put(Enchantment.INFINITY, leftMeta.getEnchantLevel(Enchantment.INFINITY));
            }
            for (Map.Entry entry : leftMeta.getEnchants().entrySet()) {
                allEnchants.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
            }
        }
        if ((rightMeta = right.getItemMeta()) != null) {
            Map rightEnchants = new HashMap();
            if (rightIsBook && rightMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta bookMeta = (EnchantmentStorageMeta)rightMeta;
                rightEnchants = bookMeta.getStoredEnchants();
            } else {
                rightEnchants = rightMeta.getEnchants();
            }
            for (Map.Entry entry : rightEnchants.entrySet()) {
                if (((Enchantment)entry.getKey()).equals(Enchantment.MENDING)) {
                    hasMending = true;
                }
                if (((Enchantment)entry.getKey()).equals(Enchantment.INFINITY)) {
                    hasInfinity = true;
                }
                int currentLevel = allEnchants.getOrDefault(entry.getKey(), 0);
                allEnchants.put((Enchantment)entry.getKey(), Math.max(currentLevel, (Integer)entry.getValue()));
            }
        }
        if (hasMending && hasInfinity) {
            ItemMeta resultMeta;
            ItemStack result = new ItemStack(Material.BOW);
            if (leftIsBow) {
                result.setDurability(left.getDurability());
            }
            if ((resultMeta = result.getItemMeta()) != null) {
                for (Map.Entry entry : allEnchants.entrySet()) {
                    resultMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                }
                if (!resultMeta.hasEnchant(Enchantment.MENDING)) {
                    resultMeta.addEnchant(Enchantment.MENDING, 1, true);
                }
                if (!resultMeta.hasEnchant(Enchantment.INFINITY)) {
                    resultMeta.addEnchant(Enchantment.INFINITY, 1, true);
                }
                result.setItemMeta(resultMeta);
            }
            event.setResult(result);
            event.getInventory().setRepairCost(1);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAnvilClick(InventoryClickEvent event) {
        ItemMeta resultMeta;
        ItemMeta rightMeta;
        if (!(event.getInventory() instanceof AnvilInventory)) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        AnvilInventory anvil = (AnvilInventory)event.getInventory();
        ItemStack left = anvil.getItem(0);
        ItemStack right = anvil.getItem(1);
        if (left == null || right == null) {
            return;
        }
        boolean hasMending = false;
        boolean hasInfinity = false;
        ItemMeta leftMeta = left.getItemMeta();
        if (leftMeta != null) {
            hasMending |= leftMeta.hasEnchant(Enchantment.MENDING);
            hasInfinity |= leftMeta.hasEnchant(Enchantment.INFINITY);
        }
        if ((rightMeta = right.getItemMeta()) != null) {
            Map rightEnchants = rightMeta instanceof EnchantmentStorageMeta ? ((EnchantmentStorageMeta)rightMeta).getStoredEnchants() : rightMeta.getEnchants();
            hasMending |= rightEnchants.containsKey(Enchantment.MENDING);
            hasInfinity |= rightEnchants.containsKey(Enchantment.INFINITY);
        }
        if (!hasMending || !hasInfinity) {
            return;
        }
        event.setCancelled(true);
        ItemStack result = new ItemStack(Material.BOW);
        if (left.getType() == Material.BOW) {
            result.setDurability(left.getDurability());
        }
        if ((resultMeta = result.getItemMeta()) != null) {
            HashMap<Enchantment, Integer> allEnchants = new HashMap<Enchantment, Integer>();
            if (leftMeta != null) {
                allEnchants.putAll(leftMeta.getEnchants());
            }
            if (rightMeta != null) {
                Map rightEnchants = rightMeta instanceof EnchantmentStorageMeta ? ((EnchantmentStorageMeta)rightMeta).getStoredEnchants() : rightMeta.getEnchants();
                for (Map.Entry entry : rightEnchants.entrySet()) {
                    int currentLevel = allEnchants.getOrDefault(entry.getKey(), 0);
                    allEnchants.put((Enchantment)entry.getKey(), Math.max(currentLevel, (Integer)entry.getValue()));
                }
            }
            for (Map.Entry entry : allEnchants.entrySet()) {
                resultMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            result.setItemMeta(resultMeta);
        }
        Player player = (Player)event.getWhoClicked();
        if (event.isShiftClick()) {
            player.getInventory().addItem(new ItemStack[]{result});
        } else {
            player.setItemOnCursor(result);
        }
        left.setAmount(left.getAmount() - 1);
        if (right.getType() == Material.ENCHANTED_BOOK) {
            right.setAmount(right.getAmount() - 1);
        } else if (right.getType() == Material.BOW) {
            right.setAmount(right.getAmount() - 1);
        }
        anvil.setItem(2, null);
        int repairCost = anvil.getRepairCost();
        if (player.getLevel() >= repairCost) {
            player.setLevel(player.getLevel() - repairCost);
        } else {
            player.setExp(0.0f);
        }
        player.updateInventory();
    }
}

