/*
 * Decompiled with CFR 0.152.
 */
package com.example.deathbeacon;

import com.example.deathbeacon.DeathBeacon;
import com.example.deathbeacon.DeathBeaconManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathListener
implements Listener {
    private final DeathBeacon plugin;
    private final DeathBeaconManager deathBeaconManager;

    public DeathListener(DeathBeacon plugin, DeathBeaconManager deathBeaconManager) {
        this.plugin = plugin;
        this.deathBeaconManager = deathBeaconManager;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        boolean global = this.plugin.getConfig().getBoolean("death-message.global");
        boolean prefix = this.plugin.getConfig().getBoolean("death-message.prefix");
        String deathLocation = prefix ? "X: " + player.getLocation().getBlockX() + " Y: " + player.getLocation().getBlockY() + " Z: " + player.getLocation().getBlockZ() : String.valueOf(player.getLocation().getBlockX()) + " " + player.getLocation().getBlockY() + " " + player.getLocation().getBlockZ();
        if (global) {
            event.setDeathMessage(String.valueOf(player.getName()) + " died at " + deathLocation);
        } else {
            player.sendMessage("You died at " + deathLocation);
        }
        this.deathBeaconManager.createBossBar(player);
        this.deathBeaconManager.createBeacon(player, event.getDrops());
    }
}

