/*
 * Decompiled with CFR 0.152.
 */
package com.example.deathbeacon;

import com.example.deathbeacon.DeathBeacon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DeathBeaconManager {
    private final DeathBeacon plugin;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Map<UUID, Integer> timers = new HashMap<UUID, Integer>();
    private final Map<UUID, BukkitTask> timerTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, BukkitTask> particleTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, List<DeathSession>> activeDeaths = new HashMap<UUID, List<DeathSession>>();

    public DeathBeaconManager(DeathBeacon plugin) {
        this.plugin = plugin;
    }

    public void createBeacon(Player player, List<ItemStack> drops) {
        if (drops == null || drops.isEmpty()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("death-beacon.enabled")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        List sessions = this.activeDeaths.computeIfAbsent(uuid, k -> new ArrayList());
        for (DeathSession session : sessions) {
            session.isLatest = false;
        }
        sessions.add(new DeathSession(player.getLocation(), drops, true));
        this.startParticleTask(player);
        this.createBossBar(player);
    }

    public void createBossBar(Player player) {
        BarColor barColor;
        this.stopTimer(player.getUniqueId());
        int duration = this.plugin.getConfig().getInt("boss-bar.duration", 300);
        String color = this.plugin.getConfig().getString("boss-bar.color", "RED");
        try {
            barColor = BarColor.valueOf((String)color.toUpperCase());
        }
        catch (Exception e) {
            barColor = BarColor.RED;
        }
        if (this.bossBars.containsKey(player.getUniqueId())) {
            this.bossBars.get(player.getUniqueId()).removeAll();
        }
        BossBar bossBar = Bukkit.createBossBar((String)("Your items will despawn in " + this.formatTime(duration)), (BarColor)barColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.setProgress(1.0);
        bossBar.addPlayer(player);
        this.bossBars.put(player.getUniqueId(), bossBar);
        this.timers.put(player.getUniqueId(), duration);
        this.startTimer(player.getUniqueId());
    }

    public BossBar getBossBar(UUID uuid) {
        return this.bossBars.get(uuid);
    }

    private void startTimer(final UUID playerId) {
        final int maxDuration = this.plugin.getConfig().getInt("boss-bar.duration", 300);
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                Integer currentDuration = (Integer)DeathBeaconManager.this.timers.get(playerId);
                if (currentDuration == null) {
                    this.cancel();
                    DeathBeaconManager.this.timerTasks.remove(playerId);
                    return;
                }
                if ((currentDuration = Integer.valueOf(currentDuration - 1)) <= 0) {
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player != null) {
                        DeathBeaconManager.this.removeLatestDeath(player);
                    } else {
                        DeathBeaconManager.this.removeBossBarOffline(playerId);
                        DeathBeaconManager.this.removeLatestDeathOffline(playerId);
                    }
                    this.cancel();
                    DeathBeaconManager.this.timerTasks.remove(playerId);
                } else {
                    BossBar bossBar = (BossBar)DeathBeaconManager.this.bossBars.get(playerId);
                    if (bossBar != null) {
                        bossBar.setTitle("Your items will despawn in " + DeathBeaconManager.this.formatTime(currentDuration));
                        double progress = (double)currentDuration.intValue() / (double)maxDuration;
                        bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                        DeathBeaconManager.this.timers.put(playerId, currentDuration);
                    } else {
                        this.cancel();
                        DeathBeaconManager.this.timerTasks.remove(playerId);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.timerTasks.put(playerId, task);
    }

    private void stopTimer(UUID uuid) {
        if (this.timerTasks.containsKey(uuid)) {
            this.timerTasks.get(uuid).cancel();
            this.timerTasks.remove(uuid);
        }
    }

    private void startParticleTask(Player player) {
        final UUID uuid = player.getUniqueId();
        if (this.particleTasks.containsKey(uuid)) {
            return;
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                List sessions = (List)DeathBeaconManager.this.activeDeaths.get(uuid);
                if (sessions == null || sessions.isEmpty()) {
                    DeathBeaconManager.this.particleTasks.remove(uuid);
                    this.cancel();
                    return;
                }
                String colorName = DeathBeaconManager.this.plugin.getConfig().getString("death-beacon.color", "RED");
                Color particleColor = DeathBeaconManager.this.getParticleColor(colorName);
                Particle.DustOptions dustOptions = new Particle.DustOptions(particleColor, 2.0f);
                int i = 0;
                while (i < sessions.size()) {
                    DeathSession session = (DeathSession)sessions.get(i);
                    Location loc = session.location;
                    if (loc != null && loc.getWorld() != null) {
                        int maxY = loc.getWorld().getMaxHeight();
                        double startY = loc.getY();
                        double yOffset = 0.0;
                        while (startY + yOffset < (double)maxY) {
                            Location beamLocation = loc.clone().add(0.0, yOffset, 0.0);
                            loc.getWorld().spawnParticle(Particle.DUST, beamLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                            yOffset += 0.5;
                        }
                    }
                    ++i;
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        this.particleTasks.put(uuid, task);
    }

    public void handleItemPickup(Player player, Item itemEntity) {
        UUID uuid = player.getUniqueId();
        List<DeathSession> sessions = this.activeDeaths.get(uuid);
        if (sessions == null || sessions.isEmpty()) {
            return;
        }
        ItemStack pickedItem = itemEntity.getItemStack();
        Location itemLoc = itemEntity.getLocation();
        Iterator<DeathSession> it = sessions.iterator();
        while (it.hasNext()) {
            DeathSession session = it.next();
            if (!session.location.getWorld().getUID().equals(itemLoc.getWorld().getUID()) || session.location.distance(itemLoc) > 15.0 || !session.drops.contains(pickedItem)) continue;
            session.drops.remove(pickedItem);
            if (session.drops.isEmpty()) {
                it.remove();
                if (session.isLatest) {
                    this.removeBossBar(player);
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                    player.sendMessage(ChatColor.GREEN + "Your remains have been gathered.");
                }
            }
            return;
        }
    }

    public void removeBossBar(Player player) {
        UUID uuid = player.getUniqueId();
        this.stopTimer(uuid);
        if (this.bossBars.containsKey(uuid)) {
            this.bossBars.get(uuid).removeAll();
            this.bossBars.remove(uuid);
        }
        this.timers.remove(uuid);
    }

    private void removeBossBarOffline(UUID uuid) {
        this.stopTimer(uuid);
        if (this.bossBars.containsKey(uuid)) {
            this.bossBars.get(uuid).removeAll();
            this.bossBars.remove(uuid);
        }
        this.timers.remove(uuid);
    }

    private void removeLatestDeath(Player player) {
        List<DeathSession> sessions = this.activeDeaths.get(player.getUniqueId());
        if (sessions != null) {
            sessions.removeIf(session -> session.isLatest);
        }
        this.removeBossBar(player);
    }

    private void removeLatestDeathOffline(UUID uuid) {
        List<DeathSession> sessions = this.activeDeaths.get(uuid);
        if (sessions != null) {
            sessions.removeIf(session -> session.isLatest);
        }
    }

    public void removeAllBeacons(Player player) {
        UUID uuid = player.getUniqueId();
        this.activeDeaths.remove(uuid);
        if (this.particleTasks.containsKey(uuid)) {
            this.particleTasks.get(uuid).cancel();
            this.particleTasks.remove(uuid);
        }
        this.removeBossBar(player);
    }

    public boolean hasBeacon(Player player) {
        return this.activeDeaths.containsKey(player.getUniqueId()) && !this.activeDeaths.get(player.getUniqueId()).isEmpty();
    }

    private String formatTime(int seconds) {
        String format = this.plugin.getConfig().getString("boss-bar.timer-format", "MM:SS");
        if ("MM:SS".equals(format)) {
            return String.format("%02d:%02d", seconds / 60, seconds % 60);
        }
        return String.valueOf(seconds);
    }

    private Color getParticleColor(String name) {
        switch (name.toUpperCase()) {
            case "AQUA": {
                return Color.AQUA;
            }
            case "BLACK": {
                return Color.BLACK;
            }
            case "BLUE": {
                return Color.BLUE;
            }
            case "FUCHSIA": {
                return Color.FUCHSIA;
            }
            case "GRAY": {
                return Color.GRAY;
            }
            case "GREEN": {
                return Color.GREEN;
            }
            case "LIME": {
                return Color.LIME;
            }
            case "MAROON": {
                return Color.MAROON;
            }
            case "NAVY": {
                return Color.NAVY;
            }
            case "OLIVE": {
                return Color.OLIVE;
            }
            case "ORANGE": {
                return Color.ORANGE;
            }
            case "PURPLE": {
                return Color.PURPLE;
            }
            case "RED": {
                return Color.RED;
            }
            case "SILVER": {
                return Color.SILVER;
            }
            case "TEAL": {
                return Color.TEAL;
            }
            case "WHITE": {
                return Color.WHITE;
            }
            case "YELLOW": {
                return Color.YELLOW;
            }
        }
        return Color.RED;
    }

    private static class DeathSession {
        Location location;
        List<ItemStack> drops;
        boolean isLatest;

        DeathSession(Location location, List<ItemStack> drops, boolean isLatest) {
            this.location = location;
            this.drops = drops;
            this.isLatest = isLatest;
        }
    }
}

