/*
 * Decompiled with CFR 0.152.
 */
package com.example.deathbeacon;

import com.example.deathbeacon.DeathBeacon;
import com.example.deathbeacon.DeathBeaconManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DeathBeaconCommand
implements CommandExecutor,
TabCompleter {
    private final DeathBeacon plugin;
    private final DeathBeaconManager manager;

    public DeathBeaconCommand(DeathBeacon plugin, DeathBeaconManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage(ChatColor.GREEN + "DeathBeacon configuration reloaded!");
                return true;
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "clear": {
                if (!sender.hasPermission("deathbeacon.admin")) {
                    sender.sendMessage(ChatColor.RED + "You don't have permission to do this.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /db clear <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage(ChatColor.RED + "Player not found.");
                    return true;
                }
                this.manager.removeAllBeacons(target);
                sender.sendMessage(ChatColor.GREEN + "Cleared all death beacons for " + target.getName());
                target.sendMessage(ChatColor.YELLOW + "An admin has cleared your death beacons.");
                return true;
            }
            case "toggle": {
                return this.handleToggle(sender, args);
            }
            case "set": {
                return this.handleSet(sender, args);
            }
        }
        sender.sendMessage(ChatColor.RED + "Unknown command. Type /db help for help.");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "DeathBeacon Commands:");
        sender.sendMessage(ChatColor.AQUA + "/db help" + ChatColor.WHITE + " - Show this help message");
        sender.sendMessage(ChatColor.AQUA + "/db reload" + ChatColor.WHITE + " - Reload the configuration");
        sender.sendMessage(ChatColor.AQUA + "/db clear <player>" + ChatColor.WHITE + " - Remove all beacons for a player");
        sender.sendMessage(ChatColor.AQUA + "/db toggle <beacon|message>" + ChatColor.WHITE + " - Toggle features");
        sender.sendMessage(ChatColor.AQUA + "/db set duration <seconds>" + ChatColor.WHITE + " - Set boss bar time");
        sender.sendMessage(ChatColor.AQUA + "/db set bar color <color>" + ChatColor.WHITE + " - Set bar color");
        sender.sendMessage(ChatColor.AQUA + "/db set beacon color <color>" + ChatColor.WHITE + " - Set particle color");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("help", "reload", "toggle", "set", "clear");
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("clear")) {
                return null;
            }
            if (args[0].equalsIgnoreCase("toggle")) {
                return Arrays.asList("beacon", "message");
            }
            if (args[0].equalsIgnoreCase("set")) {
                return Arrays.asList("duration", "bar", "beacon");
            }
        }
        return new ArrayList<String>();
    }

    private boolean handleToggle(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: /db toggle <beacon|message>");
            return true;
        }
        String feature = args[1].toLowerCase();
        if (feature.equals("beacon")) {
            boolean enabled = this.plugin.getConfig().getBoolean("death-beacon.enabled");
            this.plugin.getConfig().set("death-beacon.enabled", (Object)(!enabled ? 1 : 0));
            this.plugin.saveConfig();
            sender.sendMessage(ChatColor.GREEN + "Death beacon " + (!enabled ? "enabled" : "disabled") + "!");
        } else if (feature.equals("message")) {
            boolean global = this.plugin.getConfig().getBoolean("death-message.global");
            this.plugin.getConfig().set("death-message.global", (Object)(!global ? 1 : 0));
            this.plugin.saveConfig();
            sender.sendMessage(ChatColor.GREEN + "Global death message " + (!global ? "enabled" : "disabled") + "!");
        }
        return true;
    }

    private boolean handleSet(CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        String setting = args[1].toLowerCase();
        if (setting.equals("duration") && args.length >= 3) {
            this.plugin.getConfig().set("boss-bar.duration", (Object)Integer.parseInt(args[2]));
            this.plugin.saveConfig();
            sender.sendMessage(ChatColor.GREEN + "Duration set.");
        } else if (setting.equals("bar") && args.length >= 4) {
            this.plugin.getConfig().set("boss-bar.color", (Object)args[3].toUpperCase());
            this.plugin.saveConfig();
            sender.sendMessage(ChatColor.GREEN + "Bar color updated.");
        } else if (setting.equals("beacon") && args.length >= 4) {
            this.plugin.getConfig().set("death-beacon.color", (Object)args[3].toUpperCase());
            this.plugin.saveConfig();
            sender.sendMessage(ChatColor.GREEN + "Beacon color updated.");
        }
        return true;
    }
}

