/*
 * Decompiled with CFR 0.152.
 */
package com.stivikm.clearlag;

import com.stivikm.clearlag.ClearLag;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class ConfigManager {
    private final ClearLag plugin;
    private boolean enabled;
    private int intervalSeconds;
    private List<Integer> warningTimes;
    private List<String> whitelist;
    private List<String> worlds;
    private boolean clearXpOrbs;
    private String messageColor;
    private String warningMessage;
    private String clearMessage;

    public ConfigManager(ClearLag plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.enabled = this.plugin.getConfig().getBoolean("enabled", true);
        this.intervalSeconds = this.plugin.getConfig().getInt("interval-seconds", 300);
        this.warningTimes = this.plugin.getConfig().getIntegerList("warning-times");
        this.whitelist = this.plugin.getConfig().getStringList("whitelist");
        this.worlds = this.plugin.getConfig().getStringList("worlds");
        this.clearXpOrbs = this.plugin.getConfig().getBoolean("clear-xp-orbs", false);
        this.messageColor = this.plugin.getConfig().getString("message-color", "green");
        this.warningMessage = this.plugin.getConfig().getString("warning-message", "Items will be cleared in {time} seconds!");
        this.clearMessage = this.plugin.getConfig().getString("clear-message", "Cleared {count} items from the ground!");
        if (this.intervalSeconds < 1) {
            this.intervalSeconds = 1;
        } else if (this.intervalSeconds > 86400) {
            this.intervalSeconds = 86400;
        }
        if (this.warningTimes.isEmpty()) {
            this.warningTimes = new ArrayList<Integer>();
            this.warningTimes.add(60);
            this.warningTimes.add(30);
            this.warningTimes.add(10);
        }
    }

    public String formatMessage(String message) {
        ChatColor color = ChatColor.GREEN;
        try {
            color = ChatColor.valueOf((String)this.messageColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid color '" + this.messageColor + "' in config. Using GREEN.");
        }
        return String.valueOf(color) + message;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public List<Integer> getWarningTimes() {
        return this.warningTimes;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public boolean shouldClearXpOrbs() {
        return this.clearXpOrbs;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getClearMessage() {
        return this.clearMessage;
    }
}

