/*
 * Decompiled with CFR 0.152.
 */
package com.stivikm.clearlag;

import com.stivikm.clearlag.ClearLag;
import com.stivikm.clearlag.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ClearLagCommand
implements CommandExecutor,
TabCompleter {
    private final ClearLag plugin;

    public ClearLagCommand(ClearLag plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            if (!sender.hasPermission("clearlag.clear")) {
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to use this command."));
                return true;
            }
            this.plugin.clearItems();
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("clearlag.reload")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to reload."));
                    return true;
                }
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("ClearLag configuration reloaded!"));
                return true;
            }
            case "toggle": {
                if (!sender.hasPermission("clearlag.toggle")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to toggle."));
                    return true;
                }
                boolean currentState = this.plugin.getConfigManager().isEnabled();
                this.plugin.getConfig().set("enabled", (Object)(!currentState ? 1 : 0));
                this.plugin.saveConfig();
                this.plugin.reloadConfiguration();
                String status = !currentState ? "enabled" : "disabled";
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("Auto-clearing has been " + status + "!"));
                return true;
            }
            case "now": {
                if (!sender.hasPermission("clearlag.clear")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to use this command."));
                    return true;
                }
                this.plugin.clearItems();
                return true;
            }
            case "set": {
                if (!sender.hasPermission("clearlag.config")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to edit config."));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Usage: /clearlag set <setting> <value>"));
                    return true;
                }
                return this.handleSetCommand(sender, args);
            }
            case "add": {
                if (!sender.hasPermission("clearlag.config")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to edit config."));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Usage: /clearlag add <whitelist|world|warning> <value>"));
                    return true;
                }
                return this.handleAddCommand(sender, args);
            }
            case "remove": {
                if (!sender.hasPermission("clearlag.config")) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("You don't have permission to edit config."));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Usage: /clearlag remove <whitelist|world|warning> <value>"));
                    return true;
                }
                return this.handleRemoveCommand(sender, args);
            }
            case "info": 
            case "status": {
                this.sendInfo(sender);
                return true;
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Unknown subcommand. Use /clearlag help"));
        return true;
    }

    private boolean handleSetCommand(CommandSender sender, String[] args) {
        String setting = args[1].toLowerCase();
        String value = args[2];
        switch (setting) {
            case "interval": {
                try {
                    int seconds = Integer.parseInt(value);
                    if (seconds < 1 || seconds > 86400) {
                        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Interval must be between 1 and 86400 seconds!"));
                        return true;
                    }
                    this.plugin.getConfig().set("interval-seconds", (Object)seconds);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfiguration();
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Interval set to " + seconds + " seconds!"));
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Invalid number!"));
                }
                return true;
            }
            case "color": {
                this.plugin.getConfig().set("message-color", (Object)value.toUpperCase());
                this.plugin.saveConfig();
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("Message color set to " + value.toUpperCase() + "!"));
                return true;
            }
            case "warning-message": {
                StringBuilder warningMsg = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    warningMsg.append(args[i]).append(" ");
                }
                this.plugin.getConfig().set("warning-message", (Object)warningMsg.toString().trim());
                this.plugin.saveConfig();
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("Warning message updated!"));
                return true;
            }
            case "clear-message": {
                StringBuilder clearMsg = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    clearMsg.append(args[i]).append(" ");
                }
                this.plugin.getConfig().set("clear-message", (Object)clearMsg.toString().trim());
                this.plugin.saveConfig();
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("Clear message updated!"));
                return true;
            }
            case "clear-xp-orbs": {
                boolean clearXp = Boolean.parseBoolean(value);
                this.plugin.getConfig().set("clear-xp-orbs", (Object)clearXp);
                this.plugin.saveConfig();
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getConfigManager().formatMessage("Clear XP orbs set to " + clearXp + "!"));
                return true;
            }
        }
        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Unknown setting. Use /clearlag help"));
        return true;
    }

    private boolean handleAddCommand(CommandSender sender, String[] args) {
        String listType = args[1].toLowerCase();
        String value = args[2];
        switch (listType) {
            case "whitelist": {
                List whitelist = this.plugin.getConfig().getStringList("whitelist");
                if (whitelist.contains(value.toUpperCase())) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage(value.toUpperCase() + " is already in whitelist!"));
                } else {
                    whitelist.add(value.toUpperCase());
                    this.plugin.getConfig().set("whitelist", (Object)whitelist);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfiguration();
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Added " + value.toUpperCase() + " to whitelist!"));
                }
                return true;
            }
            case "world": {
                List worlds = this.plugin.getConfig().getStringList("worlds");
                if (worlds.contains(value)) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage(value + " is already in world list!"));
                } else {
                    worlds.add(value);
                    this.plugin.getConfig().set("worlds", (Object)worlds);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfiguration();
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Added " + value + " to world list!"));
                }
                return true;
            }
            case "warning": {
                try {
                    int seconds = Integer.parseInt(value);
                    List warnings = this.plugin.getConfig().getIntegerList("warning-times");
                    if (warnings.contains(seconds)) {
                        sender.sendMessage(this.plugin.getConfigManager().formatMessage(seconds + "s is already in warning times!"));
                    } else {
                        warnings.add(seconds);
                        this.plugin.getConfig().set("warning-times", (Object)warnings);
                        this.plugin.saveConfig();
                        this.plugin.reloadConfiguration();
                        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Added " + seconds + "s to warning times!"));
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Invalid number!"));
                }
                return true;
            }
        }
        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Unknown list type. Use whitelist, world, or warning"));
        return true;
    }

    private boolean handleRemoveCommand(CommandSender sender, String[] args) {
        String listType = args[1].toLowerCase();
        String value = args[2];
        switch (listType) {
            case "whitelist": {
                List whitelist = this.plugin.getConfig().getStringList("whitelist");
                if (whitelist.remove(value.toUpperCase())) {
                    this.plugin.getConfig().set("whitelist", (Object)whitelist);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfiguration();
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Removed " + value.toUpperCase() + " from whitelist!"));
                } else {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage(value.toUpperCase() + " is not in whitelist!"));
                }
                return true;
            }
            case "world": {
                List worlds = this.plugin.getConfig().getStringList("worlds");
                if (worlds.remove(value)) {
                    this.plugin.getConfig().set("worlds", (Object)worlds);
                    this.plugin.saveConfig();
                    this.plugin.reloadConfiguration();
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Removed " + value + " from world list!"));
                } else {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage(value + " is not in world list!"));
                }
                return true;
            }
            case "warning": {
                try {
                    int seconds = Integer.parseInt(value);
                    List warnings = this.plugin.getConfig().getIntegerList("warning-times");
                    if (warnings.remove((Object)seconds)) {
                        this.plugin.getConfig().set("warning-times", (Object)warnings);
                        this.plugin.saveConfig();
                        this.plugin.reloadConfiguration();
                        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Removed " + seconds + "s from warning times!"));
                    } else {
                        sender.sendMessage(this.plugin.getConfigManager().formatMessage(seconds + "s is not in warning times!"));
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().formatMessage("Invalid number!"));
                }
                return true;
            }
        }
        sender.sendMessage(this.plugin.getConfigManager().formatMessage("Unknown list type. Use whitelist, world, or warning"));
        return true;
    }

    private void sendInfo(CommandSender sender) {
        ConfigManager config = this.plugin.getConfigManager();
        sender.sendMessage(config.formatMessage("=== ClearLag Status ==="));
        sender.sendMessage(config.formatMessage("Enabled: " + config.isEnabled()));
        sender.sendMessage(config.formatMessage("Interval: " + config.getIntervalSeconds() + " seconds"));
        sender.sendMessage(config.formatMessage("Warning times: " + String.valueOf(config.getWarningTimes())));
        sender.sendMessage(config.formatMessage("Whitelist: " + String.valueOf(config.getWhitelist())));
        sender.sendMessage(config.formatMessage("Worlds: " + String.valueOf(config.getWorlds().isEmpty() ? "All" : config.getWorlds())));
        sender.sendMessage(config.formatMessage("Clear XP orbs: " + config.shouldClearXpOrbs()));
        sender.sendMessage(config.formatMessage("Message color: " + this.plugin.getConfig().getString("message-color")));
    }

    private void sendHelp(CommandSender sender) {
        ConfigManager config = this.plugin.getConfigManager();
        sender.sendMessage(config.formatMessage("=== ClearLag Commands ==="));
        sender.sendMessage(config.formatMessage("/clearlag - Manually clear items"));
        sender.sendMessage(config.formatMessage("/clearlag now - Force immediate clear"));
        sender.sendMessage(config.formatMessage("/clearlag toggle - Enable/disable auto-clearing"));
        sender.sendMessage(config.formatMessage("/clearlag reload - Reload configuration"));
        sender.sendMessage(config.formatMessage("/clearlag info - Show current config"));
        sender.sendMessage(config.formatMessage("/clearlag set <setting> <value> - Change a setting"));
        sender.sendMessage(config.formatMessage("/clearlag add <list> <value> - Add to a list"));
        sender.sendMessage(config.formatMessage("/clearlag remove <list> <value> - Remove from list"));
        sender.sendMessage(config.formatMessage("/clearlag help - Show this help"));
        sender.sendMessage(config.formatMessage(""));
        sender.sendMessage(config.formatMessage("Settings: interval, color, warning-message, clear-message, clear-xp-orbs"));
        sender.sendMessage(config.formatMessage("Lists: whitelist, world, warning"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("reload");
            completions.add("toggle");
            completions.add("now");
            completions.add("set");
            completions.add("add");
            completions.add("remove");
            completions.add("info");
            completions.add("help");
            String partial = args[0].toLowerCase();
            completions.removeIf(s -> !s.startsWith(partial));
        } else if (args.length == 2) {
            String subCommand = args[0].toLowerCase();
            if (subCommand.equals("set")) {
                completions.add("interval");
                completions.add("color");
                completions.add("warning-message");
                completions.add("clear-message");
                completions.add("clear-xp-orbs");
            } else if (subCommand.equals("add") || subCommand.equals("remove")) {
                completions.add("whitelist");
                completions.add("world");
                completions.add("warning");
            }
            String partial = args[1].toLowerCase();
            completions.removeIf(s -> !s.startsWith(partial));
        } else if (args.length == 3) {
            String subCommand = args[0].toLowerCase();
            String listType = args[1].toLowerCase();
            if (subCommand.equals("set")) {
                if (listType.equals("color")) {
                    completions.add("GREEN");
                    completions.add("RED");
                    completions.add("YELLOW");
                    completions.add("BLUE");
                    completions.add("AQUA");
                    completions.add("GOLD");
                    completions.add("LIGHT_PURPLE");
                    completions.add("DARK_RED");
                    completions.add("WHITE");
                } else if (listType.equals("clear-xp-orbs")) {
                    completions.add("true");
                    completions.add("false");
                } else if (listType.equals("interval")) {
                    completions.add("60");
                    completions.add("300");
                    completions.add("600");
                    completions.add("1800");
                }
            } else if (subCommand.equals("add") && listType.equals("whitelist")) {
                completions.add("NETHERITE_INGOT");
                completions.add("ELYTRA");
                completions.add("DIAMOND");
                completions.add("TOTEM_OF_UNDYING");
            } else if (subCommand.equals("add") && listType.equals("warning")) {
                completions.add("5");
                completions.add("10");
                completions.add("30");
                completions.add("60");
            }
            String partial = args[2].toLowerCase();
            completions.removeIf(s -> !s.toLowerCase().startsWith(partial));
        }
        return completions;
    }
}

