/*
 * Decompiled with CFR 0.152.
 */
package com.stivikm.clearlag;

import com.stivikm.clearlag.ClearLagCommand;
import com.stivikm.clearlag.ConfigManager;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClearLag
extends JavaPlugin {
    private ConfigManager configManager;
    private BukkitRunnable clearTask;

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.getCommand("clearlag").setExecutor((CommandExecutor)new ClearLagCommand(this));
        this.startClearTask();
        this.getLogger().info("ClearLag has been enabled!");
    }

    public void onDisable() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        this.getLogger().info("ClearLag has been disabled!");
    }

    public void startClearTask() {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        if (!this.configManager.isEnabled()) {
            return;
        }
        final long intervalTicks = (long)this.configManager.getIntervalSeconds() * 20L;
        final List<Integer> warningTimes = this.configManager.getWarningTimes();
        this.clearTask = new BukkitRunnable(){
            private long ticksUntilClear;
            private int lastWarningTime;
            {
                this.ticksUntilClear = intervalTicks;
                this.lastWarningTime = -1;
            }

            public void run() {
                --this.ticksUntilClear;
                long secondsRemaining = this.ticksUntilClear / 20L;
                if (warningTimes.contains((int)secondsRemaining) && this.lastWarningTime != (int)secondsRemaining) {
                    ClearLag.this.broadcastWarning(secondsRemaining);
                    this.lastWarningTime = (int)secondsRemaining;
                }
                if (this.ticksUntilClear <= 0L) {
                    ClearLag.this.clearItems();
                    this.ticksUntilClear = intervalTicks;
                    this.lastWarningTime = -1;
                }
            }
        };
        this.clearTask.runTaskTimer((Plugin)this, 0L, 1L);
    }

    public void clearItems() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long memoryBefore = runtime.totalMemory() - runtime.freeMemory();
        int totalCleared = 0;
        int totalEntities = 0;
        List<String> worlds = this.configManager.getWorlds();
        List<String> whitelist = this.configManager.getWhitelist();
        boolean clearXpOrbs = this.configManager.shouldClearXpOrbs();
        for (World world : Bukkit.getWorlds()) {
            if (!worlds.isEmpty() && !worlds.contains(world.getName())) continue;
            for (Entity entity : world.getEntities()) {
                boolean shouldRemove = false;
                int itemCount = 0;
                if (entity instanceof Item) {
                    Item item = (Item)entity;
                    String itemType = item.getItemStack().getType().name();
                    if (!whitelist.contains(itemType)) {
                        shouldRemove = true;
                        itemCount = item.getItemStack().getAmount();
                    }
                } else if (clearXpOrbs && entity.getType().name().equals("EXPERIENCE_ORB")) {
                    shouldRemove = true;
                    itemCount = 1;
                }
                if (!shouldRemove) continue;
                entity.remove();
                totalCleared += itemCount;
                ++totalEntities;
            }
        }
        runtime.gc();
        long memoryAfter = runtime.totalMemory() - runtime.freeMemory();
        long memoryFreed = memoryBefore - memoryAfter;
        double memoryFreedMB = (double)memoryFreed / 1048576.0;
        String message = this.configManager.getClearMessage().replace("{count}", String.valueOf(totalCleared)).replace("{entities}", String.valueOf(totalEntities)).replace("{memory}", String.format("%.2f", Math.abs(memoryFreedMB)));
        Bukkit.broadcastMessage((String)this.configManager.formatMessage(message));
        this.getLogger().info("Cleared " + totalCleared + " items (" + totalEntities + " entities). Memory freed: " + String.format("%.2f", Math.abs(memoryFreedMB)) + " MB");
    }

    private void broadcastWarning(long seconds) {
        String message = this.configManager.getWarningMessage().replace("{time}", String.valueOf(seconds));
        Bukkit.broadcastMessage((String)this.configManager.formatMessage(message));
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.configManager.loadConfig();
        this.startClearTask();
    }
}

