/*
 * Decompiled with CFR 0.152.
 */
package me.stivikmm.chunkguard.listener;

import me.stivikmm.chunkguard.ChunkGuard;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;

public class EntitySpawnListener
implements Listener {
    private final ChunkGuard plugin = ChunkGuard.getInstance();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntitySpawn(EntitySpawnEvent event) {
        if (!this.plugin.isMonitorSpawningEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.getType();
        if (!this.plugin.hasLimit(entityType)) {
            return;
        }
        Chunk chunk = entity.getChunk();
        int limit = this.plugin.getEntityLimit(entityType);
        int currentCount = this.countEntityTypesInChunk(chunk, entityType);
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("Spawn attempt: " + String.valueOf(entityType) + " at " + chunk.getX() + ", " + chunk.getZ() + " (" + currentCount + "/" + limit + ")");
        }
        if (currentCount >= limit) {
            event.setCancelled(true);
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().warning("Blocked spawn of " + String.valueOf(entityType) + " in chunk " + chunk.getX() + ", " + chunk.getZ() + " (limit: " + limit + ")");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (!this.plugin.isMonitorSpawningEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        EntityType entityType = entity.getType();
        if (!this.plugin.hasLimit(entityType)) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = event.getSpawnReason();
        String spawnReasonName = spawnReason.toString();
        if (this.isNaturallySpawnedHostileMob((Entity)entity, spawnReason)) {
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().info("Skipping limit check for naturally spawned hostile mob: " + String.valueOf(entityType) + " (spawn reason: " + spawnReasonName + ")");
            }
            return;
        }
        Chunk chunk = entity.getChunk();
        int limit = this.plugin.getEntityLimit(entityType);
        int currentCount = this.countEntityTypesInChunk(chunk, entityType);
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("Creature spawn attempt (" + spawnReasonName + "): " + String.valueOf(entityType) + " at " + chunk.getX() + ", " + chunk.getZ() + " (" + currentCount + "/" + limit + ")");
        }
        if (currentCount >= limit) {
            event.setCancelled(true);
            if (this.plugin.isDebugMode()) {
                this.plugin.getLogger().warning("Blocked spawn (" + spawnReasonName + ") of " + String.valueOf(entityType) + " in chunk " + chunk.getX() + ", " + chunk.getZ() + " (limit: " + limit + ")");
            }
        }
    }

    private boolean isNaturallySpawnedHostileMob(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        boolean isNaturalSpawn = reason == CreatureSpawnEvent.SpawnReason.SPAWNER || reason == CreatureSpawnEvent.SpawnReason.NATURAL;
        boolean isHostileMob = entity instanceof Monster;
        return isNaturalSpawn && isHostileMob;
    }

    private int countEntityTypesInChunk(Chunk chunk, EntityType entityType) {
        int count = 0;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != entityType) continue;
            ++count;
        }
        return count;
    }
}

