/*
 * Decompiled with CFR 0.152.
 */
package me.stivikmm.chunkguard.listener;

import me.stivikmm.chunkguard.ChunkGuard;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EntityPlacementListener
implements Listener {
    private final ChunkGuard plugin = ChunkGuard.getInstance();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (!this.plugin.isMonitorHangingEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player != null && player.hasPermission("chunkguard.bypass")) {
            return;
        }
        Hanging hanging = event.getEntity();
        EntityType entityType = hanging.getType();
        if (!this.plugin.hasLimit(entityType)) {
            return;
        }
        Chunk chunk = hanging.getChunk();
        int limit = this.plugin.getEntityLimit(entityType);
        int currentCount = this.countEntityTypesInChunk(chunk, entityType);
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("Placement attempt: " + String.valueOf(entityType) + " at " + chunk.getX() + ", " + chunk.getZ() + " (" + currentCount + "/" + limit + ")");
        }
        if (currentCount >= limit) {
            event.setCancelled(true);
            if (player != null) {
                this.sendLimitReachedMessage(player, entityType, currentCount, limit);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Chunk chunk;
        if (!this.plugin.isMonitorPlacementEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("chunkguard.bypass")) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Material heldMaterial = player.getInventory().getItemInMainHand().getType();
        EntityType entityTypeToPlace = this.getEntityTypeFromMaterial(heldMaterial);
        if (entityTypeToPlace == null) {
            return;
        }
        if (!this.plugin.hasLimit(entityTypeToPlace)) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock != null) {
            chunk = clickedBlock.getChunk();
        } else if (player.getLocation().getBlock() != null) {
            chunk = player.getLocation().getChunk();
        } else {
            return;
        }
        int limit = this.plugin.getEntityLimit(entityTypeToPlace);
        int currentCount = this.countEntityTypesInChunk(chunk, entityTypeToPlace);
        if (this.plugin.isDebugMode()) {
            this.plugin.getLogger().info("Placement attempt: " + String.valueOf(entityTypeToPlace) + " at " + chunk.getX() + ", " + chunk.getZ() + " (" + currentCount + "/" + limit + ")");
        }
        if (currentCount >= limit) {
            event.setCancelled(true);
            this.sendLimitReachedMessage(player, entityTypeToPlace, currentCount, limit);
        }
    }

    private EntityType getEntityTypeFromMaterial(Material material) {
        return switch (material) {
            case Material.ARMOR_STAND -> EntityType.ARMOR_STAND;
            case Material.OAK_BOAT, Material.SPRUCE_BOAT, Material.BIRCH_BOAT, Material.JUNGLE_BOAT, Material.ACACIA_BOAT, Material.DARK_OAK_BOAT, Material.MANGROVE_BOAT, Material.CHERRY_BOAT -> EntityType.BOAT;
            case Material.MINECART -> EntityType.MINECART;
            case Material.CHEST_MINECART -> EntityType.CHEST_MINECART;
            case Material.FURNACE_MINECART -> EntityType.FURNACE_MINECART;
            case Material.TNT_MINECART -> EntityType.TNT_MINECART;
            case Material.HOPPER_MINECART -> EntityType.HOPPER_MINECART;
            case Material.COMMAND_BLOCK_MINECART -> EntityType.COMMAND_BLOCK_MINECART;
            case Material.ITEM_FRAME -> EntityType.ITEM_FRAME;
            case Material.GLOW_ITEM_FRAME -> EntityType.GLOW_ITEM_FRAME;
            case Material.PAINTING -> EntityType.PAINTING;
            default -> null;
        };
    }

    private int countEntityTypesInChunk(Chunk chunk, EntityType entityType) {
        int count = 0;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != entityType) continue;
            ++count;
        }
        return count;
    }

    private void sendLimitReachedMessage(Player player, EntityType entityType, int currentCount, int limit) {
        String entityName = entityType.name().replace("_", " ");
        Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"").append((Component)Component.text((String)"Chunk limit reached for: ", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)entityName, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" (", (TextColor)NamedTextColor.RED))).append((Component)Component.text((int)currentCount, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"/", (TextColor)NamedTextColor.RED))).append((Component)Component.text((int)limit, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.RED));
        player.sendActionBar(message);
    }
}

