/*
 * Decompiled with CFR 0.152.
 */
package me.stivikmm.chunkguard;

import java.util.HashMap;
import java.util.Map;
import me.stivikmm.chunkguard.listener.EntityPlacementListener;
import me.stivikmm.chunkguard.listener.EntitySpawnListener;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkGuard
extends JavaPlugin {
    private static ChunkGuard instance;
    private final Map<EntityType, Integer> entityLimits = new HashMap<EntityType, Integer>();
    private boolean monitorSpawning;
    private boolean monitorPlacement;
    private boolean monitorHanging;
    private boolean debugMode;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.registerListeners();
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "ChunkGuard v1.0.0 enabled!");
        this.getLogger().info("Monitoring " + this.entityLimits.size() + " entity types");
    }

    public void onDisable() {
        this.getLogger().info(String.valueOf(ChatColor.YELLOW) + "ChunkGuard disabled.");
    }

    private void loadConfiguration() {
        ConfigurationSection featuresSection;
        ConfigurationSection limitsSection = this.getConfig().getConfigurationSection("entity-limits");
        if (limitsSection != null) {
            for (String key : limitsSection.getKeys(false)) {
                try {
                    EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                    int limit = limitsSection.getInt(key);
                    if (limit <= 0) continue;
                    this.entityLimits.put(entityType, limit);
                    if (!this.debugMode) continue;
                    this.getLogger().info("Loaded limit for " + String.valueOf(entityType) + ": " + limit);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Unknown entity type in config: " + key);
                }
            }
        }
        if ((featuresSection = this.getConfig().getConfigurationSection("features")) != null) {
            this.monitorSpawning = featuresSection.getBoolean("monitor-spawning", true);
            this.monitorPlacement = featuresSection.getBoolean("monitor-placement", true);
            this.monitorHanging = featuresSection.getBoolean("monitor-hanging", true);
        } else {
            this.monitorSpawning = true;
            this.monitorPlacement = true;
            this.monitorHanging = true;
        }
        this.debugMode = this.getConfig().getBoolean("debug", false);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new EntityPlacementListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntitySpawnListener(), (Plugin)this);
    }

    public static ChunkGuard getInstance() {
        return instance;
    }

    public int getEntityLimit(EntityType entityType) {
        return this.entityLimits.getOrDefault(entityType, -1);
    }

    public boolean hasLimit(EntityType entityType) {
        return this.entityLimits.containsKey(entityType);
    }

    public Map<EntityType, Integer> getEntityLimits() {
        return new HashMap<EntityType, Integer>(this.entityLimits);
    }

    public boolean isMonitoringEnabled() {
        return this.monitorSpawning || this.monitorPlacement || this.monitorHanging;
    }

    public boolean isMonitorSpawningEnabled() {
        return this.monitorSpawning;
    }

    public boolean isMonitorPlacementEnabled() {
        return this.monitorPlacement;
    }

    public boolean isMonitorHangingEnabled() {
        return this.monitorHanging;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }
}

