/*
 * Decompiled with CFR 0.152.
 */
package com.autobackup;

import com.autobackup.AutoBackupPlugin;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class BackupCommand
implements CommandExecutor,
TabCompleter {
    private final AutoBackupPlugin plugin;

    public BackupCommand(AutoBackupPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("autobackup.use")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "now": 
            case "create": {
                if (!sender.hasPermission("autobackup.create")) {
                    sender.sendMessage("\u00a7cYou don't have permission to create backups.");
                    return true;
                }
                sender.sendMessage("\u00a7e[AutoBackup] Starting manual backup...");
                this.plugin.performBackup(true);
                break;
            }
            case "list": {
                if (!sender.hasPermission("autobackup.list")) {
                    sender.sendMessage("\u00a7cYou don't have permission to list backups.");
                    return true;
                }
                this.listBackups(sender);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("autobackup.reload")) {
                    sender.sendMessage("\u00a7cYou don't have permission to reload the plugin.");
                    return true;
                }
                this.plugin.reloadPluginConfig();
                sender.sendMessage("\u00a7a[AutoBackup] Configuration reloaded!");
                break;
            }
            case "info": {
                this.showInfo(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== AutoBackup Commands ===");
        sender.sendMessage("\u00a7e/autobackup now \u00a77- Create a manual backup immediately");
        sender.sendMessage("\u00a7e/autobackup list \u00a77- List all available backups");
        sender.sendMessage("\u00a7e/autobackup info \u00a77- Show backup information");
        sender.sendMessage("\u00a7e/autobackup reload \u00a77- Reload plugin configuration");
    }

    private void listBackups(CommandSender sender) {
        try {
            List backups = Files.list(this.plugin.getBackupDirectory()).filter(p -> p.getFileName().toString().startsWith("backup_")).filter(p -> p.getFileName().toString().endsWith(".zip")).sorted((a, b) -> {
                try {
                    return Files.getLastModifiedTime(b, new LinkOption[0]).compareTo(Files.getLastModifiedTime(a, new LinkOption[0]));
                }
                catch (IOException e) {
                    return 0;
                }
            }).collect(Collectors.toList());
            if (backups.isEmpty()) {
                sender.sendMessage("\u00a7e[AutoBackup] No backups found.");
                return;
            }
            sender.sendMessage("\u00a76\u00a7l=== Available Backups ===");
            for (int i = 0; i < backups.size(); ++i) {
                Path backup = (Path)backups.get(i);
                String name = backup.getFileName().toString();
                long sizeInMB = Files.size(backup) / 0x100000L;
                sender.sendMessage("\u00a7e" + (i + 1) + ". \u00a7f" + name + " \u00a77(" + sizeInMB + " MB)");
            }
            sender.sendMessage("\u00a77Location: " + this.plugin.getBackupDirectory().toString());
        }
        catch (IOException e) {
            sender.sendMessage("\u00a7c[AutoBackup] Failed to list backups: " + e.getMessage());
        }
    }

    private void showInfo(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== AutoBackup Info ===");
        sender.sendMessage("\u00a7eBackup Interval: \u00a7f" + this.plugin.getConfig().getInt("backup-interval-minutes") + " minutes");
        sender.sendMessage("\u00a7eMax Backups: \u00a7f" + this.plugin.getConfig().getInt("max-backups"));
        sender.sendMessage("\u00a7eIncremental Backups: \u00a7f" + (this.plugin.getConfig().getBoolean("incremental-backups") ? "Enabled" : "Disabled"));
        sender.sendMessage("\u00a7eBackup Location: \u00a7f" + this.plugin.getBackupDirectory().toString());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("now", "list", "info", "reload"));
            return completions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

