/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.importer.v1_21_6;

import de.Ste3et_C0st.DiceFunitureMaker.Maker.FurnitureMaker;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.importer.ProjectTranslater;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.importer.TransformationParser;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Relative;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.entity.fDisplay;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class StringParser
extends ProjectTranslater {
    private static Class<?> mojangParserClazz;
    private static Class<?> NBTCompressedStreamToolsClazz;
    private static Class<?> NBTTagCompoundClazz;
    private static boolean isRelocatedPaper;
    private List<fEntity> entities = new ArrayList<fEntity>();

    public StringParser(String nbtString, FurnitureMaker maker) {
        super(nbtString.replaceAll("minecraft:", ""), maker);
        Location workingLocation = this.getMaker().getArea().getCenter().clone().add(0.0, 0.5, 0.0);
        this.executeSummon(nbtString, workingLocation);
        this.getObjectID().addEntities(this.entities);
        this.getMaker().getEntityList().addAll(this.entities);
        this.entities.stream().forEach(entity -> {
            entity.send(this.getMaker().getPlayer());
            entity.update(this.getMaker().getPlayer());
        });
        this.getMaker().giveSide(0, null);
    }

    private void executeSummon(String command2, Location startLocation) {
        if (!((String)command2).startsWith("/")) {
            command2 = "/" + (String)command2;
        }
        if (((String)command2).toLowerCase().startsWith("/summon ")) {
            String workingArguments = ((String)command2).replaceFirst("/summon ", "");
            String[] args = workingArguments.split(" ", 5);
            if (args.length > 3) {
                String minecraftMob = args[0].replace("minecraft:", "").toLowerCase();
                String xString = args[1];
                String yString = args[2];
                String zString = args[3];
                String nbtString = args.length > 4 ? args[4] : "{}";
                double xOffset = StringParser.eval(xString);
                double yOffset = StringParser.eval(yString);
                double zOffset = StringParser.eval(zString);
                Location location = startLocation.clone().add(xOffset, yOffset, zOffset);
                Optional<EntityType> type = Stream.of(EntityType.values()).filter(entry -> entry.name().equalsIgnoreCase(minecraftMob)).findFirst();
                NBTTagCompound tagCompound = this.getNBTfromString(nbtString);
                if (type.isPresent()) {
                    if (FurnitureManager.getInstance().isEntityTypeRegistred(type.get())) {
                        this.placeEntity(type.get(), tagCompound, location).ifPresent(entity -> this.entities.add((fEntity)entity));
                    } else {
                        this.parsePassenger(tagCompound, location);
                    }
                }
            }
        } else if (((String)command2).toLowerCase().startsWith("/setblock")) {
            String workingArguments = ((String)command2).replaceFirst("/setblock ", "");
            this.setBlock(workingArguments, startLocation);
        }
    }

    private void parsePassenger(NBTTagCompound tagCompound, Location location) {
        tagCompound.getCompound("Passengers", NBTTagList.class, tagList -> tagList.stream().filter(NBTTagCompound.class::isInstance).map(NBTTagCompound.class::cast).forEach(passengerCompound -> {
            if (passengerCompound.hasKey("Command")) {
                this.executeSummon(passengerCompound.getString("Command"), location);
            } else {
                this.summon((NBTTagCompound)passengerCompound, location).ifPresent(entity -> {});
            }
        }));
    }

    private Optional<fEntity> summon(NBTTagCompound tagCompound, Location startLocation) {
        String entityID = tagCompound.getString("id").toLowerCase().replaceFirst("minecraft:", "");
        Optional<EntityType> type = Stream.of(EntityType.values()).filter(entry -> entry.name().equalsIgnoreCase(entityID)).findFirst();
        return type.isPresent() ? this.placeEntity(type.get(), tagCompound, startLocation) : Optional.empty();
    }

    private Optional<fEntity> placeEntity(EntityType entityType, NBTTagCompound compound, Location startLocation) {
        Optional<fEntity> furnitureEntity = Optional.ofNullable(FurnitureLib.getInstance().getFurnitureManager().readEntity(entityType, startLocation, this.getObjectID()));
        furnitureEntity.ifPresent(entity -> {
            entity.loadMetadata(compound);
            if (entity instanceof fDisplay) {
                fDisplay display = (fDisplay)entity;
                compound.getCompound("transformation", NBTTagList.class, tagList -> new TransformationParser().parse((NBTTagList)tagList).ifPresent(transformation -> display.setTransformation(transformation)));
            }
            this.entities.add((fEntity)entity);
        });
        this.parsePassenger(compound, startLocation);
        return furnitureEntity;
    }

    public fEntity parseEntity(List<NBTTagCompound> commandList) {
        return null;
    }

    public void setBlock(String str, Location location) {
        str = str.replace("setblock ", "");
        String[] args = str.split(" ");
        String xOffsetStr = args[0];
        String yOffsetStr = args[1];
        String zOffsetStr = args[2];
        double xOffset = StringParser.eval(xOffsetStr);
        double yOffset = StringParser.eval(yOffsetStr);
        double zOffset = StringParser.eval(zOffsetStr);
        final Relative relative = new Relative(location, xOffset, yOffset, zOffset, BlockFace.EAST);
        str = str.replace(xOffsetStr + " ", "");
        str = str.replace(yOffsetStr + " ", "");
        str = str.replace(zOffsetStr + " ", "");
        try {
            final Material m = MaterialConverter.getMaterialFromOld((String)args[3]);
            Object byteStr = "0";
            try {
                if (args[4] != null) {
                    String stl = args[4].replaceAll("[^\\d.]", "");
                    byteStr = "" + Integer.parseInt(stl);
                }
            }
            catch (Exception stl) {
                // empty catch block
            }
            int i = Integer.parseInt((String)byteStr);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)FurnitureLib.getInstance(), new Runnable(){

                @Override
                public void run() {
                    relative.getSecondLocation().getBlock().setType(m);
                    StringParser.this.getMaker().getBlockList().add(relative.getSecondLocation().getBlock());
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public NBTTagCompound getNBTfromString(String nbtString) {
        try (ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            NBTTagCompound nBTTagCompound;
            block13: {
                OutputStream outputStream = this.reflectMojangParser(nbtString, byteOutputStream);
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                    nBTTagCompound = NBTCompressedStreamTools.read((InputStream)inputStream);
                    if (outputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return nBTTagCompound;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NBTTagCompound();
        }
    }

    @Override
    public OutputStream reflectMojangParser(String str, OutputStream stream) {
        try {
            Method parse = mojangParserClazz.getMethod(isRelocatedPaper ? "parseCompoundFully" : "a", String.class);
            Method nbtToOutStream = NBTCompressedStreamToolsClazz.getMethod(isRelocatedPaper ? "writeCompressed" : "a", NBTTagCompoundClazz, OutputStream.class);
            Object nbtTagCompound = parse.invoke(null, str.substring(str.indexOf("{"), str.length()));
            nbtToOutStream.invoke(null, nbtTagCompound, stream);
            return stream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ModelBlock parseBlock() {
        return null;
    }

    @Override
    public fEntity parseEntity() {
        return null;
    }

    static {
        isRelocatedPaper = FurnitureLib.isVersionOrAbove((String)"1.20.5") && FurnitureLib.isPaper();
        try {
            mojangParserClazz = isRelocatedPaper ? Class.forName("net.minecraft.nbt.TagParser") : Class.forName("net.minecraft.nbt.MojangsonParser");
            NBTCompressedStreamToolsClazz = isRelocatedPaper ? Class.forName("net.minecraft.nbt.NbtIo") : Class.forName("net.minecraft.nbt.NBTCompressedStreamTools");
            NBTTagCompoundClazz = isRelocatedPaper ? Class.forName("net.minecraft.nbt.CompoundTag") : Class.forName("net.minecraft.nbt.NBTTagCompound");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

