/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.importer;

import de.Ste3et_C0st.DiceFunitureMaker.Maker.FurnitureMaker;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.importer.ProjectTranslater;
import de.Ste3et_C0st.FurnitureLib.ModelLoader.Block.ModelBlock;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTBase;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTCompressedStreamTools;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagCompound;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagList;
import de.Ste3et_C0st.FurnitureLib.NBT.NBTTagString;
import de.Ste3et_C0st.FurnitureLib.Utilitis.MaterialConverter;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Relative;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fArmorStand;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;

public class StringParser
extends ProjectTranslater {
    private static Class<?> mojangParserClazz;
    private static Class<?> NBTCompressedStreamToolsClazz;
    private static Class<?> NBTTagCompoundClazz;
    private static Class<?> NMSItem;
    private static Class<?> CraftItemStack;
    List<NBTTagCompound> compounds = new ArrayList<NBTTagCompound>();

    public StringParser(String nbtString, FurnitureMaker maker) {
        super(nbtString.toLowerCase(), maker);
        List<NBTTagCompound> commandList = this.connvertCommands();
        List<fEntity> parsedEntities = this.parseEntities(commandList);
        parsedEntities.stream().forEach(entry -> {
            this.getObjectID().addArmorStand(entry);
            this.getMaker().addEntity((fEntity)entry);
            entry.send(this.getMaker().getPlayer());
            entry.update(this.getMaker().getPlayer());
        });
        this.getMaker().giveSide(1, fArmorStand.class);
    }

    public List<fEntity> parseEntities(List<NBTTagCompound> commandList) {
        ArrayList<fEntity> entities = new ArrayList<fEntity>();
        Location startLocation = this.getStartLocation().clone().add(0.0, 3.0, 0.0);
        commandList.stream().forEach(compound -> {
            if (compound.hasKey("command")) {
                Optional<Block> block;
                NBTTagString string = (NBTTagString)compound.get("command");
                String command2 = string.toString().toLowerCase();
                if (command2.contains("summon armorstand") || command2.contains("summon armor_stand")) {
                    Optional<fEntity> entity = this.summonArmorStands(command2, startLocation);
                    if (entity.isPresent()) {
                        entities.add(entity.get());
                    }
                } else if (command2.startsWith("setblock") && (block = this.addBlock(command2, startLocation)).isPresent()) {
                    this.getMaker().getBlockList().add(block.get());
                }
            }
        });
        return entities;
    }

    public Optional<Block> addBlock(String command2, Location startLocation) {
        Optional<Block> optinal;
        block7: {
            optinal = Optional.empty();
            command2 = command2.replace("setblock ", "");
            String[] args = command2.split(" ");
            String xOffsetStr = args[0];
            String yOffsetStr = args[1];
            String zOffsetStr = args[2];
            double xOffset = StringParser.eval(xOffsetStr);
            double yOffset = StringParser.eval(yOffsetStr);
            double zOffset = StringParser.eval(zOffsetStr);
            Relative relative = new Relative(startLocation, xOffset, yOffset, zOffset, BlockFace.EAST);
            command2 = command2.replace(xOffsetStr + " ", "").replace(yOffsetStr + " ", "").replace(zOffsetStr + " ", "");
            try {
                if (args[3].isEmpty()) {
                    return null;
                }
                if (FurnitureLib.getVersionInt() > 12) {
                    Material material = Material.AIR;
                    material = MaterialConverter.getMaterialFromOld((String)args[3]);
                    relative.getSecondLocation().getBlock().setType(material);
                    optinal = Optional.of(relative.getSecondLocation().getBlock());
                    break block7;
                }
                Material m = Material.matchMaterial((String)args[3]);
                Object byteStr = "0";
                try {
                    if (args[4] != null) {
                        String stl = args[4].replaceAll("[^\\d.]", "");
                        byteStr = "" + Integer.parseInt(stl);
                    }
                }
                catch (Exception stl) {
                    // empty catch block
                }
                int i = Integer.parseInt((String)byteStr);
                relative.getSecondLocation().getBlock().setType(m);
                relative.getSecondLocation().getBlock().getState().setRawData((byte)i);
                optinal = Optional.of(relative.getSecondLocation().getBlock());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return optinal;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<fEntity> summonArmorStands(String command2, Location startLocation) {
        command2 = command2.replace("summon armorstand ", "summon armor_stand");
        int startIndexCommand = command2.indexOf("summon armor_stand");
        command2 = command2.substring(startIndexCommand, command2.length());
        String[] args = command2.replace("summon armor_stand ", "").split(" ");
        String xOffsetStr = args[0];
        String yOffsetStr = args[1];
        String zOffsetStr = args[2];
        double xOffset = StringParser.eval(xOffsetStr);
        double yOffset = StringParser.eval(yOffsetStr);
        double zOffset = StringParser.eval(zOffsetStr);
        int index = command2.contains("{") ? command2.indexOf("{") : 0;
        int lastIndex = command2.length();
        if (command2.contains("{")) {
            int stack = 0;
            for (int i = index; i < command2.length(); ++i) {
                char c = command2.charAt(i);
                if (c == '{') {
                    ++stack;
                    continue;
                }
                if (c != '}' || --stack != 0) continue;
                lastIndex = i + 1;
                break;
            }
        }
        String nbtString = command2.substring(index, lastIndex);
        try (ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            Optional<fArmorStand> optional;
            block50: {
                OutputStream outputStream = this.reflectMojangParser(nbtString, byteOutputStream);
                try {
                    NBTTagCompound item;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                    NBTTagCompound metadata = NBTCompressedStreamTools.read((InputStream)inputStream);
                    Relative relative = new Relative(startLocation, xOffset, yOffset, zOffset, BlockFace.EAST);
                    Location armorStandLocation = relative.getSecondLocation();
                    float yaw = startLocation.getYaw() + 180.0f;
                    if (metadata.hasKey("rotation")) {
                        yaw += metadata.getFloat("rotation");
                    }
                    armorStandLocation.setYaw(yaw);
                    fArmorStand armorStand = FurnitureManager.getInstance().createArmorStand(this.getObjectID(), armorStandLocation);
                    if (metadata.hasKey("customnamevisible")) {
                        armorStand.setNameVisibility(metadata.getInt("customnamevisible") == 1);
                    }
                    if (metadata.hasKey("showarms")) {
                        armorStand.setArms(metadata.getInt("showarms") == 1);
                    }
                    if (metadata.hasKey("small")) {
                        armorStand.setSmall(metadata.getInt("small") == 1);
                    }
                    if (metadata.hasKey("marker")) {
                        armorStand.setMarker(metadata.getInt("marker") == 0);
                    }
                    if (metadata.hasKey("glowing")) {
                        armorStand.setGlowing(metadata.getInt("glowing") == 1);
                    }
                    if (metadata.hasKey("invisible")) {
                        armorStand.setInvisible(metadata.getInt("invisible") == 1);
                    }
                    if (metadata.hasKey("nobaseplate")) {
                        armorStand.setBasePlate(metadata.getInt("nobaseplate") == 0);
                    }
                    if (metadata.hasKey("customName")) {
                        armorStand.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)metadata.getString("customName")));
                    }
                    if (metadata.hasKey("pose")) {
                        NBTTagCompound pose = metadata.getCompound("pose");
                        for (Type.BodyPart part : Type.BodyPart.values()) {
                            EulerAngle angle = part.getDefAngle();
                            String name = part.getName();
                            name = name.replace("_", "");
                            boolean b = false;
                            if (pose.hasKey(name.toLowerCase())) {
                                NBTTagList nbtPart = pose.getList(name.toLowerCase());
                                if (nbtPart.size() == 3) {
                                    block29: for (int i = 0; i < nbtPart.size(); ++i) {
                                        String floatString = nbtPart.getString(i);
                                        Float f = Float.valueOf(floatString);
                                        double d = f.floatValue();
                                        switch (i) {
                                            case 0: {
                                                angle = angle.setX(d);
                                                continue block29;
                                            }
                                            case 1: {
                                                angle = angle.setY(d);
                                                continue block29;
                                            }
                                            case 2: {
                                                angle = angle.setZ(d);
                                            }
                                        }
                                    }
                                }
                                b = true;
                            }
                            if (b) {
                                angle = FurnitureLib.getInstance().getLocationUtil().degresstoRad(angle);
                            }
                            armorStand.setPose(angle, part);
                        }
                    }
                    if (metadata.hasKey("handItems")) {
                        block30: for (int i = 0; i < metadata.getList("handItems").size(); ++i) {
                            item = metadata.getList("handitems").get(i);
                            switch (i) {
                                case 0: {
                                    armorStand.setItemInMainHand(this.getStack(item));
                                    continue block30;
                                }
                                case 1: {
                                    armorStand.setItemInOffHand(this.getStack(item));
                                }
                            }
                        }
                    }
                    if (metadata.hasKey("armoritems")) {
                        block31: for (int i = 0; i < metadata.getList("armoritems").size(); ++i) {
                            item = metadata.getList("armoritems").get(i);
                            switch (i) {
                                case 0: {
                                    armorStand.setBoots(this.getStack(item));
                                    continue block31;
                                }
                                case 1: {
                                    armorStand.setLeggings(this.getStack(item));
                                    continue block31;
                                }
                                case 2: {
                                    armorStand.setChestPlate(this.getStack(item));
                                    continue block31;
                                }
                                case 3: {
                                    armorStand.setHelmet(this.getStack(item));
                                }
                            }
                        }
                    }
                    optional = Optional.of(armorStand);
                    if (outputStream == null) break block50;
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputStream.close();
            }
            return optional;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private ItemStack getStack(NBTTagCompound item) {
        String materialName = item.getString("id");
        if (materialName.isEmpty()) {
            return null;
        }
        if (FurnitureLib.getVersionInt() > 12) {
            Material material = Material.AIR;
            if (item.hasKey("damage")) {
                if (!(item = MaterialConverter.convertNMSItemStack((NBTTagCompound)item)).hasKey("id")) {
                    item.setString("id", materialName);
                } else if (item.getString("id").isEmpty()) {
                    item.setString("id", materialName);
                }
            }
            material = MaterialConverter.getMaterialFromOld((String)(item.hasKey("damage") ? item.getString("id") : item.getString("id") + ":" + item.getInt("damage")));
            ItemStack stack = new ItemStack(material);
            return stack;
        }
        ItemStack stack = (ItemStack)this.getCraftItemStack(item.getString("id"));
        int a = 1;
        if (item.hasKey("count")) {
            a = item.getInt("count");
        }
        short d = 0;
        if (item.hasKey("damage")) {
            d = (short)item.getInt("damage");
        }
        stack.setAmount(a);
        stack.setDurability(d);
        return stack;
    }

    private Object getCraftItemStack(String id) {
        try {
            Method m = NMSItem.getDeclaredMethod("b", String.class);
            Object item = m.invoke(null, id);
            m = CraftItemStack.getDeclaredMethod("asNewCraftStack", NMSItem);
            return m.invoke(null, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public fEntity parseEntity(List<NBTTagCompound> commandList) {
        return null;
    }

    public void setBlock(String str) throws Exception {
        str = str.replace("setblock ", "");
        String[] args = str.split(" ");
        String xOffsetStr = args[0];
        String yOffsetStr = args[1];
        String zOffsetStr = args[2];
        double xOffset = StringParser.eval(xOffsetStr);
        double yOffset = StringParser.eval(yOffsetStr);
        double zOffset = StringParser.eval(zOffsetStr);
        final Relative relative = new Relative(this.getStartLocation(), xOffset, yOffset, zOffset, BlockFace.EAST);
        str = str.replace(xOffsetStr + " ", "");
        str = str.replace(yOffsetStr + " ", "");
        str = str.replace(zOffsetStr + " ", "");
        try {
            final Material m = MaterialConverter.getMaterialFromOld((String)args[3]);
            Object byteStr = "0";
            try {
                if (args[4] != null) {
                    String stl = args[4].replaceAll("[^\\d.]", "");
                    byteStr = "" + Integer.parseInt(stl);
                }
            }
            catch (Exception stl) {
                // empty catch block
            }
            int i = Integer.parseInt((String)byteStr);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)FurnitureLib.getInstance(), new Runnable(){

                @Override
                public void run() {
                    relative.getSecondLocation().getBlock().setType(m);
                    StringParser.this.getMaker().getBlockList().add(relative.getSecondLocation().getBlock());
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<NBTTagCompound> connvertCommands() {
        try (ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();){
            List<NBTTagCompound> list;
            block17: {
                ByteArrayInputStream inputStream;
                OutputStream outputStream;
                block15: {
                    List<NBTTagCompound> list2;
                    block16: {
                        outputStream = this.reflectMojangParser(this.getNbtString(), byteOutputStream);
                        try {
                            inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                            if (inputStream.available() != 0) break block15;
                            list2 = null;
                            if (outputStream == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        outputStream.close();
                    }
                    return list2;
                }
                NBTTagCompound compound = NBTCompressedStreamTools.read((InputStream)inputStream);
                this.getCommandsRecrusive(compound, this.compounds);
                list = this.compounds;
                if (outputStream == null) break block17;
                outputStream.close();
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getCommandsRecrusive(NBTTagCompound compound, List<NBTTagCompound> compoundList) {
        for (Object object : compound.c()) {
            String name;
            NBTBase base;
            if (!(object instanceof String) || !((base = compound.get(name = (String)object)) instanceof NBTTagList)) continue;
            NBTTagList list = (NBTTagList)base;
            for (int i = 0; i < list.size(); ++i) {
                NBTTagCompound compound2 = list.get(i);
                if (compound2.hasKey("command")) {
                    compoundList.add(compound2);
                    continue;
                }
                this.getCommandsRecrusive(compound2, compoundList);
            }
        }
    }

    @Override
    public OutputStream reflectMojangParser(String str, OutputStream stream) {
        try {
            Method parse = mojangParserClazz.getMethod("parse", String.class);
            Method nbtToOutStream = NBTCompressedStreamToolsClazz.getMethod("a", NBTTagCompoundClazz, OutputStream.class);
            Object nbtTagCompound = parse.invoke(null, str.substring(str.indexOf("{"), str.length()));
            nbtToOutStream.invoke(null, nbtTagCompound, stream);
            return stream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ModelBlock parseBlock() {
        return null;
    }

    @Override
    public fEntity parseEntity() {
        return null;
    }

    static {
        try {
            mojangParserClazz = ProjectTranslater.getNMSClass("MojangsonParser");
            NBTCompressedStreamToolsClazz = ProjectTranslater.getNMSClass("NBTCompressedStreamTools");
            NBTTagCompoundClazz = ProjectTranslater.getNMSClass("NBTTagCompound");
            NMSItem = ProjectTranslater.getNMSClass("Item");
            CraftItemStack = ProjectTranslater.getOBCClass("inventory.CraftItemStack");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

