/*
 * Decompiled with CFR 0.152.
 */
package de.Ste3et_C0st.DiceFunitureMaker.Maker;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import de.Ste3et_C0st.DiceFunitureMaker.FurnitureMakerPlugin;
import de.Ste3et_C0st.DiceFunitureMaker.Maker.FurnitureMaker;
import de.Ste3et_C0st.DiceFunitureMaker.Maker.FurnitureMakerArea;
import de.Ste3et_C0st.DiceFurnitureMaker.VersionControl.CraftSkull;
import de.Ste3et_C0st.FurnitureLib.Crafting.Project;
import de.Ste3et_C0st.FurnitureLib.SchematicLoader.ProjectMetadata;
import de.Ste3et_C0st.FurnitureLib.Utilitis.Relative;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureLib;
import de.Ste3et_C0st.FurnitureLib.main.FurnitureManager;
import de.Ste3et_C0st.FurnitureLib.main.ObjectID;
import de.Ste3et_C0st.FurnitureLib.main.Type;
import de.Ste3et_C0st.FurnitureLib.main.entity.fArmorStand;
import de.Ste3et_C0st.FurnitureLib.main.entity.fBlock_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.fDisplay;
import de.Ste3et_C0st.FurnitureLib.main.entity.fEntity;
import de.Ste3et_C0st.FurnitureLib.main.entity.fInteraction;
import de.Ste3et_C0st.FurnitureLib.main.entity.fItem_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.fText_display;
import de.Ste3et_C0st.FurnitureLib.main.entity.monster.fMagmaCube;
import de.Ste3et_C0st.FurnitureLib.main.entity.monster.fShulker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.joml.Vector3f;

public abstract class FurnitureMakerSerializer
extends ProjectMetadata {
    private Location location;
    private FurnitureMakerArea area;
    private String modelName;
    private ObjectID objectID;
    protected Type.PlaceableSide placeAbleSide = Type.PlaceableSide.TOP;
    private Player player;
    private HashSet<fEntity> packetList = new HashSet();
    protected List<Block> blockList = new ArrayList<Block>();
    public Class<? extends fEntity> entitySelectorClass = null;

    public FurnitureMakerSerializer(Player player, Location location, String modelName, ObjectID objID) {
        this.objectID = objID;
        this.objectID.setPrivate(true);
        this.objectID.getPlayerList().add(player);
        this.location = location.getBlock().getLocation();
        this.location.add(0.5, 0.0, 0.5);
        this.location.setYaw(0.0f);
        this.modelName = modelName;
        this.placeAbleSide = Objects.isNull(this.getProject()) ? Type.PlaceableSide.TOP : this.getProject().getPlaceableSide();
        this.area = new FurnitureMakerArea(this.getStartLocation(), 10);
        this.player = player;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Location getStartLocation() {
        return this.location.clone();
    }

    public FurnitureMakerArea getArea() {
        return this.area;
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }

    public FurnitureLib getFurnitureLib() {
        return FurnitureLib.getInstance();
    }

    public FurnitureManager getFurnitureManager() {
        return this.getFurnitureLib().getFurnitureManager();
    }

    public fEntity addEntity() {
        fArmorStand entity = FurnitureLib.getInstance().getFurnitureManager().createArmorStand(this.getObjectID(), this.getFurnitureLib().getLocationUtil().getCenter(this.getStartLocation()).clone().subtract(0.0, 0.5, 0.0));
        return this.addEntity((fEntity)entity);
    }

    public fEntity addEntity(Class<? extends fEntity> entityClass) {
        fBlock_display display;
        BiFunction<Location, ObjectID, fEntity> function = (t, u) -> {
            try {
                return (fEntity)entityClass.getConstructor(Location.class, ObjectID.class).newInstance(t.clone(), u);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
        Location spawnLocation = this.getFurnitureLib().getLocationUtil().getCenter(this.getStartLocation()).clone().subtract(0.0, 0.5, 0.0);
        fEntity entity = function.apply(spawnLocation, this.getObjectID());
        if (entity instanceof fBlock_display) {
            display = (fBlock_display)fBlock_display.class.cast(entity);
            display.setBlockData(Material.STONE);
            display.teleport(display.getLocation().subtract(0.5, 0.0, 0.5));
        }
        if (entity instanceof fText_display) {
            display = (fText_display)entity;
            display.teleport(display.getLocation().add(0.0, 1.0, 0.0));
            display.setText("Hello World");
            display.setBillboard(Display.Billboard.FIXED);
        }
        if (entity instanceof fInteraction) {
            display = (fInteraction)entity;
            display.setResponse(false);
        }
        if (entity instanceof fMagmaCube) {
            fMagmaCube cube = (fMagmaCube)entity;
            cube.setInvisible(true);
            cube.setSize(2);
        }
        if (entity instanceof fShulker) {
            fShulker shulker = (fShulker)entity;
            shulker.setInvisible(true);
        }
        if (entity instanceof fItem_display) {
            display = (fItem_display)entity;
            display.setItemStack(new ItemStack(Material.DIAMOND_SWORD));
        }
        if (entity instanceof fDisplay) {
            display = (fDisplay)entity;
            display.setBlockLight(15);
            display.setScale(new Vector3f(1.0f, 1.0f, 1.0f));
        }
        this.getObjectID().addArmorStand(entity);
        return this.addEntity(entity);
    }

    public fEntity addEntity(fEntity entity) {
        this.getObjectID().setSQLAction(Type.SQLAction.NOTHING);
        this.packetList.clear();
        this.packetList.add(entity);
        this.highLightEntities(entity);
        return entity;
    }

    public void highLight(fEntity entity) {
        if (!this.packetList.contains(entity)) {
            this.packetList.add(entity);
            this.highLightEntities((fEntity[])this.packetList.stream().toArray(fEntity[]::new));
        }
    }

    protected FurnitureMaker getMaker() {
        return FurnitureMakerPlugin.getInstance().getManager().getMaker(this.player);
    }

    public void removeHighlight(fEntity entity) {
        if (this.packetList.contains(entity)) {
            this.packetList.remove(entity);
            this.highLightEntities((fEntity[])this.packetList.stream().toArray(fEntity[]::new));
        }
    }

    public void highLightEntities(HashSet<fEntity> entities) {
        this.highLightEntities((fEntity[])entities.stream().toArray(fEntity[]::new));
    }

    public void highLightEntities(fEntity ... entities) {
        if (Objects.isNull(entities)) {
            return;
        }
        ArrayList<fEntity> entityList = new ArrayList<fEntity>(Arrays.asList(entities));
        this.getObjectID().getPacketList().stream().forEach(entity -> {
            if (entityList.contains(entity)) {
                entity.setGlowing(true);
            } else {
                entity.setGlowing(false);
            }
        });
        this.getObjectID().getPacketList().stream().forEach(entity -> entity.send(this.player));
    }

    public void select(HashSet<fEntity> entityList) {
        this.select((fEntity[])entityList.stream().toArray(fEntity[]::new));
    }

    public void selectFirst() {
        if (this.getObjectID().getPacketList().isEmpty()) {
            return;
        }
        this.select(this.getEntityList().stream().findFirst().orElse(this.getObjectID().getPacketList().stream().findFirst().orElse(null)));
    }

    public void selectFirstClass(Class<? extends fEntity> classs) {
        if (this.getObjectID().getPacketList().isEmpty()) {
            return;
        }
        this.select(this.getEntityList().stream().filter(entry -> entry.getClass().equals(classs)).findFirst().orElse(this.getObjectID().getPacketList().stream().filter(entry -> entry.getClass().equals(classs)).findFirst().orElse(null)));
    }

    public void selectAllByClass(Class<? extends fEntity> classs) {
        if (this.getObjectID().getPacketList().isEmpty()) {
            return;
        }
        ArrayList entityList = new ArrayList();
        this.getEntityList().stream().filter(entry -> entry.getClass().equals(classs)).forEach(entityList::add);
        this.getObjectID().getPacketList().stream().filter(entry -> entry.getClass().equals(classs)).forEach(entityList::add);
        this.select((fEntity[])entityList.toArray(fEntity[]::new));
    }

    public void selectAdd(fEntity ... fEntity2) {
        if (Objects.isNull(fEntity2)) {
            return;
        }
        if (fEntity2.length == 0) {
            return;
        }
        Arrays.asList(fEntity2).forEach(entity -> this.packetList.add((fEntity)entity));
        this.highLightEntities(this.packetList);
    }

    public void select(fEntity ... fEntity2) {
        if (Objects.isNull(fEntity2)) {
            return;
        }
        if (fEntity2.length == 0) {
            return;
        }
        this.packetList.clear();
        this.selectAdd(fEntity2);
    }

    public void deSelect(fEntity fEntity2) {
        if (this.packetList.size() > 1) {
            this.packetList.remove(fEntity2);
            this.select(this.packetList);
        }
    }

    public void removeEntities(List<fEntity> entityList) {
        entityList.stream().forEach(this::removeEntity);
        this.packetList.removeAll(entityList);
    }

    public void removeEntities(fEntity ... entityList) {
        Arrays.asList(entityList).forEach(this::removeEntity);
    }

    public void removeEntity(fEntity entity) {
        entity.kill();
        this.getObjectID().getPacketList().remove(entity);
    }

    public HashSet<fEntity> getEntityList() {
        return this.packetList;
    }

    public File save(UUID creator, Type.PlaceableSide side) {
        try {
            File filePath = new File(FurnitureLib.isNewVersion() ? "plugins/FurnitureLib/models/" + this.modelName + ".dModel" : "plugins/FurnitureLib/Crafting/" + this.modelName + ".yml");
            if (!filePath.getParentFile().exists()) {
                filePath.getParentFile().mkdirs();
            }
            if (!filePath.exists()) {
                filePath.createNewFile();
            }
            YamlConfiguration file = YamlConfiguration.loadConfiguration((File)filePath);
            file.options().header("------------------------------------  #\n                                      #\n      never touch the system-ID !     #\n                                      #\n------------------------------------  #\n");
            file.options().copyHeader(true);
            file.set(this.modelName + ".system-ID", (Object)this.modelName);
            file.set(this.modelName + ".creator", (Object)(Objects.nonNull(creator) ? creator.toString() : null));
            if (FurnitureLib.isNewVersion()) {
                file.set(this.modelName + ".displayName", (Object)("&c" + this.modelName));
                file.set(this.modelName + ".spawnMaterial", (Object)FurnitureLib.getInstance().getDefaultSpawnMaterial().name());
                file.set(this.modelName + ".itemGlowEffect", (Object)false);
                file.set(this.modelName + ".itemLore", (Object)"");
            } else {
                file.set(this.modelName + ".name", (Object)("&c" + this.modelName));
                file.set(this.modelName + ".material", (Object)FurnitureLib.getInstance().getDefaultSpawnMaterial().name());
                file.set(this.modelName + ".glow", (Object)false);
                file.set(this.modelName + ".lore", (Object)"");
            }
            file.set(this.modelName + ".placeAbleSide", (Object)side.toString());
            file.set(this.modelName + ".crafting.disable", (Object)true);
            file.set(this.modelName + ".crafting.recipe", (Object)"xxx,xxx,xxx");
            file.set(this.modelName + ".crafting.index.x", (Object)Material.BEDROCK.name());
            AtomicInteger counter = new AtomicInteger(0);
            String modelData = FurnitureLib.isNewVersion() ? this.modelName + ".projectData.entities" : this.modelName + ".ProjectModels.ArmorStands";
            String blockData = FurnitureLib.isNewVersion() ? this.modelName + ".projectData.blockList" : this.modelName + ".ProjectModels.Block";
            ProjectMetadata projectMetadata = new ProjectMetadata();
            file.set(modelData, null);
            this.getObjectID().getPacketList().stream().forEach(arg_0 -> this.lambda$save$13((FileConfiguration)file, modelData, counter, projectMetadata, arg_0));
            counter.set(0);
            if (!this.blockList.isEmpty()) {
                file.set(blockData, null);
                this.blockList.stream().forEach(arg_0 -> this.lambda$save$18(blockData, counter, (FileConfiguration)file, arg_0));
            } else {
                file.set(blockData, null);
            }
            file.save(filePath);
            this.getObjectID().remove(false);
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type.PlaceableSide getPlaceableSide() {
        return this.placeAbleSide;
    }

    private Project getProject() {
        for (Project project : FurnitureLib.getInstance().getFurnitureManager().getProjects()) {
            if (!project.getName().toLowerCase().equalsIgnoreCase(this.getModelName())) continue;
            return project;
        }
        return null;
    }

    public void stop() {
        this.area.reset(this.player);
        this.player = null;
        this.objectID.remove(this.player, false, false);
        this.objectID = null;
        this.area = null;
        this.modelName = null;
        this.blockList.clear();
        this.packetList.clear();
        this.placeAbleSide = null;
    }

    public void setEntityType(Class<? extends fEntity> entitySelector) {
        this.entitySelectorClass = entitySelector;
    }

    public Class<? extends fEntity> getSelectedEntityType() {
        return this.entitySelectorClass;
    }

    public boolean isSelectedClass(fEntity entity) {
        if (Objects.nonNull(entity)) {
            if (Objects.isNull(this.entitySelectorClass)) {
                return false;
            }
            return fEntity.class.equals(this.entitySelectorClass);
        }
        return false;
    }

    private /* synthetic */ void lambda$save$18(String blockData, AtomicInteger counter, FileConfiguration file, Block block) {
        String key = blockData + "." + counter.getAndIncrement() + ".";
        Relative relative = new Relative(block.getLocation(), this.getStartLocation().getBlock().getLocation());
        if (FurnitureLib.isNewVersion()) {
            file.set(key + "blockData", (Object)block.getBlockData().getAsString());
            file.set(key + "xOffset", (Object)relative.getOffsetX());
            file.set(key + "yOffset", (Object)relative.getOffsetY());
            file.set(key + "zOffset", (Object)relative.getOffsetZ());
            if (Skull.class.isInstance(block.getState())) {
                try {
                    WrappedGameProfile profile = CraftSkull.extractGameProfile(block.getState());
                    if (Objects.nonNull(profile)) {
                        file.set(key + "gameProfile.uuid", (Object)profile.getUUID().toString());
                        file.set(key + "gameProfile.name", (Object)profile.getName());
                        profile.getProperties().asMap().entrySet().stream().forEach(entry -> {
                            String propertieKey = key + "gameProfile." + (String)entry.getKey();
                            Collection collection = (Collection)entry.getValue();
                            if (!collection.isEmpty()) {
                                collection.stream().forEach(propertie -> {
                                    file.set(propertieKey + ".value", (Object)propertie.getValue());
                                    file.set(propertieKey + ".signature", (Object)propertie.getSignature());
                                });
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            file.set(key + "Type", (Object)block.getType().name());
            file.set(key + "Data", (Object)block.getState().getData().getData());
            file.set(key + "X-Offset", (Object)relative.getOffsetX());
            file.set(key + "Y-Offset", (Object)relative.getOffsetY());
            file.set(key + "Z-Offset", (Object)relative.getOffsetZ());
            MaterialData data = block.getState().getData();
            if (data instanceof Directional) {
                file.set(key + "Rotation", (Object)((Directional)data).getFacing().name());
            }
            if (Skull.class.isInstance(block.getState())) {
                try {
                    WrappedGameProfile profile = CraftSkull.extractGameProfile(block.getState());
                    if (Objects.nonNull(profile)) {
                        file.set(key + "gameProfile.uuid", (Object)profile.getUUID().toString());
                        file.set(key + "gameProfile.name", (Object)profile.getName());
                        profile.getProperties().asMap().entrySet().stream().forEach(entry -> {
                            String propertieKey = key + "gameProfile." + (String)entry.getKey();
                            Collection collection = (Collection)entry.getValue();
                            if (!collection.isEmpty()) {
                                collection.stream().forEach(propertie -> {
                                    file.set(propertieKey + ".value", (Object)propertie.getValue());
                                    file.set(propertieKey + ".signature", (Object)propertie.getSignature());
                                });
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private /* synthetic */ void lambda$save$13(FileConfiguration file, String modelData, AtomicInteger counter, ProjectMetadata projectMetadata, fEntity packet) {
        if (packet instanceof fInteraction) {
            ((fInteraction)fInteraction.class.cast(packet)).setResponse(true);
        }
        if (packet instanceof fItem_display && packet.getCustomName().startsWith("#SITZ")) {
            ((fItem_display)packet).setItemStack(new ItemStack(Material.AIR));
            packet.setNameVasibility(false);
        }
        file.set(modelData + "." + counter.getAndIncrement(), (Object)projectMetadata.toString(packet, this.getStartLocation()));
    }
}

